/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.command;

import java.util.List;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.ChatMessage;
import net.minecraft.server.v1_12_R1.CommandAbstract;
import net.minecraft.server.v1_12_R1.CommandBlockListenerAbstract;
import net.minecraft.server.v1_12_R1.CommandException;
import net.minecraft.server.v1_12_R1.CommandObjectiveExecutor;
import net.minecraft.server.v1_12_R1.DedicatedServer;
import net.minecraft.server.v1_12_R1.Entity;
import net.minecraft.server.v1_12_R1.EntityMinecartCommandBlock;
import net.minecraft.server.v1_12_R1.EnumChatFormat;
import net.minecraft.server.v1_12_R1.ExceptionUsage;
import net.minecraft.server.v1_12_R1.IChatBaseComponent;
import net.minecraft.server.v1_12_R1.ICommand;
import net.minecraft.server.v1_12_R1.ICommandListener;
import net.minecraft.server.v1_12_R1.MinecraftServer;
import net.minecraft.server.v1_12_R1.PlayerSelector;
import net.minecraft.server.v1_12_R1.WorldServer;
import org.apache.commons.lang.Validate;
import org.apache.logging.log4j.Level;
import org.bukkit.Location;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.ProxiedCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.v1_12_R1.command.CraftFunctionCommandSender;
import org.bukkit.craftbukkit.v1_12_R1.command.ProxiedNativeCommandSender;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftMinecartCommand;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.CommandMinecart;

public final class VanillaCommandWrapper
extends BukkitCommand {
    protected final CommandAbstract vanillaCommand;
    public static CommandSender lastSender = null;

    public VanillaCommandWrapper(CommandAbstract vanillaCommand, String usage) {
        super(vanillaCommand.getCommand(), "A Mojang provided command.", usage, vanillaCommand.getAliases());
        this.vanillaCommand = vanillaCommand;
        this.setPermission("minecraft.command." + vanillaCommand.getCommand());
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        ICommandListener icommandlistener = this.getListener(sender);
        try {
            this.dispatchVanillaCommand(sender, icommandlistener, args);
        }
        catch (CommandException commandexception) {
            ChatMessage chatmessage = new ChatMessage(commandexception.getMessage(), commandexception.getArgs());
            chatmessage.getChatModifier().setColor(EnumChatFormat.RED);
            icommandlistener.sendMessage((IChatBaseComponent)chatmessage);
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args, Location location) throws IllegalArgumentException {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)args, (String)"Arguments cannot be null");
        Validate.notNull((Object)alias, (String)"Alias cannot be null");
        return this.vanillaCommand.tabComplete(MinecraftServer.getServer(), this.getListener(sender), args, location == null ? null : new BlockPosition(location.getX(), location.getY(), location.getZ()));
    }

    /*
     * Loose catch block
     */
    public final int dispatchVanillaCommand(CommandSender bSender, ICommandListener icommandlistener, String[] as) throws CommandException {
        int j;
        block24: {
            int i = this.getPlayerListSize(as);
            j = 0;
            WorldServer[] prev = MinecraftServer.getServer().worldServer;
            MinecraftServer server = MinecraftServer.getServer();
            server.worldServer = new WorldServer[server.worlds.size()];
            server.worldServer[0] = (WorldServer)icommandlistener.getWorld();
            int bpos = 0;
            int pos = 1;
            while (pos < server.worldServer.length) {
                WorldServer world;
                if (server.worldServer[0] == (world = (WorldServer)server.worlds.get(bpos++))) {
                    --pos;
                } else {
                    server.worldServer[pos] = world;
                }
                ++pos;
            }
            try {
                try {
                    if (this.vanillaCommand.canUse(server, icommandlistener)) {
                        if (i > -1) {
                            List list = PlayerSelector.getPlayers((ICommandListener)icommandlistener, (String)as[i], Entity.class);
                            String s2 = as[i];
                            icommandlistener.a(CommandObjectiveExecutor.EnumCommandResult.AFFECTED_ENTITIES, list.size());
                            for (Entity entity : list) {
                                CommandSender oldSender = lastSender;
                                lastSender = bSender;
                                try {
                                    as[i] = entity.getUniqueID().toString();
                                    this.vanillaCommand.execute(server, icommandlistener, as);
                                    ++j;
                                }
                                catch (ExceptionUsage exceptionusage) {
                                    ChatMessage chatmessage = new ChatMessage("commands.generic.usage", new Object[]{new ChatMessage(exceptionusage.getMessage(), exceptionusage.getArgs())});
                                    chatmessage.getChatModifier().setColor(EnumChatFormat.RED);
                                    icommandlistener.sendMessage((IChatBaseComponent)chatmessage);
                                    lastSender = oldSender;
                                    continue;
                                }
                                catch (CommandException commandexception) {
                                    try {
                                        CommandAbstract.a((ICommandListener)icommandlistener, (ICommand)this.vanillaCommand, (int)0, (String)commandexception.getMessage(), (Object[])commandexception.getArgs());
                                        continue;
                                    }
                                    catch (Throwable throwable) {
                                        throw throwable;
                                    }
                                    finally {
                                        lastSender = oldSender;
                                    }
                                }
                                lastSender = oldSender;
                            }
                            as[i] = s2;
                            break block24;
                        }
                        icommandlistener.a(CommandObjectiveExecutor.EnumCommandResult.AFFECTED_ENTITIES, 1);
                        this.vanillaCommand.execute(server, icommandlistener, as);
                        ++j;
                        break block24;
                    }
                    ChatMessage chatmessage = new ChatMessage("commands.generic.permission", new Object[0]);
                    chatmessage.getChatModifier().setColor(EnumChatFormat.RED);
                    icommandlistener.sendMessage((IChatBaseComponent)chatmessage);
                }
                catch (ExceptionUsage exceptionusage) {
                    ChatMessage chatmessage1 = new ChatMessage("commands.generic.usage", new Object[]{new ChatMessage(exceptionusage.getMessage(), exceptionusage.getArgs())});
                    chatmessage1.getChatModifier().setColor(EnumChatFormat.RED);
                    icommandlistener.sendMessage((IChatBaseComponent)chatmessage1);
                    icommandlistener.a(CommandObjectiveExecutor.EnumCommandResult.SUCCESS_COUNT, j);
                    MinecraftServer.getServer().worldServer = prev;
                }
                catch (CommandException commandexception) {
                    CommandAbstract.a((ICommandListener)icommandlistener, (ICommand)this.vanillaCommand, (int)0, (String)commandexception.getMessage(), (Object[])commandexception.getArgs());
                    icommandlistener.a(CommandObjectiveExecutor.EnumCommandResult.SUCCESS_COUNT, j);
                    MinecraftServer.getServer().worldServer = prev;
                }
                catch (Throwable throwable) {
                    block25: {
                        ChatMessage chatmessage3 = new ChatMessage("commands.generic.exception", new Object[0]);
                        chatmessage3.getChatModifier().setColor(EnumChatFormat.RED);
                        icommandlistener.sendMessage((IChatBaseComponent)chatmessage3);
                        if (icommandlistener.f() instanceof EntityMinecartCommandBlock) {
                            MinecraftServer.LOGGER.log(Level.WARN, String.format("MinecartCommandBlock at (%d,%d,%d) failed to handle command", icommandlistener.getChunkCoordinates().getX(), icommandlistener.getChunkCoordinates().getY(), icommandlistener.getChunkCoordinates().getZ()), throwable);
                            break block25;
                        }
                        if (icommandlistener instanceof CommandBlockListenerAbstract) {
                            CommandBlockListenerAbstract listener = (CommandBlockListenerAbstract)icommandlistener;
                            MinecraftServer.LOGGER.log(Level.WARN, String.format("CommandBlock at (%d,%d,%d) failed to handle command", listener.getChunkCoordinates().getX(), listener.getChunkCoordinates().getY(), listener.getChunkCoordinates().getZ()), throwable);
                            break block25;
                        }
                        MinecraftServer.LOGGER.log(Level.WARN, String.format("Unknown CommandBlock failed to handle command", new Object[0]), throwable);
                        {
                            catch (Throwable throwable2) {
                                throw throwable2;
                            }
                        }
                    }
                    icommandlistener.a(CommandObjectiveExecutor.EnumCommandResult.SUCCESS_COUNT, j);
                    MinecraftServer.getServer().worldServer = prev;
                }
            }
            finally {
                icommandlistener.a(CommandObjectiveExecutor.EnumCommandResult.SUCCESS_COUNT, j);
                MinecraftServer.getServer().worldServer = prev;
            }
        }
        return j;
    }

    private ICommandListener getListener(CommandSender sender) {
        if (sender instanceof Player) {
            return ((CraftPlayer)sender).getHandle();
        }
        if (sender instanceof BlockCommandSender) {
            return ((CraftBlockCommandSender)sender).getTileEntity();
        }
        if (sender instanceof CommandMinecart) {
            return ((CraftMinecartCommand)sender).getHandle().getCommandBlock();
        }
        if (sender instanceof RemoteConsoleCommandSender) {
            return ((DedicatedServer)MinecraftServer.getServer()).remoteControlCommandListener;
        }
        if (sender instanceof ConsoleCommandSender) {
            return ((CraftServer)sender.getServer()).getServer();
        }
        if (sender instanceof ProxiedCommandSender) {
            return ((ProxiedNativeCommandSender)sender).getHandle();
        }
        if (sender instanceof CraftFunctionCommandSender) {
            return ((CraftFunctionCommandSender)sender).getHandle();
        }
        throw new IllegalArgumentException("Cannot make " + sender + " a vanilla command listener");
    }

    private int getPlayerListSize(String[] as) throws CommandException {
        int i = 0;
        while (i < as.length) {
            if (this.vanillaCommand.isListStart(as, i) && PlayerSelector.isList((String)as[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String[] dropFirstArgument(String[] as) {
        String[] as1 = new String[as.length - 1];
        int i = 1;
        while (i < as.length) {
            as1[i - 1] = as[i];
            ++i;
        }
        return as1;
    }
}

