/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.entity;

import com.google.common.base.Preconditions;
import java.util.Set;
import net.minecraft.server.v1_12_R1.BlockAnvil;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.BlockWorkbench;
import net.minecraft.server.v1_12_R1.ChatComponentText;
import net.minecraft.server.v1_12_R1.Container;
import net.minecraft.server.v1_12_R1.EntityHuman;
import net.minecraft.server.v1_12_R1.EntityLiving;
import net.minecraft.server.v1_12_R1.EntityMinecartHopper;
import net.minecraft.server.v1_12_R1.EntityPlayer;
import net.minecraft.server.v1_12_R1.EntityTypes;
import net.minecraft.server.v1_12_R1.EntityVillager;
import net.minecraft.server.v1_12_R1.EnumMainHand;
import net.minecraft.server.v1_12_R1.IChatBaseComponent;
import net.minecraft.server.v1_12_R1.ICrafting;
import net.minecraft.server.v1_12_R1.IInventory;
import net.minecraft.server.v1_12_R1.IMerchant;
import net.minecraft.server.v1_12_R1.ITileEntityContainer;
import net.minecraft.server.v1_12_R1.ItemCooldown;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import net.minecraft.server.v1_12_R1.Packet;
import net.minecraft.server.v1_12_R1.PacketPlayInCloseWindow;
import net.minecraft.server.v1_12_R1.PacketPlayOutOpenWindow;
import net.minecraft.server.v1_12_R1.TileEntity;
import net.minecraft.server.v1_12_R1.TileEntityBeacon;
import net.minecraft.server.v1_12_R1.TileEntityBrewingStand;
import net.minecraft.server.v1_12_R1.TileEntityDispenser;
import net.minecraft.server.v1_12_R1.TileEntityDropper;
import net.minecraft.server.v1_12_R1.TileEntityEnchantTable;
import net.minecraft.server.v1_12_R1.TileEntityFurnace;
import net.minecraft.server.v1_12_R1.TileEntityHopper;
import net.minecraft.server.v1_12_R1.TileEntityShulkerBox;
import net.minecraft.server.v1_12_R1.World;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_12_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftContainer;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMerchant;
import org.bukkit.craftbukkit.v1_12_R1.inventory.InventoryWrapper;
import org.bukkit.craftbukkit.v1_12_R1.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Villager;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;

public class CraftHumanEntity
extends CraftLivingEntity
implements HumanEntity {
    private CraftInventoryPlayer inventory;
    private final CraftInventory enderChest;
    protected final PermissibleBase perm = new PermissibleBase(this);
    private boolean op;
    private GameMode mode;

    public CraftHumanEntity(CraftServer server, EntityHuman entity) {
        super(server, (EntityLiving)entity);
        this.mode = server.getDefaultGameMode();
        this.inventory = new CraftInventoryPlayer(entity.inventory);
        this.enderChest = new CraftInventory((IInventory)entity.getEnderChest());
    }

    @Override
    public String getName() {
        return this.getHandle().getName();
    }

    @Override
    public PlayerInventory getInventory() {
        return this.inventory;
    }

    @Override
    public EntityEquipment getEquipment() {
        return this.inventory;
    }

    @Override
    public Inventory getEnderChest() {
        return this.enderChest;
    }

    @Override
    public MainHand getMainHand() {
        return this.getHandle().getMainHand() == EnumMainHand.LEFT ? MainHand.LEFT : MainHand.RIGHT;
    }

    @Override
    public ItemStack getItemInHand() {
        return this.getInventory().getItemInHand();
    }

    @Override
    public void setItemInHand(ItemStack item) {
        this.getInventory().setItemInHand(item);
    }

    @Override
    public ItemStack getItemOnCursor() {
        return CraftItemStack.asCraftMirror(this.getHandle().inventory.getCarried());
    }

    @Override
    public void setItemOnCursor(ItemStack item) {
        net.minecraft.server.v1_12_R1.ItemStack stack = CraftItemStack.asNMSCopy(item);
        this.getHandle().inventory.setCarried(stack);
        if (this instanceof CraftPlayer) {
            ((EntityPlayer)this.getHandle()).broadcastCarriedItem();
        }
    }

    @Override
    public boolean isSleeping() {
        return this.getHandle().sleeping;
    }

    @Override
    public int getSleepTicks() {
        return this.getHandle().sleepTicks;
    }

    @Override
    public boolean isOp() {
        return this.op;
    }

    @Override
    public boolean isPermissionSet(String name) {
        return this.perm.isPermissionSet(name);
    }

    @Override
    public boolean isPermissionSet(Permission perm) {
        return this.perm.isPermissionSet(perm);
    }

    @Override
    public boolean hasPermission(String name) {
        return this.perm.hasPermission(name);
    }

    @Override
    public boolean hasPermission(Permission perm) {
        return this.perm.hasPermission(perm);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return this.perm.addAttachment(plugin, name, value);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin) {
        return this.perm.addAttachment(plugin);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return this.perm.addAttachment(plugin, name, value, ticks);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return this.perm.addAttachment(plugin, ticks);
    }

    @Override
    public void removeAttachment(PermissionAttachment attachment) {
        this.perm.removeAttachment(attachment);
    }

    @Override
    public void recalculatePermissions() {
        this.perm.recalculatePermissions();
    }

    @Override
    public void setOp(boolean value) {
        this.op = value;
        this.perm.recalculatePermissions();
    }

    @Override
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return this.perm.getEffectivePermissions();
    }

    @Override
    public GameMode getGameMode() {
        return this.mode;
    }

    @Override
    public void setGameMode(GameMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Mode cannot be null");
        }
        this.mode = mode;
    }

    public EntityHuman getHandle() {
        return (EntityHuman)this.entity;
    }

    public void setHandle(EntityHuman entity) {
        super.setHandle((EntityLiving)entity);
        this.inventory = new CraftInventoryPlayer(entity.inventory);
    }

    @Override
    public String toString() {
        return "CraftHumanEntity{id=" + this.getEntityId() + "name=" + this.getName() + '}';
    }

    @Override
    public InventoryView getOpenInventory() {
        return this.getHandle().activeContainer.getBukkitView();
    }

    @Override
    public InventoryView openInventory(Inventory inventory) {
        if (!(this.getHandle() instanceof EntityPlayer)) {
            return null;
        }
        EntityPlayer player = (EntityPlayer)this.getHandle();
        InventoryType type = inventory.getType();
        Container formerContainer = this.getHandle().activeContainer;
        InventoryWrapper iinventory = inventory instanceof CraftInventory ? ((CraftInventory)inventory).getInventory() : new InventoryWrapper(inventory);
        switch (type) {
            case CHEST: 
            case PLAYER: 
            case ENDER_CHEST: {
                this.getHandle().openContainer((IInventory)iinventory);
                break;
            }
            case DISPENSER: {
                if (iinventory instanceof TileEntityDispenser) {
                    this.getHandle().openContainer((IInventory)((TileEntityDispenser)iinventory));
                    break;
                }
                this.openCustomInventory(inventory, player, "minecraft:dispenser");
                break;
            }
            case DROPPER: {
                if (iinventory instanceof TileEntityDropper) {
                    this.getHandle().openContainer((IInventory)((TileEntityDropper)iinventory));
                    break;
                }
                this.openCustomInventory(inventory, player, "minecraft:dropper");
                break;
            }
            case FURNACE: {
                if (iinventory instanceof TileEntityFurnace) {
                    this.getHandle().openContainer((IInventory)((TileEntityFurnace)iinventory));
                    break;
                }
                this.openCustomInventory(inventory, player, "minecraft:furnace");
                break;
            }
            case WORKBENCH: {
                this.openCustomInventory(inventory, player, "minecraft:crafting_table");
                break;
            }
            case BREWING: {
                if (iinventory instanceof TileEntityBrewingStand) {
                    this.getHandle().openContainer((IInventory)((TileEntityBrewingStand)iinventory));
                    break;
                }
                this.openCustomInventory(inventory, player, "minecraft:brewing_stand");
                break;
            }
            case ENCHANTING: {
                this.openCustomInventory(inventory, player, "minecraft:enchanting_table");
                break;
            }
            case HOPPER: {
                if (iinventory instanceof TileEntityHopper) {
                    this.getHandle().openContainer((IInventory)((TileEntityHopper)iinventory));
                    break;
                }
                if (iinventory instanceof EntityMinecartHopper) {
                    this.getHandle().openContainer((IInventory)((EntityMinecartHopper)iinventory));
                    break;
                }
                this.openCustomInventory(inventory, player, "minecraft:hopper");
                break;
            }
            case BEACON: {
                if (iinventory instanceof TileEntityBeacon) {
                    this.getHandle().openContainer((IInventory)((TileEntityBeacon)iinventory));
                    break;
                }
                this.openCustomInventory(inventory, player, "minecraft:beacon");
                break;
            }
            case ANVIL: {
                if (iinventory instanceof BlockAnvil.TileEntityContainerAnvil) {
                    this.getHandle().openTileEntity((ITileEntityContainer)((BlockAnvil.TileEntityContainerAnvil)iinventory));
                    break;
                }
                this.openCustomInventory(inventory, player, "minecraft:anvil");
                break;
            }
            case SHULKER_BOX: {
                if (iinventory instanceof TileEntityShulkerBox) {
                    this.getHandle().openContainer((IInventory)((TileEntityShulkerBox)iinventory));
                    break;
                }
                this.openCustomInventory(inventory, player, "minecraft:shulker_box");
                break;
            }
            case CRAFTING: 
            case CREATIVE: {
                throw new IllegalArgumentException("Can't open a " + (Object)((Object)type) + " inventory!");
            }
        }
        if (this.getHandle().activeContainer == formerContainer) {
            return null;
        }
        this.getHandle().activeContainer.checkReachable = false;
        return this.getHandle().activeContainer.getBukkitView();
    }

    private void openCustomInventory(Inventory inventory, EntityPlayer player, String windowType) {
        if (player.playerConnection == null) {
            return;
        }
        CraftContainer container = new CraftContainer(inventory, this.getHandle(), player.nextContainerCounter());
        if ((container = CraftEventFactory.callInventoryOpenEvent(player, container)) == null) {
            return;
        }
        String title = container.getBukkitView().getTitle();
        int size = container.getBukkitView().getTopInventory().getSize();
        if (windowType.equals("minecraft:crafting_table") || windowType.equals("minecraft:anvil") || windowType.equals("minecraft:enchanting_table")) {
            size = 0;
        }
        player.playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(container.windowId, windowType, (IChatBaseComponent)new ChatComponentText(title), size));
        this.getHandle().activeContainer = container;
        this.getHandle().activeContainer.addSlotListener((ICrafting)player);
    }

    @Override
    public InventoryView openWorkbench(Location location, boolean force) {
        Block block;
        if (!force && (block = location.getBlock()).getType() != Material.WORKBENCH) {
            return null;
        }
        if (location == null) {
            location = this.getLocation();
        }
        this.getHandle().openTileEntity((ITileEntityContainer)new BlockWorkbench.TileEntityContainerWorkbench(this.getHandle().world, new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ())));
        if (force) {
            this.getHandle().activeContainer.checkReachable = false;
        }
        return this.getHandle().activeContainer.getBukkitView();
    }

    @Override
    public InventoryView openEnchanting(Location location, boolean force) {
        BlockPosition pos;
        TileEntity container;
        Block block;
        if (!force && (block = location.getBlock()).getType() != Material.ENCHANTMENT_TABLE) {
            return null;
        }
        if (location == null) {
            location = this.getLocation();
        }
        if ((container = this.getHandle().world.getTileEntity(pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()))) == null && force) {
            container = new TileEntityEnchantTable();
            container.a(this.getHandle().world);
            container.setPosition(pos);
        }
        this.getHandle().openTileEntity((ITileEntityContainer)container);
        if (force) {
            this.getHandle().activeContainer.checkReachable = false;
        }
        return this.getHandle().activeContainer.getBukkitView();
    }

    @Override
    public void openInventory(InventoryView inventory) {
        if (!(this.getHandle() instanceof EntityPlayer)) {
            return;
        }
        if (((EntityPlayer)this.getHandle()).playerConnection == null) {
            return;
        }
        if (this.getHandle().activeContainer != this.getHandle().defaultContainer) {
            ((EntityPlayer)this.getHandle()).playerConnection.a(new PacketPlayInCloseWindow(this.getHandle().activeContainer.windowId));
        }
        EntityPlayer player = (EntityPlayer)this.getHandle();
        Object container = inventory instanceof CraftInventoryView ? ((CraftInventoryView)inventory).getHandle() : new CraftContainer(inventory, this.getHandle(), player.nextContainerCounter());
        if ((container = CraftEventFactory.callInventoryOpenEvent(player, container)) == null) {
            return;
        }
        InventoryType type = inventory.getType();
        String windowType = CraftContainer.getNotchInventoryType(type);
        String title = inventory.getTitle();
        int size = inventory.getTopInventory().getSize();
        player.playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(container.windowId, windowType, (IChatBaseComponent)new ChatComponentText(title), size));
        player.activeContainer = container;
        player.activeContainer.addSlotListener((ICrafting)player);
    }

    @Override
    public InventoryView openMerchant(Villager villager, boolean force) {
        Preconditions.checkNotNull((Object)villager, (Object)"villager cannot be null");
        return this.openMerchant((Merchant)villager, force);
    }

    @Override
    public InventoryView openMerchant(Merchant merchant, boolean force) {
        EntityVillager mcMerchant;
        Preconditions.checkNotNull((Object)merchant, (Object)"merchant cannot be null");
        if (!force && merchant.isTrading()) {
            return null;
        }
        if (merchant.isTrading()) {
            merchant.getTrader().closeInventory();
        }
        if (merchant instanceof CraftVillager) {
            mcMerchant = ((CraftVillager)merchant).getHandle();
        } else if (merchant instanceof CraftMerchant) {
            mcMerchant = ((CraftMerchant)merchant).getMerchant();
        } else {
            throw new IllegalArgumentException("Can't open merchant " + merchant.toString());
        }
        mcMerchant.setTradingPlayer(this.getHandle());
        this.getHandle().openTrade((IMerchant)mcMerchant);
        return this.getHandle().activeContainer.getBukkitView();
    }

    @Override
    public void closeInventory() {
        this.getHandle().closeInventory();
    }

    @Override
    public boolean isBlocking() {
        return this.getHandle().isBlocking();
    }

    @Override
    public boolean isHandRaised() {
        return this.getHandle().isHandRaised();
    }

    @Override
    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        return false;
    }

    @Override
    public int getExpToLevel() {
        return this.getHandle().getExpToLevel();
    }

    @Override
    public boolean hasCooldown(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"material");
        return this.getHandle().getCooldownTracker().a(CraftMagicNumbers.getItem(material));
    }

    @Override
    public int getCooldown(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"material");
        ItemCooldown.Info cooldown = (ItemCooldown.Info)this.getHandle().getCooldownTracker().cooldowns.get(CraftMagicNumbers.getItem(material));
        return cooldown == null ? 0 : Math.max(0, cooldown.endTick - this.getHandle().getCooldownTracker().currentTick);
    }

    @Override
    public void setCooldown(Material material, int ticks) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"material");
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"Cannot have negative cooldown");
        this.getHandle().getCooldownTracker().a(CraftMagicNumbers.getItem(material), ticks);
    }

    @Override
    public Entity getShoulderEntityLeft() {
        if (!this.getHandle().getShoulderEntityLeft().isEmpty()) {
            net.minecraft.server.v1_12_R1.Entity shoulder = EntityTypes.a((NBTTagCompound)this.getHandle().getShoulderEntityLeft(), (World)this.getHandle().world);
            return shoulder == null ? null : shoulder.getBukkitEntity();
        }
        return null;
    }

    @Override
    public void setShoulderEntityLeft(Entity entity) {
        this.getHandle().setShoulderEntityLeft(entity == null ? new NBTTagCompound() : ((CraftEntity)entity).save());
        if (entity != null) {
            entity.remove();
        }
    }

    @Override
    public Entity getShoulderEntityRight() {
        if (!this.getHandle().getShoulderEntityRight().isEmpty()) {
            net.minecraft.server.v1_12_R1.Entity shoulder = EntityTypes.a((NBTTagCompound)this.getHandle().getShoulderEntityRight(), (World)this.getHandle().world);
            return shoulder == null ? null : shoulder.getBukkitEntity();
        }
        return null;
    }

    @Override
    public void setShoulderEntityRight(Entity entity) {
        this.getHandle().setShoulderEntityRight(entity == null ? new NBTTagCompound() : ((CraftEntity)entity).save());
        if (entity != null) {
            entity.remove();
        }
    }
}

