/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.entity;

import net.minecraft.server.v1_12_R1.EntityPotion;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftThrownPotion;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftItemStack;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.inventory.ItemStack;

public class CraftLingeringPotion
extends CraftThrownPotion
implements LingeringPotion {
    public CraftLingeringPotion(CraftServer server, EntityPotion entity) {
        super(server, entity);
    }

    @Override
    public void setItem(ItemStack item) {
        Validate.notNull((Object)item, (String)"ItemStack cannot be null.");
        Validate.isTrue((item.getType() == Material.LINGERING_POTION ? 1 : 0) != 0, (String)("ItemStack must be a lingering potion. This item stack was " + (Object)((Object)item.getType()) + "."));
        this.getHandle().setItem(CraftItemStack.asNMSCopy(item));
    }

    @Override
    public EntityPotion getHandle() {
        return (EntityPotion)this.entity;
    }

    @Override
    public String toString() {
        return "CraftLingeringPotion";
    }

    @Override
    public EntityType getType() {
        return EntityType.LINGERING_POTION;
    }
}

