/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.entity;

import net.minecraft.server.v1_12_R1.Entity;
import net.minecraft.server.v1_12_R1.EntityHanging;
import net.minecraft.server.v1_12_R1.EntityPainting;
import net.minecraft.server.v1_12_R1.World;
import net.minecraft.server.v1_12_R1.WorldServer;
import org.bukkit.Art;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_12_R1.CraftArt;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftHanging;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Painting;

public class CraftPainting
extends CraftHanging
implements Painting {
    public CraftPainting(CraftServer server, EntityPainting entity) {
        super(server, (EntityHanging)entity);
    }

    @Override
    public Art getArt() {
        EntityPainting.EnumArt art = this.getHandle().art;
        return CraftArt.NotchToBukkit(art);
    }

    @Override
    public boolean setArt(Art art) {
        return this.setArt(art, false);
    }

    @Override
    public boolean setArt(Art art, boolean force) {
        EntityPainting painting = this.getHandle();
        EntityPainting.EnumArt oldArt = painting.art;
        painting.art = CraftArt.BukkitToNotch(art);
        painting.setDirection(painting.direction);
        if (!force && !painting.survives()) {
            painting.art = oldArt;
            painting.setDirection(painting.direction);
            return false;
        }
        this.update();
        return true;
    }

    @Override
    public boolean setFacingDirection(BlockFace face, boolean force) {
        if (super.setFacingDirection(face, force)) {
            this.update();
            return true;
        }
        return false;
    }

    private void update() {
        WorldServer world = ((CraftWorld)this.getWorld()).getHandle();
        EntityPainting painting = new EntityPainting((World)world);
        painting.blockPosition = this.getHandle().blockPosition;
        painting.art = this.getHandle().art;
        painting.setDirection(this.getHandle().direction);
        this.getHandle().die();
        this.getHandle().velocityChanged = true;
        world.addEntity((Entity)painting);
        this.entity = painting;
    }

    public EntityPainting getHandle() {
        return (EntityPainting)this.entity;
    }

    @Override
    public String toString() {
        return "CraftPainting{art=" + (Object)((Object)this.getArt()) + "}";
    }

    @Override
    public EntityType getType() {
        return EntityType.PAINTING;
    }
}

