/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.entity;

import net.minecraft.server.v1_12_R1.EntityPotion;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftThrownPotion;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftItemStack;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.SplashPotion;
import org.bukkit.inventory.ItemStack;

public class CraftSplashPotion
extends CraftThrownPotion
implements SplashPotion {
    public CraftSplashPotion(CraftServer server, EntityPotion entity) {
        super(server, entity);
    }

    @Override
    public void setItem(ItemStack item) {
        Validate.notNull((Object)item, (String)"ItemStack cannot be null.");
        Validate.isTrue((item.getType() == Material.SPLASH_POTION ? 1 : 0) != 0, (String)("ItemStack must be a splash potion. This item stack was " + (Object)((Object)item.getType()) + "."));
        this.getHandle().setItem(CraftItemStack.asNMSCopy(item));
    }

    @Override
    public EntityPotion getHandle() {
        return (EntityPotion)this.entity;
    }

    @Override
    public String toString() {
        return "CraftSplashPotion";
    }

    @Override
    public EntityType getType() {
        return EntityType.SPLASH_POTION;
    }
}

