/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.entity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.server.v1_12_R1.EntityArrow;
import net.minecraft.server.v1_12_R1.EntityTippedArrow;
import net.minecraft.server.v1_12_R1.MobEffect;
import net.minecraft.server.v1_12_R1.MobEffectList;
import org.apache.commons.lang.Validate;
import org.bukkit.Color;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftArrow;
import org.bukkit.craftbukkit.v1_12_R1.potion.CraftPotionUtil;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TippedArrow;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class CraftTippedArrow
extends CraftArrow
implements TippedArrow {
    public CraftTippedArrow(CraftServer server, EntityTippedArrow entity) {
        super(server, (EntityArrow)entity);
    }

    public EntityTippedArrow getHandle() {
        return (EntityTippedArrow)this.entity;
    }

    @Override
    public String toString() {
        return "CraftTippedArrow";
    }

    @Override
    public EntityType getType() {
        return EntityType.TIPPED_ARROW;
    }

    @Override
    public boolean addCustomEffect(PotionEffect effect, boolean override) {
        int effectId = effect.getType().getId();
        MobEffect existing = null;
        for (MobEffect mobEffect : this.getHandle().effects) {
            if (MobEffectList.getId((MobEffectList)mobEffect.getMobEffect()) != effectId) continue;
            existing = mobEffect;
        }
        if (existing != null) {
            if (!override) {
                return false;
            }
            this.getHandle().effects.remove(existing);
        }
        this.getHandle().a(CraftPotionUtil.fromBukkit(effect));
        this.getHandle().refreshEffects();
        return true;
    }

    @Override
    public void clearCustomEffects() {
        Validate.isTrue((this.getBasePotionData().getType() != PotionType.UNCRAFTABLE ? 1 : 0) != 0, (String)"Tipped Arrows must have at least 1 effect");
        this.getHandle().effects.clear();
        this.getHandle().refreshEffects();
    }

    @Override
    public List<PotionEffect> getCustomEffects() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MobEffect effect : this.getHandle().effects) {
            builder.add((Object)CraftPotionUtil.toBukkit(effect));
        }
        return builder.build();
    }

    @Override
    public boolean hasCustomEffect(PotionEffectType type) {
        for (MobEffect effect : this.getHandle().effects) {
            if (!CraftPotionUtil.equals(effect.getMobEffect(), type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCustomEffects() {
        return !this.getHandle().effects.isEmpty();
    }

    @Override
    public boolean removeCustomEffect(PotionEffectType effect) {
        int effectId = effect.getId();
        MobEffect existing = null;
        for (MobEffect mobEffect : this.getHandle().effects) {
            if (MobEffectList.getId((MobEffectList)mobEffect.getMobEffect()) != effectId) continue;
            existing = mobEffect;
        }
        if (existing == null) {
            return false;
        }
        Validate.isTrue((this.getBasePotionData().getType() != PotionType.UNCRAFTABLE || !this.getHandle().effects.isEmpty() ? 1 : 0) != 0, (String)"Tipped Arrows must have at least 1 effect");
        this.getHandle().effects.remove(existing);
        this.getHandle().refreshEffects();
        return true;
    }

    @Override
    public void setBasePotionData(PotionData data) {
        Validate.notNull((Object)data, (String)"PotionData cannot be null");
        Validate.isTrue((data.getType() != PotionType.UNCRAFTABLE || !this.getHandle().effects.isEmpty() ? 1 : 0) != 0, (String)"Tipped Arrows must have at least 1 effect");
        this.getHandle().setType(CraftPotionUtil.fromBukkit(data));
    }

    @Override
    public PotionData getBasePotionData() {
        return CraftPotionUtil.toBukkit(this.getHandle().getType());
    }

    @Override
    public void setColor(Color color) {
        this.getHandle().setColor(color.asRGB());
    }

    @Override
    public Color getColor() {
        return Color.fromRGB(this.getHandle().getColor());
    }
}

