/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.generator;

import java.util.List;
import java.util.Random;
import net.minecraft.server.v1_12_R1.BiomeBase;
import net.minecraft.server.v1_12_R1.Block;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.Chunk;
import net.minecraft.server.v1_12_R1.ChunkSection;
import net.minecraft.server.v1_12_R1.EnumCreatureType;
import net.minecraft.server.v1_12_R1.WorldGenStronghold;
import net.minecraft.server.v1_12_R1.WorldServer;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_12_R1.generator.CraftChunkData;
import org.bukkit.craftbukkit.v1_12_R1.generator.InternalChunkGenerator;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;

public class CustomChunkGenerator
extends InternalChunkGenerator {
    private final ChunkGenerator generator;
    private final WorldServer world;
    private final Random random;
    private final WorldGenStronghold strongholdGen = new WorldGenStronghold();

    public CustomChunkGenerator(net.minecraft.server.v1_12_R1.World world, long seed, ChunkGenerator generator) {
        this.world = (WorldServer)world;
        this.generator = generator;
        this.random = new Random(seed);
    }

    public Chunk getOrCreateChunk(int x, int z) {
        int i;
        int sec;
        ChunkSection[] csect;
        Chunk chunk;
        this.random.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        CustomBiomeGrid biomegrid = new CustomBiomeGrid();
        biomegrid.biome = new BiomeBase[256];
        this.world.getWorldChunkManager().getBiomeBlock(biomegrid.biome, x << 4, z << 4, 16, 16);
        CraftChunkData data = (CraftChunkData)this.generator.generateChunkData(this.world.getWorld(), this.random, x, z, biomegrid);
        if (data != null) {
            char[][] sections = data.getRawChunkData();
            chunk = new Chunk((net.minecraft.server.v1_12_R1.World)this.world, x, z);
            csect = chunk.getSections();
            int scnt = Math.min(csect.length, sections.length);
            sec = 0;
            while (sec < scnt) {
                if (sections[sec] != null) {
                    char[] section = sections[sec];
                    char emptyTest = '\u0000';
                    i = 0;
                    while (i < 4096) {
                        if (Block.REGISTRY_ID.fromId((int)section[i]) == null) {
                            section[i] = '\u0000';
                        }
                        emptyTest = (char)(emptyTest | section[i]);
                        ++i;
                    }
                    if (emptyTest != '\u0000') {
                        csect[sec] = new ChunkSection(sec << 4, true, section);
                    }
                }
                ++sec;
            }
        } else {
            Block b;
            short[][] xbtypes = this.generator.generateExtBlockSections(this.world.getWorld(), this.random, x, z, biomegrid);
            if (xbtypes != null) {
                chunk = new Chunk((net.minecraft.server.v1_12_R1.World)this.world, x, z);
                csect = chunk.getSections();
                int scnt = Math.min(csect.length, xbtypes.length);
                sec = 0;
                while (sec < scnt) {
                    if (xbtypes[sec] != null) {
                        char[] secBlkID = new char[4096];
                        short[] bdata = xbtypes[sec];
                        i = 0;
                        while (i < bdata.length) {
                            b = Block.getById((int)bdata[i]);
                            secBlkID[i] = (char)Block.REGISTRY_ID.getId((Object)b.getBlockData());
                            ++i;
                        }
                        csect[sec] = new ChunkSection(sec << 4, true, secBlkID);
                    }
                    ++sec;
                }
            } else {
                byte[][] btypes = this.generator.generateBlockSections(this.world.getWorld(), this.random, x, z, biomegrid);
                if (btypes != null) {
                    chunk = new Chunk((net.minecraft.server.v1_12_R1.World)this.world, x, z);
                    ChunkSection[] csect2 = chunk.getSections();
                    int scnt = Math.min(csect2.length, btypes.length);
                    int sec2 = 0;
                    while (sec2 < scnt) {
                        if (btypes[sec2] != null) {
                            char[] secBlkID = new char[4096];
                            i = 0;
                            while (i < secBlkID.length) {
                                b = Block.getById((int)(btypes[sec2][i] & 0xFF));
                                secBlkID[i] = (char)Block.REGISTRY_ID.getId((Object)b.getBlockData());
                                ++i;
                            }
                            csect2[sec2] = new ChunkSection(sec2 << 4, true, secBlkID);
                        }
                        ++sec2;
                    }
                } else {
                    byte[] types = this.generator.generate(this.world.getWorld(), this.random, x, z);
                    int ydim = types.length / 256;
                    int scnt = ydim / 16;
                    chunk = new Chunk((net.minecraft.server.v1_12_R1.World)this.world, x, z);
                    ChunkSection[] csect3 = chunk.getSections();
                    scnt = Math.min(scnt, csect3.length);
                    int sec3 = 0;
                    while (sec3 < scnt) {
                        char[] csbytes = null;
                        int cy = 0;
                        while (cy < 16) {
                            int cyoff = cy | sec3 << 4;
                            int cx = 0;
                            while (cx < 16) {
                                int cxyoff = cx * ydim * 16 + cyoff;
                                int cz = 0;
                                while (cz < 16) {
                                    byte blk = types[cxyoff + cz * ydim];
                                    if (blk != 0) {
                                        if (csbytes == null) {
                                            csbytes = new char[4096];
                                        }
                                        Block b2 = Block.getById((int)(blk & 0xFF));
                                        csbytes[cy << 8 | cz << 4 | cx] = (char)Block.REGISTRY_ID.getId((Object)b2.getBlockData());
                                    }
                                    ++cz;
                                }
                                ++cx;
                            }
                            ++cy;
                        }
                        if (csbytes != null) {
                            ChunkSection cs = csect3[sec3] = new ChunkSection(sec3 << 4, true, csbytes);
                            cs.recalcBlockCounts();
                        }
                        ++sec3;
                    }
                }
            }
        }
        byte[] biomeIndex = chunk.getBiomeIndex();
        int i2 = 0;
        while (i2 < biomeIndex.length) {
            biomeIndex[i2] = (byte)(BiomeBase.REGISTRY_ID.a((Object)biomegrid.biome[i2]) & 0xFF);
            ++i2;
        }
        chunk.initLighting();
        return chunk;
    }

    public boolean a(Chunk chunk, int i, int i1) {
        return false;
    }

    @Override
    public byte[] generate(World world, Random random, int x, int z) {
        return this.generator.generate(world, random, x, z);
    }

    @Override
    public byte[][] generateBlockSections(World world, Random random, int x, int z, ChunkGenerator.BiomeGrid biomes) {
        return this.generator.generateBlockSections(world, random, x, z, biomes);
    }

    @Override
    public short[][] generateExtBlockSections(World world, Random random, int x, int z, ChunkGenerator.BiomeGrid biomes) {
        return this.generator.generateExtBlockSections(world, random, x, z, biomes);
    }

    public Chunk getChunkAt(int x, int z) {
        return this.getOrCreateChunk(x, z);
    }

    @Override
    public boolean canSpawn(World world, int x, int z) {
        return this.generator.canSpawn(world, x, z);
    }

    @Override
    public List<BlockPopulator> getDefaultPopulators(World world) {
        return this.generator.getDefaultPopulators(world);
    }

    public List<BiomeBase.BiomeMeta> getMobsFor(EnumCreatureType type, BlockPosition position) {
        BiomeBase biomebase = this.world.getBiome(position);
        return biomebase == null ? null : biomebase.getMobs(type);
    }

    public boolean a(net.minecraft.server.v1_12_R1.World world, String type, BlockPosition position) {
        return "Stronghold".equals(type) && this.strongholdGen != null ? this.strongholdGen.b(position) : false;
    }

    public BlockPosition findNearestMapFeature(net.minecraft.server.v1_12_R1.World world, String type, BlockPosition position, boolean flag) {
        return "Stronghold".equals(type) && this.strongholdGen != null ? this.strongholdGen.getNearestGeneratedFeature(world, position, flag) : null;
    }

    public void recreateStructures(int i, int j) {
    }

    public void recreateStructures(Chunk chunk, int i, int j) {
        this.strongholdGen.a((net.minecraft.server.v1_12_R1.World)this.world, i, j, null);
    }

    private static class CustomBiomeGrid
    implements ChunkGenerator.BiomeGrid {
        BiomeBase[] biome;

        private CustomBiomeGrid() {
        }

        @Override
        public Biome getBiome(int x, int z) {
            return CraftBlock.biomeBaseToBiome(this.biome[z << 4 | x]);
        }

        @Override
        public void setBiome(int x, int z, Biome bio) {
            this.biome[z << 4 | x] = CraftBlock.biomeToBiomeBase(bio);
        }
    }
}

