/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.inventory;

import net.minecraft.server.v1_12_R1.IInventory;
import net.minecraft.server.v1_12_R1.ITileInventory;
import net.minecraft.server.v1_12_R1.InventoryLargeChest;
import org.bukkit.Location;
import org.bukkit.block.DoubleChest;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftInventory;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CraftInventoryDoubleChest
extends CraftInventory
implements DoubleChestInventory {
    private final CraftInventory left;
    private final CraftInventory right;

    public CraftInventoryDoubleChest(CraftInventory left, CraftInventory right) {
        super((IInventory)new InventoryLargeChest("Large chest", (ITileInventory)left.getInventory(), (ITileInventory)right.getInventory()));
        this.left = left;
        this.right = right;
    }

    public CraftInventoryDoubleChest(InventoryLargeChest largeChest) {
        super((IInventory)largeChest);
        this.left = largeChest.left instanceof InventoryLargeChest ? new CraftInventoryDoubleChest((InventoryLargeChest)largeChest.left) : new CraftInventory((IInventory)largeChest.left);
        this.right = largeChest.right instanceof InventoryLargeChest ? new CraftInventoryDoubleChest((InventoryLargeChest)largeChest.right) : new CraftInventory((IInventory)largeChest.right);
    }

    @Override
    public Inventory getLeftSide() {
        return this.left;
    }

    @Override
    public Inventory getRightSide() {
        return this.right;
    }

    @Override
    public void setContents(ItemStack[] items) {
        if (this.getInventory().getSize() < items.length) {
            throw new IllegalArgumentException("Invalid inventory size; expected " + this.getInventory().getSize() + " or less");
        }
        ItemStack[] leftItems = new ItemStack[this.left.getSize()];
        ItemStack[] rightItems = new ItemStack[this.right.getSize()];
        System.arraycopy(items, 0, leftItems, 0, Math.min(this.left.getSize(), items.length));
        this.left.setContents(leftItems);
        if (items.length >= this.left.getSize()) {
            System.arraycopy(items, this.left.getSize(), rightItems, 0, Math.min(this.right.getSize(), items.length - this.left.getSize()));
            this.right.setContents(rightItems);
        }
    }

    @Override
    public DoubleChest getHolder() {
        return new DoubleChest(this);
    }

    @Override
    public Location getLocation() {
        return this.getLeftSide().getLocation().add(this.getRightSide().getLocation()).multiply(0.5);
    }
}

