/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.inventory;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.minecraft.server.v1_12_R1.EntityHuman;
import net.minecraft.server.v1_12_R1.IMerchant;
import net.minecraft.server.v1_12_R1.MerchantRecipe;
import net.minecraft.server.v1_12_R1.MerchantRecipeList;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMerchantRecipe;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Merchant;

public class CraftMerchant
implements Merchant {
    protected final IMerchant merchant;

    public CraftMerchant(IMerchant merchant) {
        this.merchant = merchant;
    }

    public IMerchant getMerchant() {
        return this.merchant;
    }

    @Override
    public List<org.bukkit.inventory.MerchantRecipe> getRecipes() {
        return Collections.unmodifiableList(Lists.transform((List)this.merchant.getOffers(null), (Function)new Function<MerchantRecipe, org.bukkit.inventory.MerchantRecipe>(){

            public org.bukkit.inventory.MerchantRecipe apply(MerchantRecipe recipe) {
                return recipe.asBukkit();
            }
        }));
    }

    @Override
    public void setRecipes(List<org.bukkit.inventory.MerchantRecipe> recipes) {
        MerchantRecipeList recipesList = this.merchant.getOffers(null);
        recipesList.clear();
        for (org.bukkit.inventory.MerchantRecipe recipe : recipes) {
            recipesList.add((Object)CraftMerchantRecipe.fromBukkit(recipe).toMinecraft());
        }
    }

    @Override
    public org.bukkit.inventory.MerchantRecipe getRecipe(int i) {
        return ((MerchantRecipe)this.merchant.getOffers(null).get(i)).asBukkit();
    }

    @Override
    public void setRecipe(int i, org.bukkit.inventory.MerchantRecipe merchantRecipe) {
        this.merchant.getOffers(null).set(i, (Object)CraftMerchantRecipe.fromBukkit(merchantRecipe).toMinecraft());
    }

    @Override
    public int getRecipeCount() {
        return this.merchant.getOffers(null).size();
    }

    @Override
    public boolean isTrading() {
        return this.getTrader() != null;
    }

    @Override
    public HumanEntity getTrader() {
        EntityHuman eh = this.merchant.getTrader();
        return eh == null ? null : eh.getBukkitEntity();
    }

    public int hashCode() {
        return this.merchant.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CraftMerchant && ((CraftMerchant)obj).merchant.equals(this.merchant);
    }
}

