/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.inventory;

import com.google.common.base.Preconditions;
import java.util.List;
import net.minecraft.server.v1_12_R1.MerchantRecipe;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public class CraftMerchantRecipe
extends org.bukkit.inventory.MerchantRecipe {
    private final MerchantRecipe handle;

    public CraftMerchantRecipe(MerchantRecipe merchantRecipe) {
        super(CraftItemStack.asBukkitCopy(merchantRecipe.sellingItem), 0);
        this.handle = merchantRecipe;
        this.addIngredient(CraftItemStack.asBukkitCopy(merchantRecipe.buyingItem1));
        this.addIngredient(CraftItemStack.asBukkitCopy(merchantRecipe.buyingItem2));
    }

    public CraftMerchantRecipe(ItemStack result, int uses, int maxUses, boolean experienceReward) {
        super(result, uses, maxUses, experienceReward);
        this.handle = new MerchantRecipe(net.minecraft.server.v1_12_R1.ItemStack.a, net.minecraft.server.v1_12_R1.ItemStack.a, CraftItemStack.asNMSCopy(result), uses, maxUses, this);
    }

    @Override
    public int getUses() {
        return this.handle.uses;
    }

    @Override
    public void setUses(int uses) {
        this.handle.uses = uses;
    }

    @Override
    public int getMaxUses() {
        return this.handle.maxUses;
    }

    @Override
    public void setMaxUses(int maxUses) {
        this.handle.maxUses = maxUses;
    }

    @Override
    public boolean hasExperienceReward() {
        return this.handle.rewardExp;
    }

    @Override
    public void setExperienceReward(boolean flag) {
        this.handle.rewardExp = flag;
    }

    public MerchantRecipe toMinecraft() {
        List<ItemStack> ingredients = this.getIngredients();
        Preconditions.checkState((!ingredients.isEmpty() ? 1 : 0) != 0, (Object)"No offered ingredients");
        this.handle.buyingItem1 = CraftItemStack.asNMSCopy(ingredients.get(0));
        if (ingredients.size() > 1) {
            this.handle.buyingItem2 = CraftItemStack.asNMSCopy(ingredients.get(1));
        }
        return this.handle;
    }

    public static CraftMerchantRecipe fromBukkit(org.bukkit.inventory.MerchantRecipe recipe) {
        if (recipe instanceof CraftMerchantRecipe) {
            return (CraftMerchantRecipe)recipe;
        }
        CraftMerchantRecipe craft = new CraftMerchantRecipe(recipe.getResult(), recipe.getUses(), recipe.getMaxUses(), recipe.hasExperienceReward());
        craft.setIngredients(recipe.getIngredients());
        return craft;
    }
}

