/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.inventory;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.v1_12_R1.BlockJukeBox;
import net.minecraft.server.v1_12_R1.NBTBase;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import net.minecraft.server.v1_12_R1.TileEntity;
import net.minecraft.server.v1_12_R1.TileEntityBanner;
import net.minecraft.server.v1_12_R1.TileEntityBeacon;
import net.minecraft.server.v1_12_R1.TileEntityBrewingStand;
import net.minecraft.server.v1_12_R1.TileEntityChest;
import net.minecraft.server.v1_12_R1.TileEntityCommand;
import net.minecraft.server.v1_12_R1.TileEntityComparator;
import net.minecraft.server.v1_12_R1.TileEntityDispenser;
import net.minecraft.server.v1_12_R1.TileEntityDropper;
import net.minecraft.server.v1_12_R1.TileEntityEnchantTable;
import net.minecraft.server.v1_12_R1.TileEntityEndGateway;
import net.minecraft.server.v1_12_R1.TileEntityEnderChest;
import net.minecraft.server.v1_12_R1.TileEntityFlowerPot;
import net.minecraft.server.v1_12_R1.TileEntityFurnace;
import net.minecraft.server.v1_12_R1.TileEntityHopper;
import net.minecraft.server.v1_12_R1.TileEntityLightDetector;
import net.minecraft.server.v1_12_R1.TileEntityMobSpawner;
import net.minecraft.server.v1_12_R1.TileEntityNote;
import net.minecraft.server.v1_12_R1.TileEntityShulkerBox;
import net.minecraft.server.v1_12_R1.TileEntitySign;
import net.minecraft.server.v1_12_R1.TileEntitySkull;
import net.minecraft.server.v1_12_R1.TileEntityStructure;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBanner;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBeacon;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBrewingStand;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftChest;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftCommandBlock;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftComparator;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftDaylightDetector;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftDispenser;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftDropper;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftEnchantingTable;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftEndGateway;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftEnderChest;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftFlowerPot;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftFurnace;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftHopper;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftJukebox;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftNoteBlock;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftShulkerBox;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftSign;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftSkull;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftStructureBlock;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaItem;
import org.bukkit.inventory.meta.BlockStateMeta;

@DelegateDeserialization(value=CraftMetaItem.SerializableMeta.class)
public class CraftMetaBlockState
extends CraftMetaItem
implements BlockStateMeta {
    static final CraftMetaItem.ItemMetaKey BLOCK_ENTITY_TAG = new CraftMetaItem.ItemMetaKey("BlockEntityTag");
    final Material material;
    NBTTagCompound blockEntityTag;

    CraftMetaBlockState(CraftMetaItem meta, Material material) {
        super(meta);
        this.material = material;
        if (!(meta instanceof CraftMetaBlockState) || ((CraftMetaBlockState)meta).material != material) {
            this.blockEntityTag = null;
            return;
        }
        CraftMetaBlockState te = (CraftMetaBlockState)meta;
        this.blockEntityTag = te.blockEntityTag;
    }

    CraftMetaBlockState(NBTTagCompound tag, Material material) {
        super(tag);
        this.material = material;
        this.blockEntityTag = tag.hasKeyOfType(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT, 10) ? tag.getCompound(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT) : null;
    }

    CraftMetaBlockState(Map<String, Object> map) {
        super(map);
        String matName = CraftMetaItem.SerializableMeta.getString(map, "blockMaterial", true);
        Material m = Material.getMaterial(matName);
        this.material = m != null ? m : Material.AIR;
    }

    @Override
    void applyToItem(NBTTagCompound tag) {
        super.applyToItem(tag);
        if (this.blockEntityTag != null) {
            tag.set(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT, (NBTBase)this.blockEntityTag);
        }
    }

    @Override
    void deserializeInternal(NBTTagCompound tag) {
        if (tag.hasKeyOfType(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT, 10)) {
            this.blockEntityTag = tag.getCompound(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT);
        }
    }

    @Override
    void serializeInternal(Map<String, NBTBase> internalTags) {
        if (this.blockEntityTag != null) {
            internalTags.put(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT, (NBTBase)this.blockEntityTag);
        }
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        builder.put((Object)"blockMaterial", (Object)this.material.name());
        return builder;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.blockEntityTag != null) {
            hash = 61 * hash + this.blockEntityTag.hashCode();
        }
        return original != hash ? CraftMetaBlockState.class.hashCode() ^ hash : hash;
    }

    @Override
    public boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaBlockState) {
            CraftMetaBlockState that = (CraftMetaBlockState)meta;
            return Objects.equal((Object)this.blockEntityTag, (Object)that.blockEntityTag);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaBlockState || this.blockEntityTag == null);
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.blockEntityTag == null;
    }

    @Override
    boolean applicableTo(Material type) {
        switch (type) {
            case DISPENSER: 
            case NOTE_BLOCK: 
            case MOB_SPAWNER: 
            case CHEST: 
            case FURNACE: 
            case JUKEBOX: 
            case ENCHANTMENT_TABLE: 
            case ENDER_CHEST: 
            case COMMAND: 
            case BEACON: 
            case TRAPPED_CHEST: 
            case DAYLIGHT_DETECTOR: 
            case HOPPER: 
            case DROPPER: 
            case DAYLIGHT_DETECTOR_INVERTED: 
            case COMMAND_REPEATING: 
            case COMMAND_CHAIN: 
            case WHITE_SHULKER_BOX: 
            case ORANGE_SHULKER_BOX: 
            case MAGENTA_SHULKER_BOX: 
            case LIGHT_BLUE_SHULKER_BOX: 
            case YELLOW_SHULKER_BOX: 
            case LIME_SHULKER_BOX: 
            case PINK_SHULKER_BOX: 
            case GRAY_SHULKER_BOX: 
            case SILVER_SHULKER_BOX: 
            case CYAN_SHULKER_BOX: 
            case PURPLE_SHULKER_BOX: 
            case BLUE_SHULKER_BOX: 
            case BROWN_SHULKER_BOX: 
            case GREEN_SHULKER_BOX: 
            case RED_SHULKER_BOX: 
            case BLACK_SHULKER_BOX: 
            case STRUCTURE_BLOCK: 
            case SIGN: 
            case BREWING_STAND_ITEM: 
            case FLOWER_POT_ITEM: 
            case REDSTONE_COMPARATOR: 
            case SHIELD: {
                return true;
            }
        }
        return false;
    }

    @Override
    public CraftMetaBlockState clone() {
        CraftMetaBlockState meta = (CraftMetaBlockState)super.clone();
        if (this.blockEntityTag != null) {
            meta.blockEntityTag = this.blockEntityTag.g();
        }
        return meta;
    }

    @Override
    public boolean hasBlockState() {
        return this.blockEntityTag != null;
    }

    @Override
    public BlockState getBlockState() {
        if (this.blockEntityTag != null) {
            switch (this.material) {
                case SHIELD: {
                    this.blockEntityTag.setString("id", "banner");
                    break;
                }
                case WHITE_SHULKER_BOX: 
                case ORANGE_SHULKER_BOX: 
                case MAGENTA_SHULKER_BOX: 
                case LIGHT_BLUE_SHULKER_BOX: 
                case YELLOW_SHULKER_BOX: 
                case LIME_SHULKER_BOX: 
                case PINK_SHULKER_BOX: 
                case GRAY_SHULKER_BOX: 
                case SILVER_SHULKER_BOX: 
                case CYAN_SHULKER_BOX: 
                case PURPLE_SHULKER_BOX: 
                case BLUE_SHULKER_BOX: 
                case BROWN_SHULKER_BOX: 
                case GREEN_SHULKER_BOX: 
                case RED_SHULKER_BOX: 
                case BLACK_SHULKER_BOX: {
                    this.blockEntityTag.setString("id", "shulker_box");
                }
            }
        }
        TileEntity te = this.blockEntityTag == null ? null : TileEntity.create(null, (NBTTagCompound)this.blockEntityTag);
        switch (this.material) {
            case SIGN_POST: 
            case WALL_SIGN: 
            case SIGN: {
                if (te == null) {
                    te = new TileEntitySign();
                }
                return new CraftSign(this.material, (TileEntitySign)te);
            }
            case CHEST: 
            case TRAPPED_CHEST: {
                if (te == null) {
                    te = new TileEntityChest();
                }
                return new CraftChest(this.material, (TileEntityChest)te);
            }
            case FURNACE: 
            case BURNING_FURNACE: {
                if (te == null) {
                    te = new TileEntityFurnace();
                }
                return new CraftFurnace(this.material, (TileEntityFurnace)te);
            }
            case DISPENSER: {
                if (te == null) {
                    te = new TileEntityDispenser();
                }
                return new CraftDispenser(this.material, (TileEntityDispenser)te);
            }
            case DROPPER: {
                if (te == null) {
                    te = new TileEntityDropper();
                }
                return new CraftDropper(this.material, (TileEntityDropper)te);
            }
            case END_GATEWAY: {
                if (te == null) {
                    te = new TileEntityEndGateway();
                }
                return new CraftEndGateway(this.material, (TileEntityEndGateway)te);
            }
            case HOPPER: {
                if (te == null) {
                    te = new TileEntityHopper();
                }
                return new CraftHopper(this.material, (TileEntityHopper)te);
            }
            case MOB_SPAWNER: {
                if (te == null) {
                    te = new TileEntityMobSpawner();
                }
                return new CraftCreatureSpawner(this.material, (TileEntityMobSpawner)te);
            }
            case NOTE_BLOCK: {
                if (te == null) {
                    te = new TileEntityNote();
                }
                return new CraftNoteBlock(this.material, (TileEntityNote)te);
            }
            case JUKEBOX: {
                if (te == null) {
                    te = new BlockJukeBox.TileEntityRecordPlayer();
                }
                return new CraftJukebox(this.material, (BlockJukeBox.TileEntityRecordPlayer)te);
            }
            case BREWING_STAND_ITEM: {
                if (te == null) {
                    te = new TileEntityBrewingStand();
                }
                return new CraftBrewingStand(this.material, (TileEntityBrewingStand)te);
            }
            case SKULL: {
                if (te == null) {
                    te = new TileEntitySkull();
                }
                return new CraftSkull(this.material, (TileEntitySkull)te);
            }
            case COMMAND: 
            case COMMAND_REPEATING: 
            case COMMAND_CHAIN: {
                if (te == null) {
                    te = new TileEntityCommand();
                }
                return new CraftCommandBlock(this.material, (TileEntityCommand)te);
            }
            case BEACON: {
                if (te == null) {
                    te = new TileEntityBeacon();
                }
                return new CraftBeacon(this.material, (TileEntityBeacon)te);
            }
            case STANDING_BANNER: 
            case WALL_BANNER: 
            case BANNER: 
            case SHIELD: {
                if (te == null) {
                    te = new TileEntityBanner();
                }
                return new CraftBanner(this.material, (TileEntityBanner)te);
            }
            case FLOWER_POT_ITEM: {
                if (te == null) {
                    te = new TileEntityFlowerPot();
                }
                return new CraftFlowerPot(this.material, (TileEntityFlowerPot)te);
            }
            case STRUCTURE_BLOCK: {
                if (te == null) {
                    te = new TileEntityStructure();
                }
                return new CraftStructureBlock(this.material, (TileEntityStructure)te);
            }
            case WHITE_SHULKER_BOX: 
            case ORANGE_SHULKER_BOX: 
            case MAGENTA_SHULKER_BOX: 
            case LIGHT_BLUE_SHULKER_BOX: 
            case YELLOW_SHULKER_BOX: 
            case LIME_SHULKER_BOX: 
            case PINK_SHULKER_BOX: 
            case GRAY_SHULKER_BOX: 
            case SILVER_SHULKER_BOX: 
            case CYAN_SHULKER_BOX: 
            case PURPLE_SHULKER_BOX: 
            case BLUE_SHULKER_BOX: 
            case BROWN_SHULKER_BOX: 
            case GREEN_SHULKER_BOX: 
            case RED_SHULKER_BOX: 
            case BLACK_SHULKER_BOX: {
                if (te == null) {
                    te = new TileEntityShulkerBox();
                }
                return new CraftShulkerBox(this.material, (TileEntityShulkerBox)te);
            }
            case ENCHANTMENT_TABLE: {
                if (te == null) {
                    te = new TileEntityEnchantTable();
                }
                return new CraftEnchantingTable(this.material, (TileEntityEnchantTable)te);
            }
            case ENDER_CHEST: {
                if (te == null) {
                    te = new TileEntityEnderChest();
                }
                return new CraftEnderChest(this.material, (TileEntityEnderChest)te);
            }
            case DAYLIGHT_DETECTOR: 
            case DAYLIGHT_DETECTOR_INVERTED: {
                if (te == null) {
                    te = new TileEntityLightDetector();
                }
                return new CraftDaylightDetector(this.material, (TileEntityLightDetector)te);
            }
            case REDSTONE_COMPARATOR: {
                if (te == null) {
                    te = new TileEntityComparator();
                }
                return new CraftComparator(this.material, (TileEntityComparator)te);
            }
        }
        throw new IllegalStateException("Missing blockState for " + (Object)((Object)this.material));
    }

    @Override
    public void setBlockState(BlockState blockState) {
        boolean valid;
        Validate.notNull((Object)blockState, (String)"blockState must not be null");
        switch (this.material) {
            case SIGN_POST: 
            case WALL_SIGN: 
            case SIGN: {
                valid = blockState instanceof CraftSign;
                break;
            }
            case CHEST: 
            case TRAPPED_CHEST: {
                valid = blockState instanceof CraftChest;
                break;
            }
            case FURNACE: 
            case BURNING_FURNACE: {
                valid = blockState instanceof CraftFurnace;
                break;
            }
            case DISPENSER: {
                valid = blockState instanceof CraftDispenser;
                break;
            }
            case DROPPER: {
                valid = blockState instanceof CraftDropper;
                break;
            }
            case END_GATEWAY: {
                valid = blockState instanceof CraftEndGateway;
                break;
            }
            case HOPPER: {
                valid = blockState instanceof CraftHopper;
                break;
            }
            case MOB_SPAWNER: {
                valid = blockState instanceof CraftCreatureSpawner;
                break;
            }
            case NOTE_BLOCK: {
                valid = blockState instanceof CraftNoteBlock;
                break;
            }
            case JUKEBOX: {
                valid = blockState instanceof CraftJukebox;
                break;
            }
            case BREWING_STAND_ITEM: {
                valid = blockState instanceof CraftBrewingStand;
                break;
            }
            case SKULL: {
                valid = blockState instanceof CraftSkull;
                break;
            }
            case COMMAND: 
            case COMMAND_REPEATING: 
            case COMMAND_CHAIN: {
                valid = blockState instanceof CraftCommandBlock;
                break;
            }
            case BEACON: {
                valid = blockState instanceof CraftBeacon;
                break;
            }
            case STANDING_BANNER: 
            case WALL_BANNER: 
            case BANNER: 
            case SHIELD: {
                valid = blockState instanceof CraftBanner;
                break;
            }
            case FLOWER_POT_ITEM: {
                valid = blockState instanceof CraftFlowerPot;
                break;
            }
            case STRUCTURE_BLOCK: {
                valid = blockState instanceof CraftStructureBlock;
                break;
            }
            case WHITE_SHULKER_BOX: 
            case ORANGE_SHULKER_BOX: 
            case MAGENTA_SHULKER_BOX: 
            case LIGHT_BLUE_SHULKER_BOX: 
            case YELLOW_SHULKER_BOX: 
            case LIME_SHULKER_BOX: 
            case PINK_SHULKER_BOX: 
            case GRAY_SHULKER_BOX: 
            case SILVER_SHULKER_BOX: 
            case CYAN_SHULKER_BOX: 
            case PURPLE_SHULKER_BOX: 
            case BLUE_SHULKER_BOX: 
            case BROWN_SHULKER_BOX: 
            case GREEN_SHULKER_BOX: 
            case RED_SHULKER_BOX: 
            case BLACK_SHULKER_BOX: {
                valid = blockState instanceof CraftShulkerBox;
                break;
            }
            case ENCHANTMENT_TABLE: {
                valid = blockState instanceof CraftEnchantingTable;
                break;
            }
            case ENDER_CHEST: {
                valid = blockState instanceof CraftEnderChest;
                break;
            }
            case DAYLIGHT_DETECTOR: 
            case DAYLIGHT_DETECTOR_INVERTED: {
                valid = blockState instanceof CraftDaylightDetector;
                break;
            }
            case REDSTONE_COMPARATOR: {
                valid = blockState instanceof CraftComparator;
                break;
            }
            default: {
                valid = false;
            }
        }
        Validate.isTrue((boolean)valid, (String)("Invalid blockState for " + (Object)((Object)this.material)));
        this.blockEntityTag = ((CraftBlockEntityState)blockState).getSnapshotNBT();
    }
}

