/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.inventory;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.v1_12_R1.GenericAttributes;
import net.minecraft.server.v1_12_R1.IAttribute;
import net.minecraft.server.v1_12_R1.NBTBase;
import net.minecraft.server.v1_12_R1.NBTCompressedStreamTools;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import net.minecraft.server.v1_12_R1.NBTTagList;
import net.minecraft.server.v1_12_R1.NBTTagString;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_12_R1.Overridden;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaBanner;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaBlockState;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaBookSigned;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaCharge;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaEnchantedBook;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaKnowledgeBook;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaLeatherArmor;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaMap;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaPotion;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaSkull;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaSpawnEgg;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;
import org.spigotmc.ValidateUtils;

@DelegateDeserialization(value=SerializableMeta.class)
class CraftMetaItem
implements ItemMeta,
Repairable {
    static final ItemMetaKey NAME = new ItemMetaKey("Name", "display-name");
    static final ItemMetaKey LOCNAME = new ItemMetaKey("LocName", "loc-name");
    static final ItemMetaKey DISPLAY = new ItemMetaKey("display");
    static final ItemMetaKey LORE = new ItemMetaKey("Lore", "lore");
    static final ItemMetaKey ENCHANTMENTS = new ItemMetaKey("ench", "enchants");
    static final ItemMetaKey ENCHANTMENTS_ID = new ItemMetaKey("id");
    static final ItemMetaKey ENCHANTMENTS_LVL = new ItemMetaKey("lvl");
    static final ItemMetaKey REPAIR = new ItemMetaKey("RepairCost", "repair-cost");
    static final ItemMetaKey ATTRIBUTES = new ItemMetaKey("AttributeModifiers");
    static final ItemMetaKey ATTRIBUTES_IDENTIFIER = new ItemMetaKey("AttributeName");
    static final ItemMetaKey ATTRIBUTES_NAME = new ItemMetaKey("Name");
    static final ItemMetaKey ATTRIBUTES_VALUE = new ItemMetaKey("Amount");
    static final ItemMetaKey ATTRIBUTES_TYPE = new ItemMetaKey("Operation");
    static final ItemMetaKey ATTRIBUTES_UUID_HIGH = new ItemMetaKey("UUIDMost");
    static final ItemMetaKey ATTRIBUTES_UUID_LOW = new ItemMetaKey("UUIDLeast");
    static final ItemMetaKey HIDEFLAGS = new ItemMetaKey("HideFlags", "ItemFlags");
    static final ItemMetaKey UNBREAKABLE = new ItemMetaKey("Unbreakable");
    private String displayName;
    private String locName;
    private List<String> lore;
    private Map<Enchantment, Integer> enchantments;
    private int repairCost;
    private int hideFlag;
    private boolean unbreakable;
    private static final Set<String> HANDLED_TAGS = Sets.newHashSet();
    private NBTTagCompound internalTag;
    private final Map<String, NBTBase> unhandledTags = new HashMap<String, NBTBase>();
    private final ItemMeta.Spigot spigot = new ItemMeta.Spigot(){

        @Override
        public void setUnbreakable(boolean setUnbreakable) {
            CraftMetaItem.this.setUnbreakable(setUnbreakable);
        }

        @Override
        public boolean isUnbreakable() {
            return CraftMetaItem.this.unbreakable;
        }
    };

    CraftMetaItem(CraftMetaItem meta) {
        if (meta == null) {
            return;
        }
        this.displayName = meta.displayName;
        this.locName = meta.locName;
        if (meta.hasLore()) {
            this.lore = new ArrayList<String>(meta.lore);
        }
        if (meta.enchantments != null) {
            this.enchantments = new HashMap<Enchantment, Integer>(meta.enchantments);
        }
        this.repairCost = meta.repairCost;
        this.hideFlag = meta.hideFlag;
        this.unbreakable = meta.unbreakable;
        this.unhandledTags.putAll(meta.unhandledTags);
        this.internalTag = meta.internalTag;
        if (this.internalTag != null) {
            this.deserializeInternal(this.internalTag);
        }
    }

    /*
     * WARNING - void declaration
     */
    CraftMetaItem(NBTTagCompound tag) {
        if (tag.hasKey(CraftMetaItem.DISPLAY.NBT)) {
            NBTTagCompound display = tag.getCompound(CraftMetaItem.DISPLAY.NBT);
            if (display.hasKey(CraftMetaItem.NAME.NBT)) {
                this.displayName = ValidateUtils.limit(display.getString(CraftMetaItem.NAME.NBT), 1024);
            }
            if (display.hasKey(CraftMetaItem.LOCNAME.NBT)) {
                this.locName = display.getString(CraftMetaItem.LOCNAME.NBT);
            }
            if (display.hasKey(CraftMetaItem.LORE.NBT)) {
                NBTTagList list = display.getList(CraftMetaItem.LORE.NBT, 8);
                this.lore = new ArrayList<String>(list.size());
                int index = 0;
                while (index < list.size()) {
                    String line = ValidateUtils.limit(list.getString(index), 1024);
                    this.lore.add(line);
                    ++index;
                }
            }
        }
        this.enchantments = CraftMetaItem.buildEnchantments(tag, ENCHANTMENTS);
        if (tag.hasKey(CraftMetaItem.REPAIR.NBT)) {
            this.repairCost = tag.getInt(CraftMetaItem.REPAIR.NBT);
        }
        if (tag.hasKey(CraftMetaItem.HIDEFLAGS.NBT)) {
            this.hideFlag = tag.getInt(CraftMetaItem.HIDEFLAGS.NBT);
        }
        if (tag.hasKey(CraftMetaItem.UNBREAKABLE.NBT)) {
            this.unbreakable = tag.getBoolean(CraftMetaItem.UNBREAKABLE.NBT);
        }
        if (tag.get(CraftMetaItem.ATTRIBUTES.NBT) instanceof NBTTagList) {
            void var11_20;
            double val;
            String name;
            Object nbttagcompound;
            void var11_14;
            NBTTagList save = null;
            NBTTagList nbttaglist = tag.getList(CraftMetaItem.ATTRIBUTES.NBT, 10);
            TObjectDoubleHashMap attributeTracker = new TObjectDoubleHashMap();
            TObjectDoubleHashMap attributeTrackerX = new TObjectDoubleHashMap();
            HashMap<String, IAttribute> attributesByName = new HashMap<String, IAttribute>();
            attributeTracker.put((Object)"generic.maxHealth", 20.0);
            attributesByName.put("generic.maxHealth", GenericAttributes.maxHealth);
            attributeTracker.put((Object)"generic.followRange", 32.0);
            attributesByName.put("generic.followRange", GenericAttributes.FOLLOW_RANGE);
            attributeTracker.put((Object)"generic.knockbackResistance", 0.0);
            attributesByName.put("generic.knockbackResistance", GenericAttributes.c);
            attributeTracker.put((Object)"generic.movementSpeed", 0.7);
            attributesByName.put("generic.movementSpeed", GenericAttributes.MOVEMENT_SPEED);
            attributeTracker.put((Object)"generic.attackDamage", 1.0);
            attributesByName.put("generic.attackDamage", GenericAttributes.ATTACK_DAMAGE);
            NBTTagList oldList = nbttaglist;
            nbttaglist = new NBTTagList();
            ArrayList<Object> op0 = new ArrayList<Object>();
            ArrayList<Object> op1 = new ArrayList<Object>();
            ArrayList<Object> op2 = new ArrayList<Object>();
            boolean bl = false;
            while (var11_14 < oldList.size()) {
                nbttagcompound = oldList.get((int)var11_14);
                if (nbttagcompound != null && nbttagcompound.hasKeyOfType(CraftMetaItem.ATTRIBUTES_UUID_HIGH.NBT, 99) && nbttagcompound.hasKeyOfType(CraftMetaItem.ATTRIBUTES_UUID_LOW.NBT, 99) && nbttagcompound.get(CraftMetaItem.ATTRIBUTES_IDENTIFIER.NBT) instanceof NBTTagString && CraftItemFactory.KNOWN_NBT_ATTRIBUTE_NAMES.contains(nbttagcompound.getString(CraftMetaItem.ATTRIBUTES_IDENTIFIER.NBT)) && nbttagcompound.get(CraftMetaItem.ATTRIBUTES_NAME.NBT) instanceof NBTTagString && !nbttagcompound.getString(CraftMetaItem.ATTRIBUTES_NAME.NBT).isEmpty() && nbttagcompound.hasKeyOfType(CraftMetaItem.ATTRIBUTES_VALUE.NBT, 99) && nbttagcompound.hasKeyOfType(CraftMetaItem.ATTRIBUTES_TYPE.NBT, 99) && nbttagcompound.getInt(CraftMetaItem.ATTRIBUTES_TYPE.NBT) >= 0 && nbttagcompound.getInt(CraftMetaItem.ATTRIBUTES_TYPE.NBT) <= 2) {
                    switch (nbttagcompound.getInt(CraftMetaItem.ATTRIBUTES_TYPE.NBT)) {
                        case 0: {
                            op0.add(nbttagcompound);
                            break;
                        }
                        case 1: {
                            op1.add(nbttagcompound);
                            break;
                        }
                        case 2: {
                            op2.add(nbttagcompound);
                        }
                    }
                }
                ++var11_14;
            }
            for (NBTTagCompound nBTTagCompound : op0) {
                name = nBTTagCompound.getString(CraftMetaItem.ATTRIBUTES_IDENTIFIER.NBT);
                if (attributeTracker.containsKey((Object)name)) {
                    val = attributeTracker.get((Object)name);
                    if ((val += nBTTagCompound.getDouble(CraftMetaItem.ATTRIBUTES_VALUE.NBT)) != ((IAttribute)attributesByName.get(name)).a(val)) continue;
                    attributeTracker.put((Object)name, val);
                }
                nbttaglist.add((NBTBase)nBTTagCompound);
            }
            for (String string : attributeTracker.keySet()) {
                attributeTrackerX.put((Object)string, attributeTracker.get((Object)string));
            }
            for (NBTTagCompound nBTTagCompound : op1) {
                name = nBTTagCompound.getString(CraftMetaItem.ATTRIBUTES_IDENTIFIER.NBT);
                if (attributeTracker.containsKey((Object)name)) {
                    val = attributeTracker.get((Object)name);
                    double valX = attributeTrackerX.get((Object)name);
                    if ((val += valX * nBTTagCompound.getDouble(CraftMetaItem.ATTRIBUTES_VALUE.NBT)) != ((IAttribute)attributesByName.get(name)).a(val)) continue;
                    attributeTracker.put((Object)name, val);
                }
                nbttaglist.add((NBTBase)nBTTagCompound);
            }
            nbttagcompound = op2.iterator();
            while (nbttagcompound.hasNext()) {
                NBTTagCompound nBTTagCompound = (NBTTagCompound)nbttagcompound.next();
                name = nBTTagCompound.getString(CraftMetaItem.ATTRIBUTES_IDENTIFIER.NBT);
                if (attributeTracker.containsKey((Object)name)) {
                    val = attributeTracker.get((Object)name);
                    if ((val += val * nBTTagCompound.getDouble(CraftMetaItem.ATTRIBUTES_VALUE.NBT)) != ((IAttribute)attributesByName.get(name)).a(val)) continue;
                    attributeTracker.put((Object)name, val);
                }
                nbttaglist.add((NBTBase)nBTTagCompound);
            }
            boolean bl2 = false;
            while (var11_20 < nbttaglist.size()) {
                if (nbttaglist.get((int)var11_20) instanceof NBTTagCompound && (nbttagcompound = nbttaglist.get((int)var11_20)).hasKeyOfType(CraftMetaItem.ATTRIBUTES_UUID_HIGH.NBT, 99) && nbttagcompound.hasKeyOfType(CraftMetaItem.ATTRIBUTES_UUID_LOW.NBT, 99) && nbttagcompound.get(CraftMetaItem.ATTRIBUTES_IDENTIFIER.NBT) instanceof NBTTagString && CraftItemFactory.KNOWN_NBT_ATTRIBUTE_NAMES.contains(nbttagcompound.getString(CraftMetaItem.ATTRIBUTES_IDENTIFIER.NBT)) && nbttagcompound.get(CraftMetaItem.ATTRIBUTES_NAME.NBT) instanceof NBTTagString && !nbttagcompound.getString(CraftMetaItem.ATTRIBUTES_NAME.NBT).isEmpty() && nbttagcompound.hasKeyOfType(CraftMetaItem.ATTRIBUTES_VALUE.NBT, 99) && nbttagcompound.hasKeyOfType(CraftMetaItem.ATTRIBUTES_TYPE.NBT, 99) && nbttagcompound.getInt(CraftMetaItem.ATTRIBUTES_TYPE.NBT) >= 0 && nbttagcompound.getInt(CraftMetaItem.ATTRIBUTES_TYPE.NBT) <= 2) {
                    if (save == null) {
                        save = new NBTTagList();
                    }
                    NBTTagCompound entry = new NBTTagCompound();
                    entry.set(CraftMetaItem.ATTRIBUTES_UUID_HIGH.NBT, nbttagcompound.get(CraftMetaItem.ATTRIBUTES_UUID_HIGH.NBT));
                    entry.set(CraftMetaItem.ATTRIBUTES_UUID_LOW.NBT, nbttagcompound.get(CraftMetaItem.ATTRIBUTES_UUID_LOW.NBT));
                    entry.set(CraftMetaItem.ATTRIBUTES_IDENTIFIER.NBT, nbttagcompound.get(CraftMetaItem.ATTRIBUTES_IDENTIFIER.NBT));
                    entry.set(CraftMetaItem.ATTRIBUTES_NAME.NBT, nbttagcompound.get(CraftMetaItem.ATTRIBUTES_NAME.NBT));
                    entry.set(CraftMetaItem.ATTRIBUTES_VALUE.NBT, nbttagcompound.get(CraftMetaItem.ATTRIBUTES_VALUE.NBT));
                    entry.set(CraftMetaItem.ATTRIBUTES_TYPE.NBT, nbttagcompound.get(CraftMetaItem.ATTRIBUTES_TYPE.NBT));
                    save.add((NBTBase)entry);
                }
                ++var11_20;
            }
            this.unhandledTags.put(CraftMetaItem.ATTRIBUTES.NBT, (NBTBase)save);
        }
        Set keys = tag.c();
        for (String key : keys) {
            if (CraftMetaItem.getHandledTags().contains(key)) continue;
            this.unhandledTags.put(key, tag.get(key));
        }
    }

    static Map<Enchantment, Integer> buildEnchantments(NBTTagCompound tag, ItemMetaKey key) {
        if (!tag.hasKey(key.NBT)) {
            return null;
        }
        NBTTagList ench = tag.getList(key.NBT, 10);
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>(ench.size());
        int i = 0;
        while (i < ench.size()) {
            int id = 0xFFFF & ench.get(i).getShort(CraftMetaItem.ENCHANTMENTS_ID.NBT);
            int level = 0xFFFF & ench.get(i).getShort(CraftMetaItem.ENCHANTMENTS_LVL.NBT);
            Enchantment enchant = Enchantment.getById(id);
            if (enchant != null) {
                enchantments.put(enchant, level);
            }
            ++i;
        }
        return enchantments;
    }

    CraftMetaItem(Map<String, Object> map) {
        String internal;
        Boolean unbreakable;
        Iterable hideFlags;
        this.setDisplayName(SerializableMeta.getString(map, CraftMetaItem.NAME.BUKKIT, true));
        this.setLocalizedName(SerializableMeta.getString(map, CraftMetaItem.LOCNAME.BUKKIT, true));
        Iterable lore = SerializableMeta.getObject(Iterable.class, map, CraftMetaItem.LORE.BUKKIT, true);
        if (lore != null) {
            this.lore = new ArrayList<String>();
            CraftMetaItem.safelyAdd(lore, this.lore, Integer.MAX_VALUE);
        }
        this.enchantments = CraftMetaItem.buildEnchantments(map, ENCHANTMENTS);
        Integer repairCost = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.REPAIR.BUKKIT, true);
        if (repairCost != null) {
            this.setRepairCost(repairCost);
        }
        if ((hideFlags = SerializableMeta.getObject(Iterable.class, map, CraftMetaItem.HIDEFLAGS.BUKKIT, true)) != null) {
            for (Object hideFlagObject : hideFlags) {
                String hideFlagString = (String)hideFlagObject;
                try {
                    ItemFlag hideFlatEnum = ItemFlag.valueOf(hideFlagString);
                    this.addItemFlags(hideFlatEnum);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        if ((unbreakable = SerializableMeta.getObject(Boolean.class, map, CraftMetaItem.UNBREAKABLE.BUKKIT, true)) != null) {
            this.setUnbreakable(unbreakable);
        }
        if ((internal = SerializableMeta.getString(map, "internal", true)) != null) {
            ByteArrayInputStream buf = new ByteArrayInputStream(Base64.decodeBase64((String)internal));
            try {
                this.internalTag = NBTCompressedStreamTools.a((InputStream)buf);
                this.deserializeInternal(this.internalTag);
                Set keys = this.internalTag.c();
                for (String key : keys) {
                    if (CraftMetaItem.getHandledTags().contains(key)) continue;
                    this.unhandledTags.put(key, this.internalTag.get(key));
                }
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    void deserializeInternal(NBTTagCompound tag) {
    }

    static Map<Enchantment, Integer> buildEnchantments(Map<String, Object> map, ItemMetaKey key) {
        Map ench = SerializableMeta.getObject(Map.class, map, key.BUKKIT, true);
        if (ench == null) {
            return null;
        }
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>(ench.size());
        for (Map.Entry entry : ench.entrySet()) {
            Enchantment enchantment;
            String enchantKey = entry.getKey().toString();
            if (enchantKey.equals("SWEEPING")) {
                enchantKey = "SWEEPING_EDGE";
            }
            if ((enchantment = Enchantment.getByName(enchantKey)) == null || !(entry.getValue() instanceof Integer)) continue;
            enchantments.put(enchantment, (Integer)entry.getValue());
        }
        return enchantments;
    }

    @Overridden
    void applyToItem(NBTTagCompound itemTag) {
        if (this.hasDisplayName()) {
            this.setDisplayTag(itemTag, CraftMetaItem.NAME.NBT, (NBTBase)new NBTTagString(this.displayName));
        }
        if (this.hasLocalizedName()) {
            this.setDisplayTag(itemTag, CraftMetaItem.LOCNAME.NBT, (NBTBase)new NBTTagString(this.locName));
        }
        if (this.hasLore()) {
            this.setDisplayTag(itemTag, CraftMetaItem.LORE.NBT, (NBTBase)CraftMetaItem.createStringList(this.lore));
        }
        if (this.hideFlag != 0) {
            itemTag.setInt(CraftMetaItem.HIDEFLAGS.NBT, this.hideFlag);
        }
        CraftMetaItem.applyEnchantments(this.enchantments, itemTag, ENCHANTMENTS);
        if (this.hasRepairCost()) {
            itemTag.setInt(CraftMetaItem.REPAIR.NBT, this.repairCost);
        }
        if (this.isUnbreakable()) {
            itemTag.setBoolean(CraftMetaItem.UNBREAKABLE.NBT, this.unbreakable);
        }
        for (Map.Entry<String, NBTBase> e : this.unhandledTags.entrySet()) {
            itemTag.set(e.getKey(), e.getValue());
        }
    }

    static NBTTagList createStringList(List<String> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        NBTTagList tagList = new NBTTagList();
        for (String value : list) {
            tagList.add((NBTBase)new NBTTagString(value));
        }
        return tagList;
    }

    static void applyEnchantments(Map<Enchantment, Integer> enchantments, NBTTagCompound tag, ItemMetaKey key) {
        if (enchantments == null) {
            return;
        }
        NBTTagList list = new NBTTagList();
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            NBTTagCompound subtag = new NBTTagCompound();
            subtag.setShort(CraftMetaItem.ENCHANTMENTS_ID.NBT, (short)entry.getKey().getId());
            subtag.setShort(CraftMetaItem.ENCHANTMENTS_LVL.NBT, entry.getValue().shortValue());
            list.add((NBTBase)subtag);
        }
        tag.set(key.NBT, (NBTBase)list);
    }

    void setDisplayTag(NBTTagCompound tag, String key, NBTBase value) {
        NBTTagCompound display = tag.getCompound(CraftMetaItem.DISPLAY.NBT);
        if (!tag.hasKey(CraftMetaItem.DISPLAY.NBT)) {
            tag.set(CraftMetaItem.DISPLAY.NBT, (NBTBase)display);
        }
        display.set(key, value);
    }

    @Overridden
    boolean applicableTo(Material type) {
        return type != Material.AIR;
    }

    @Overridden
    boolean isEmpty() {
        return !this.hasDisplayName() && !this.hasLocalizedName() && !this.hasEnchants() && !this.hasLore() && !this.hasRepairCost() && this.unhandledTags.isEmpty() && this.hideFlag == 0 && !this.isUnbreakable();
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public final void setDisplayName(String name) {
        this.displayName = name;
    }

    @Override
    public boolean hasDisplayName() {
        return !Strings.isNullOrEmpty((String)this.displayName);
    }

    @Override
    public String getLocalizedName() {
        return this.locName;
    }

    @Override
    public void setLocalizedName(String name) {
        this.locName = name;
    }

    @Override
    public boolean hasLocalizedName() {
        return !Strings.isNullOrEmpty((String)this.locName);
    }

    @Override
    public boolean hasLore() {
        return this.lore != null && !this.lore.isEmpty();
    }

    @Override
    public boolean hasRepairCost() {
        return this.repairCost > 0;
    }

    @Override
    public boolean hasEnchant(Enchantment ench) {
        Validate.notNull((Object)ench, (String)"Enchantment cannot be null");
        return this.hasEnchants() && this.enchantments.containsKey(ench);
    }

    @Override
    public int getEnchantLevel(Enchantment ench) {
        Integer level;
        Validate.notNull((Object)ench, (String)"Enchantment cannot be null");
        Integer n = level = this.hasEnchants() ? this.enchantments.get(ench) : null;
        if (level == null) {
            return 0;
        }
        return level;
    }

    @Override
    public Map<Enchantment, Integer> getEnchants() {
        return this.hasEnchants() ? ImmutableMap.copyOf(this.enchantments) : ImmutableMap.of();
    }

    @Override
    public boolean addEnchant(Enchantment ench, int level, boolean ignoreRestrictions) {
        Validate.notNull((Object)ench, (String)"Enchantment cannot be null");
        if (this.enchantments == null) {
            this.enchantments = new HashMap<Enchantment, Integer>(4);
        }
        if (ignoreRestrictions || level >= ench.getStartLevel() && level <= ench.getMaxLevel()) {
            Integer old = this.enchantments.put(ench, level);
            return old == null || old != level;
        }
        return false;
    }

    @Override
    public boolean removeEnchant(Enchantment ench) {
        boolean b;
        Validate.notNull((Object)ench, (String)"Enchantment cannot be null");
        boolean bl = b = this.hasEnchants() && this.enchantments.remove(ench) != null;
        if (this.enchantments != null && this.enchantments.isEmpty()) {
            this.enchantments = null;
        }
        return b;
    }

    @Override
    public boolean hasEnchants() {
        return this.enchantments != null && !this.enchantments.isEmpty();
    }

    @Override
    public boolean hasConflictingEnchant(Enchantment ench) {
        return CraftMetaItem.checkConflictingEnchants(this.enchantments, ench);
    }

    @Override
    public void addItemFlags(ItemFlag ... hideFlags) {
        ItemFlag[] itemFlagArray = hideFlags;
        int n = hideFlags.length;
        int n2 = 0;
        while (n2 < n) {
            ItemFlag f = itemFlagArray[n2];
            this.hideFlag |= this.getBitModifier(f);
            ++n2;
        }
    }

    @Override
    public void removeItemFlags(ItemFlag ... hideFlags) {
        ItemFlag[] itemFlagArray = hideFlags;
        int n = hideFlags.length;
        int n2 = 0;
        while (n2 < n) {
            ItemFlag f = itemFlagArray[n2];
            this.hideFlag &= ~this.getBitModifier(f);
            ++n2;
        }
    }

    @Override
    public Set<ItemFlag> getItemFlags() {
        EnumSet<ItemFlag> currentFlags = EnumSet.noneOf(ItemFlag.class);
        ItemFlag[] itemFlagArray = ItemFlag.values();
        int n = itemFlagArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemFlag f = itemFlagArray[n2];
            if (this.hasItemFlag(f)) {
                currentFlags.add(f);
            }
            ++n2;
        }
        return currentFlags;
    }

    @Override
    public boolean hasItemFlag(ItemFlag flag) {
        byte bitModifier = this.getBitModifier(flag);
        return (this.hideFlag & bitModifier) == bitModifier;
    }

    private byte getBitModifier(ItemFlag hideFlag) {
        return (byte)(1 << hideFlag.ordinal());
    }

    @Override
    public List<String> getLore() {
        return this.lore == null ? null : new ArrayList<String>(this.lore);
    }

    @Override
    public void setLore(List<String> lore) {
        if (lore == null) {
            this.lore = null;
        } else if (this.lore == null) {
            this.lore = new ArrayList<String>(lore.size());
            CraftMetaItem.safelyAdd(lore, this.lore, Integer.MAX_VALUE);
        } else {
            this.lore.clear();
            CraftMetaItem.safelyAdd(lore, this.lore, Integer.MAX_VALUE);
        }
    }

    @Override
    public int getRepairCost() {
        return this.repairCost;
    }

    @Override
    public void setRepairCost(int cost) {
        this.repairCost = cost;
    }

    @Override
    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    @Override
    public void setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof CraftMetaItem)) {
            return false;
        }
        return CraftItemFactory.instance().equals((ItemMeta)this, (ItemMeta)object);
    }

    @Overridden
    boolean equalsCommon(CraftMetaItem that) {
        return (this.hasDisplayName() ? that.hasDisplayName() && this.displayName.equals(that.displayName) : !that.hasDisplayName()) && (this.hasLocalizedName() ? that.hasLocalizedName() && this.locName.equals(that.locName) : !that.hasLocalizedName()) && (this.hasEnchants() ? that.hasEnchants() && this.enchantments.equals(that.enchantments) : !that.hasEnchants()) && (this.hasLore() ? that.hasLore() && this.lore.equals(that.lore) : !that.hasLore()) && (this.hasRepairCost() ? that.hasRepairCost() && this.repairCost == that.repairCost : !that.hasRepairCost()) && this.unhandledTags.equals(that.unhandledTags) && this.hideFlag == that.hideFlag && this.isUnbreakable() == that.isUnbreakable();
    }

    @Overridden
    boolean notUncommon(CraftMetaItem meta) {
        return true;
    }

    public final int hashCode() {
        return this.applyHash();
    }

    @Overridden
    int applyHash() {
        int hash = 3;
        hash = 61 * hash + (this.hasDisplayName() ? this.displayName.hashCode() : 0);
        hash = 61 * hash + (this.hasLocalizedName() ? this.locName.hashCode() : 0);
        hash = 61 * hash + (this.hasLore() ? this.lore.hashCode() : 0);
        hash = 61 * hash + (this.hasEnchants() ? this.enchantments.hashCode() : 0);
        hash = 61 * hash + (this.hasRepairCost() ? this.repairCost : 0);
        hash = 61 * hash + this.unhandledTags.hashCode();
        hash = 61 * hash + this.hideFlag;
        hash = 61 * hash + (this.isUnbreakable() ? 1231 : 1237);
        return hash;
    }

    @Override
    @Overridden
    public CraftMetaItem clone() {
        try {
            CraftMetaItem clone = (CraftMetaItem)super.clone();
            if (this.lore != null) {
                clone.lore = new ArrayList<String>(this.lore);
            }
            if (this.enchantments != null) {
                clone.enchantments = new HashMap<Enchantment, Integer>(this.enchantments);
            }
            clone.hideFlag = this.hideFlag;
            clone.unbreakable = this.unbreakable;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    @Override
    public final Map<String, Object> serialize() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)"meta-type", SerializableMeta.classMap.get(this.getClass()));
        this.serialize((ImmutableMap.Builder<String, Object>)map);
        return map.build();
    }

    @Overridden
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        if (this.hasDisplayName()) {
            builder.put((Object)CraftMetaItem.NAME.BUKKIT, (Object)this.displayName);
        }
        if (this.hasLocalizedName()) {
            builder.put((Object)CraftMetaItem.LOCNAME.BUKKIT, (Object)this.locName);
        }
        if (this.hasLore()) {
            builder.put((Object)CraftMetaItem.LORE.BUKKIT, (Object)ImmutableList.copyOf(this.lore));
        }
        CraftMetaItem.serializeEnchantments(this.enchantments, builder, ENCHANTMENTS);
        if (this.hasRepairCost()) {
            builder.put((Object)CraftMetaItem.REPAIR.BUKKIT, (Object)this.repairCost);
        }
        ArrayList<String> hideFlags = new ArrayList<String>();
        for (ItemFlag hideFlagEnum : this.getItemFlags()) {
            hideFlags.add(hideFlagEnum.name());
        }
        if (!hideFlags.isEmpty()) {
            builder.put((Object)CraftMetaItem.HIDEFLAGS.BUKKIT, hideFlags);
        }
        if (this.isUnbreakable()) {
            builder.put((Object)CraftMetaItem.UNBREAKABLE.BUKKIT, (Object)this.unbreakable);
        }
        HashMap<String, NBTBase> internalTags = new HashMap<String, NBTBase>(this.unhandledTags);
        this.serializeInternal(internalTags);
        if (!internalTags.isEmpty()) {
            NBTTagCompound internal = new NBTTagCompound();
            for (Map.Entry e : internalTags.entrySet()) {
                internal.set((String)e.getKey(), (NBTBase)e.getValue());
            }
            try {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                NBTCompressedStreamTools.a((NBTTagCompound)internal, (OutputStream)buf);
                builder.put((Object)"internal", (Object)Base64.encodeBase64String((byte[])buf.toByteArray()));
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return builder;
    }

    void serializeInternal(Map<String, NBTBase> unhandledTags) {
    }

    static void serializeEnchantments(Map<Enchantment, Integer> enchantments, ImmutableMap.Builder<String, Object> builder, ItemMetaKey key) {
        if (enchantments == null || enchantments.isEmpty()) {
            return;
        }
        ImmutableMap.Builder enchants = ImmutableMap.builder();
        for (Map.Entry<Enchantment, Integer> enchant : enchantments.entrySet()) {
            enchants.put((Object)enchant.getKey().getName(), (Object)enchant.getValue());
        }
        builder.put((Object)key.BUKKIT, (Object)enchants.build());
    }

    static void safelyAdd(Iterable<?> addFrom, Collection<String> addTo, int maxItemLength) {
        if (addFrom == null) {
            return;
        }
        for (Object object : addFrom) {
            if (!(object instanceof String)) {
                if (object != null) {
                    throw new IllegalArgumentException(addFrom + " cannot contain non-string " + object.getClass().getName());
                }
                addTo.add("");
                continue;
            }
            String page = object.toString();
            if (page.length() > maxItemLength) {
                page = page.substring(0, maxItemLength);
            }
            addTo.add(page);
        }
    }

    static boolean checkConflictingEnchants(Map<Enchantment, Integer> enchantments, Enchantment ench) {
        if (enchantments == null || enchantments.isEmpty()) {
            return false;
        }
        for (Enchantment enchant : enchantments.keySet()) {
            if (!enchant.conflictsWith(ench)) continue;
            return true;
        }
        return false;
    }

    public final String toString() {
        return String.valueOf((String)SerializableMeta.classMap.get(this.getClass())) + "_META:" + this.serialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getHandledTags() {
        Set<String> set = HANDLED_TAGS;
        synchronized (set) {
            if (HANDLED_TAGS.isEmpty()) {
                HANDLED_TAGS.addAll(Arrays.asList(CraftMetaItem.DISPLAY.NBT, CraftMetaItem.REPAIR.NBT, CraftMetaItem.ENCHANTMENTS.NBT, CraftMetaItem.HIDEFLAGS.NBT, CraftMetaItem.UNBREAKABLE.NBT, CraftMetaMap.MAP_SCALING.NBT, CraftMetaPotion.POTION_EFFECTS.NBT, CraftMetaPotion.DEFAULT_POTION.NBT, CraftMetaSkull.SKULL_OWNER.NBT, CraftMetaSkull.SKULL_PROFILE.NBT, CraftMetaSpawnEgg.ENTITY_TAG.NBT, CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT, CraftMetaBook.BOOK_TITLE.NBT, CraftMetaBook.BOOK_AUTHOR.NBT, CraftMetaBook.BOOK_PAGES.NBT, CraftMetaBook.RESOLVED.NBT, CraftMetaBook.GENERATION.NBT, CraftMetaFirework.FIREWORKS.NBT, CraftMetaEnchantedBook.STORED_ENCHANTMENTS.NBT, CraftMetaCharge.EXPLOSION.NBT, CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT, CraftMetaKnowledgeBook.BOOK_RECIPES.NBT));
            }
            return HANDLED_TAGS;
        }
    }

    @Override
    public ItemMeta.Spigot spigot() {
        return this.spigot;
    }

    static class ItemMetaKey {
        final String BUKKIT;
        final String NBT;

        ItemMetaKey(String both) {
            this(both, both);
        }

        ItemMetaKey(String nbt, String bukkit) {
            this.NBT = nbt;
            this.BUKKIT = bukkit;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @Target(value={ElementType.FIELD})
        static @interface Specific {
            public To value();

            public static enum To {
                BUKKIT,
                NBT;

            }
        }
    }

    @SerializableAs(value="ItemMeta")
    public static class SerializableMeta
    implements ConfigurationSerializable {
        static final String TYPE_FIELD = "meta-type";
        static final ImmutableMap<Class<? extends CraftMetaItem>, String> classMap = ImmutableMap.builder().put(CraftMetaBanner.class, (Object)"BANNER").put(CraftMetaBlockState.class, (Object)"TILE_ENTITY").put(CraftMetaBook.class, (Object)"BOOK").put(CraftMetaBookSigned.class, (Object)"BOOK_SIGNED").put(CraftMetaSkull.class, (Object)"SKULL").put(CraftMetaLeatherArmor.class, (Object)"LEATHER_ARMOR").put(CraftMetaMap.class, (Object)"MAP").put(CraftMetaPotion.class, (Object)"POTION").put(CraftMetaSpawnEgg.class, (Object)"SPAWN_EGG").put(CraftMetaEnchantedBook.class, (Object)"ENCHANTED").put(CraftMetaFirework.class, (Object)"FIREWORK").put(CraftMetaCharge.class, (Object)"FIREWORK_EFFECT").put(CraftMetaKnowledgeBook.class, (Object)"KNOWLEDGE_BOOK").put(CraftMetaItem.class, (Object)"UNSPECIFIC").build();
        static final ImmutableMap<String, Constructor<? extends CraftMetaItem>> constructorMap;

        static {
            ImmutableMap.Builder classConstructorBuilder = ImmutableMap.builder();
            for (Map.Entry mapping : classMap.entrySet()) {
                try {
                    classConstructorBuilder.put((Object)((String)mapping.getValue()), ((Class)mapping.getKey()).getDeclaredConstructor(Map.class));
                }
                catch (NoSuchMethodException e) {
                    throw new AssertionError((Object)e);
                }
            }
            constructorMap = classConstructorBuilder.build();
        }

        private SerializableMeta() {
        }

        public static ItemMeta deserialize(Map<String, Object> map) throws Throwable {
            Validate.notNull(map, (String)"Cannot deserialize null map");
            String type = SerializableMeta.getString(map, TYPE_FIELD, false);
            Constructor constructor = (Constructor)constructorMap.get((Object)type);
            if (constructor == null) {
                throw new IllegalArgumentException(String.valueOf(type) + " is not a valid " + TYPE_FIELD);
            }
            try {
                return (ItemMeta)constructor.newInstance(map);
            }
            catch (InstantiationException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        @Override
        public Map<String, Object> serialize() {
            throw new AssertionError();
        }

        static String getString(Map<?, ?> map, Object field, boolean nullable) {
            return SerializableMeta.getObject(String.class, map, field, nullable);
        }

        static boolean getBoolean(Map<?, ?> map, Object field) {
            Boolean value = SerializableMeta.getObject(Boolean.class, map, field, true);
            return value != null && value != false;
        }

        static <T> T getObject(Class<T> clazz, Map<?, ?> map, Object field, boolean nullable) {
            Object object = map.get(field);
            if (clazz.isInstance(object)) {
                return clazz.cast(object);
            }
            if (object == null) {
                if (!nullable) {
                    throw new NoSuchElementException(map + " does not contain " + field);
                }
                return null;
            }
            throw new IllegalArgumentException(field + "(" + object + ") is not a valid " + clazz);
        }
    }
}

