/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.inventory;

import java.util.Map;
import net.minecraft.server.v1_12_R1.CraftingManager;
import net.minecraft.server.v1_12_R1.IRecipe;
import net.minecraft.server.v1_12_R1.MinecraftKey;
import net.minecraft.server.v1_12_R1.NonNullList;
import net.minecraft.server.v1_12_R1.RecipeItemStack;
import net.minecraft.server.v1_12_R1.ShapedRecipes;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_12_R1.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ShapedRecipe;

public class CraftShapedRecipe
extends ShapedRecipe
implements CraftRecipe {
    private ShapedRecipes recipe;

    public CraftShapedRecipe(NamespacedKey key, ItemStack result) {
        super(key, result);
    }

    public CraftShapedRecipe(ItemStack result, ShapedRecipes recipe) {
        this(CraftNamespacedKey.fromMinecraft(recipe.key), result);
        this.recipe = recipe;
    }

    public static CraftShapedRecipe fromBukkitRecipe(ShapedRecipe recipe) {
        if (recipe instanceof CraftShapedRecipe) {
            return (CraftShapedRecipe)recipe;
        }
        CraftShapedRecipe ret = new CraftShapedRecipe(recipe.getKey(), recipe.getResult());
        String[] shape = recipe.getShape();
        ret.shape(shape);
        Map<Character, ItemStack> ingredientMap = recipe.getIngredientMap();
        for (char c : ingredientMap.keySet()) {
            ItemStack stack = ingredientMap.get(Character.valueOf(c));
            if (stack == null) continue;
            ret.setIngredient(c, stack.getType(), stack.getDurability());
        }
        return ret;
    }

    @Override
    public void addToCraftingManager() {
        String[] shape = this.getShape();
        Map<Character, ItemStack> ingred = this.getIngredientMap();
        int width = shape[0].length();
        NonNullList data = NonNullList.a((int)(shape.length * width), (Object)RecipeItemStack.a);
        int i = 0;
        while (i < shape.length) {
            String row = shape[i];
            int j = 0;
            while (j < row.length()) {
                data.set(i * width + j, (Object)RecipeItemStack.a((net.minecraft.server.v1_12_R1.ItemStack[])new net.minecraft.server.v1_12_R1.ItemStack[]{CraftItemStack.asNMSCopy(ingred.get(Character.valueOf(row.charAt(j))))}));
                ++j;
            }
            ++i;
        }
        CraftingManager.a((MinecraftKey)CraftNamespacedKey.toMinecraft(this.getKey()), (IRecipe)new ShapedRecipes("", width, shape.length, data, CraftItemStack.asNMSCopy(this.getResult())));
    }
}

