/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.map;

import java.awt.Image;
import java.util.Arrays;
import org.bukkit.craftbukkit.v1_12_R1.map.CraftMapView;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapCursorCollection;
import org.bukkit.map.MapFont;
import org.bukkit.map.MapPalette;

public class CraftMapCanvas
implements MapCanvas {
    private final byte[] buffer = new byte[16384];
    private final CraftMapView mapView;
    private byte[] base;
    private MapCursorCollection cursors = new MapCursorCollection();

    protected CraftMapCanvas(CraftMapView mapView) {
        this.mapView = mapView;
        Arrays.fill(this.buffer, (byte)-1);
    }

    @Override
    public CraftMapView getMapView() {
        return this.mapView;
    }

    @Override
    public MapCursorCollection getCursors() {
        return this.cursors;
    }

    @Override
    public void setCursors(MapCursorCollection cursors) {
        this.cursors = cursors;
    }

    @Override
    public void setPixel(int x, int y, byte color) {
        if (x < 0 || y < 0 || x >= 128 || y >= 128) {
            return;
        }
        if (this.buffer[y * 128 + x] != color) {
            this.buffer[y * 128 + x] = color;
            this.mapView.worldMap.flagDirty(x, y);
        }
    }

    @Override
    public byte getPixel(int x, int y) {
        if (x < 0 || y < 0 || x >= 128 || y >= 128) {
            return 0;
        }
        return this.buffer[y * 128 + x];
    }

    @Override
    public byte getBasePixel(int x, int y) {
        if (x < 0 || y < 0 || x >= 128 || y >= 128) {
            return 0;
        }
        return this.base[y * 128 + x];
    }

    protected void setBase(byte[] base) {
        this.base = base;
    }

    protected byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public void drawImage(int x, int y, Image image) {
        byte[] bytes = MapPalette.imageToBytes(image);
        int x2 = 0;
        while (x2 < image.getWidth(null)) {
            int y2 = 0;
            while (y2 < image.getHeight(null)) {
                this.setPixel(x + x2, y + y2, bytes[y2 * image.getWidth(null) + x2]);
                ++y2;
            }
            ++x2;
        }
    }

    @Override
    public void drawText(int x, int y, MapFont font, String text) {
        int xStart = x;
        byte color = 44;
        if (!font.isValid(text)) {
            throw new IllegalArgumentException("text contains invalid characters");
        }
        int i = 0;
        while (i < text.length()) {
            block11: {
                char ch = text.charAt(i);
                if (ch == '\n') {
                    x = xStart;
                    y += font.getHeight() + 1;
                } else {
                    if (ch == '\u00a7') {
                        int j = text.indexOf(59, i);
                        if (j >= 0) {
                            try {
                                color = Byte.parseByte(text.substring(i + 1, j));
                                i = j;
                                break block11;
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        throw new IllegalArgumentException("Text contains unterminated color string");
                    }
                    MapFont.CharacterSprite sprite = font.getChar(text.charAt(i));
                    int r = 0;
                    while (r < font.getHeight()) {
                        int c = 0;
                        while (c < sprite.getWidth()) {
                            if (sprite.get(r, c)) {
                                this.setPixel(x + c, y + r, color);
                            }
                            ++c;
                        }
                        ++r;
                    }
                    x += sprite.getWidth() + 1;
                }
            }
            ++i;
        }
    }
}

