/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.util;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.server.v1_12_R1.ChatClickable;
import net.minecraft.server.v1_12_R1.ChatComponentText;
import net.minecraft.server.v1_12_R1.ChatMessage;
import net.minecraft.server.v1_12_R1.ChatModifier;
import net.minecraft.server.v1_12_R1.EnumChatFormat;
import net.minecraft.server.v1_12_R1.IChatBaseComponent;
import org.bukkit.ChatColor;

public final class CraftChatMessage {
    private static final Pattern LINK_PATTERN = Pattern.compile("((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " \\n]|$))))");
    private static final Map<Character, EnumChatFormat> formatMap;

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        EnumChatFormat[] enumChatFormatArray = EnumChatFormat.values();
        int n = enumChatFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            EnumChatFormat format = enumChatFormatArray[n2];
            builder.put((Object)Character.valueOf(Character.toLowerCase(format.toString().charAt(1))), (Object)format);
            ++n2;
        }
        formatMap = builder.build();
    }

    public static EnumChatFormat getColor(ChatColor color) {
        return formatMap.get(Character.valueOf(color.getChar()));
    }

    public static ChatColor getColor(EnumChatFormat format) {
        return ChatColor.getByChar(format.character);
    }

    public static IChatBaseComponent[] fromString(String message) {
        return CraftChatMessage.fromString(message, false);
    }

    public static IChatBaseComponent[] fromString(String message, boolean keepNewlines) {
        return new StringMessage(message, keepNewlines).getOutput();
    }

    public static String fromComponent(IChatBaseComponent component) {
        return CraftChatMessage.fromComponent(component, EnumChatFormat.BLACK);
    }

    public static String fromComponent(IChatBaseComponent component, EnumChatFormat defaultColor) {
        if (component == null) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        for (IChatBaseComponent c : component) {
            ChatModifier modi = c.getChatModifier();
            out.append(modi.getColor() == null ? defaultColor : modi.getColor());
            if (modi.isBold()) {
                out.append(EnumChatFormat.BOLD);
            }
            if (modi.isItalic()) {
                out.append(EnumChatFormat.ITALIC);
            }
            if (modi.isUnderlined()) {
                out.append(EnumChatFormat.UNDERLINE);
            }
            if (modi.isStrikethrough()) {
                out.append(EnumChatFormat.STRIKETHROUGH);
            }
            if (modi.isRandom()) {
                out.append(EnumChatFormat.OBFUSCATED);
            }
            out.append(c.getText());
        }
        return out.toString().replaceFirst("^(" + defaultColor + ")*", "");
    }

    public static IChatBaseComponent fixComponent(IChatBaseComponent component) {
        Matcher matcher = LINK_PATTERN.matcher("");
        return CraftChatMessage.fixComponent(component, matcher);
    }

    private static IChatBaseComponent fixComponent(IChatBaseComponent component, Matcher matcher) {
        ChatComponentText text;
        String msg;
        if (component instanceof ChatComponentText && matcher.reset(msg = (text = (ChatComponentText)component).g()).find()) {
            matcher.reset();
            ChatModifier modifier = text.getChatModifier() != null ? text.getChatModifier() : new ChatModifier();
            ArrayList<Object> extras = new ArrayList<Object>();
            ArrayList extrasOld = new ArrayList(text.a());
            text = new ChatComponentText("");
            component = text;
            int pos = 0;
            while (matcher.find()) {
                String match = matcher.group();
                if (!match.startsWith("http://") && !match.startsWith("https://")) {
                    match = "http://" + match;
                }
                ChatComponentText chatComponentText = new ChatComponentText(msg.substring(pos, matcher.start()));
                chatComponentText.setChatModifier(modifier);
                extras.add(chatComponentText);
                ChatComponentText link = new ChatComponentText(matcher.group());
                ChatModifier linkModi = modifier.clone();
                linkModi.setChatClickable(new ChatClickable(ChatClickable.EnumClickAction.OPEN_URL, match));
                link.setChatModifier(linkModi);
                extras.add(link);
                pos = matcher.end();
            }
            ChatComponentText prev = new ChatComponentText(msg.substring(pos));
            prev.setChatModifier(modifier);
            extras.add(prev);
            extras.addAll(extrasOld);
            for (IChatBaseComponent iChatBaseComponent : extras) {
                text.addSibling(iChatBaseComponent);
            }
        }
        List extras = component.a();
        int i = 0;
        while (i < extras.size()) {
            IChatBaseComponent comp = (IChatBaseComponent)extras.get(i);
            if (comp.getChatModifier() != null && comp.getChatModifier().h() == null) {
                extras.set(i, CraftChatMessage.fixComponent(comp, matcher));
            }
            ++i;
        }
        if (component instanceof ChatMessage) {
            Object[] subs = ((ChatMessage)component).j();
            int i2 = 0;
            while (i2 < subs.length) {
                Object comp = subs[i2];
                if (comp instanceof IChatBaseComponent) {
                    IChatBaseComponent c = (IChatBaseComponent)comp;
                    if (c.getChatModifier() != null && c.getChatModifier().h() == null) {
                        subs[i2] = CraftChatMessage.fixComponent(c, matcher);
                    }
                } else if (comp instanceof String && matcher.reset((String)comp).find()) {
                    subs[i2] = CraftChatMessage.fixComponent((IChatBaseComponent)new ChatComponentText((String)comp), matcher);
                }
                ++i2;
            }
        }
        return component;
    }

    private CraftChatMessage() {
    }

    private static class StringMessage {
        private static final Pattern INCREMENTAL_PATTERN = Pattern.compile("(" + String.valueOf('\u00a7') + "[0-9a-fk-or])|(\\n)|((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " \\n]|$))))", 2);
        private final List<IChatBaseComponent> list = new ArrayList<IChatBaseComponent>();
        private IChatBaseComponent currentChatComponent = new ChatComponentText("");
        private ChatModifier modifier = new ChatModifier();
        private final IChatBaseComponent[] output;
        private int currentIndex;
        private final String message;

        private StringMessage(String message, boolean keepNewlines) {
            this.message = message;
            if (message == null) {
                this.output = new IChatBaseComponent[]{this.currentChatComponent};
                return;
            }
            this.list.add(this.currentChatComponent);
            Matcher matcher = INCREMENTAL_PATTERN.matcher(message);
            String match = null;
            while (matcher.find()) {
                int groupId = 0;
                while ((match = matcher.group(++groupId)) == null) {
                }
                this.appendNewComponent(matcher.start(groupId));
                block0 : switch (groupId) {
                    case 1: {
                        EnumChatFormat format = (EnumChatFormat)formatMap.get(Character.valueOf(match.toLowerCase(Locale.ENGLISH).charAt(1)));
                        if (format == EnumChatFormat.RESET) {
                            this.modifier = new ChatModifier();
                            break;
                        }
                        if (format.isFormat()) {
                            switch (format) {
                                case BOLD: {
                                    this.modifier.setBold(Boolean.TRUE);
                                    break block0;
                                }
                                case ITALIC: {
                                    this.modifier.setItalic(Boolean.TRUE);
                                    break block0;
                                }
                                case STRIKETHROUGH: {
                                    this.modifier.setStrikethrough(Boolean.TRUE);
                                    break block0;
                                }
                                case UNDERLINE: {
                                    this.modifier.setUnderline(Boolean.TRUE);
                                    break block0;
                                }
                                case OBFUSCATED: {
                                    this.modifier.setRandom(Boolean.TRUE);
                                    break block0;
                                }
                            }
                            throw new AssertionError((Object)"Unexpected message format");
                        }
                        this.modifier = new ChatModifier().setColor(format);
                        break;
                    }
                    case 2: {
                        if (keepNewlines) {
                            this.currentChatComponent.addSibling((IChatBaseComponent)new ChatComponentText("\n"));
                            break;
                        }
                        this.currentChatComponent = null;
                        break;
                    }
                    case 3: {
                        if (!match.startsWith("http://") && !match.startsWith("https://")) {
                            match = "http://" + match;
                        }
                        this.modifier.setChatClickable(new ChatClickable(ChatClickable.EnumClickAction.OPEN_URL, match));
                        this.appendNewComponent(matcher.end(groupId));
                        this.modifier.setChatClickable(null);
                    }
                }
                this.currentIndex = matcher.end(groupId);
            }
            if (this.currentIndex < message.length()) {
                this.appendNewComponent(message.length());
            }
            this.output = this.list.toArray(new IChatBaseComponent[this.list.size()]);
        }

        private void appendNewComponent(int index) {
            if (index <= this.currentIndex) {
                return;
            }
            IChatBaseComponent addition = new ChatComponentText(this.message.substring(this.currentIndex, index)).setChatModifier(this.modifier);
            this.currentIndex = index;
            this.modifier = this.modifier.clone();
            if (this.currentChatComponent == null) {
                this.currentChatComponent = new ChatComponentText("");
                this.list.add(this.currentChatComponent);
            }
            this.currentChatComponent.addSibling(addition);
        }

        private IChatBaseComponent[] getOutput() {
            return this.output;
        }
    }
}

