/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.util;

import com.mojang.util.QueueLogAppender;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.craftbukkit.Main;
import org.bukkit.craftbukkit.libs.jline.console.ConsoleReader;
import org.fusesource.jansi.Ansi;

public class TerminalConsoleWriterThread
implements Runnable {
    private final ConsoleReader reader;
    private final OutputStream output;

    public TerminalConsoleWriterThread(OutputStream output, ConsoleReader reader) {
        this.output = output;
        this.reader = reader;
    }

    @Override
    public void run() {
        while (true) {
            String message;
            if ((message = QueueLogAppender.getNextLogEvent((String)"TerminalConsole")) == null) {
                continue;
            }
            try {
                if (Main.useJline) {
                    this.reader.print((CharSequence)(String.valueOf(Ansi.ansi().eraseLine(Ansi.Erase.ALL).toString()) + '\r'));
                    this.reader.flush();
                    this.output.write(message.getBytes());
                    this.output.flush();
                    try {
                        this.reader.drawLine();
                    }
                    catch (Throwable throwable) {
                        this.reader.getCursorBuffer().clear();
                    }
                    this.reader.flush();
                    continue;
                }
                this.output.write(message.getBytes());
                this.output.flush();
                continue;
            }
            catch (IOException ex) {
                Logger.getLogger(TerminalConsoleWriterThread.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            break;
        }
    }
}

