/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import java.util.List;
import net.minecraft.server.v1_12_R1.AxisAlignedBB;
import net.minecraft.server.v1_12_R1.Chunk;
import net.minecraft.server.v1_12_R1.Entity;
import net.minecraft.server.v1_12_R1.EntityAmbient;
import net.minecraft.server.v1_12_R1.EntityAnimal;
import net.minecraft.server.v1_12_R1.EntityArrow;
import net.minecraft.server.v1_12_R1.EntityComplexPart;
import net.minecraft.server.v1_12_R1.EntityCreature;
import net.minecraft.server.v1_12_R1.EntityCreeper;
import net.minecraft.server.v1_12_R1.EntityEnderCrystal;
import net.minecraft.server.v1_12_R1.EntityEnderDragon;
import net.minecraft.server.v1_12_R1.EntityFireball;
import net.minecraft.server.v1_12_R1.EntityFireworks;
import net.minecraft.server.v1_12_R1.EntityHuman;
import net.minecraft.server.v1_12_R1.EntityLiving;
import net.minecraft.server.v1_12_R1.EntityMonster;
import net.minecraft.server.v1_12_R1.EntityProjectile;
import net.minecraft.server.v1_12_R1.EntitySheep;
import net.minecraft.server.v1_12_R1.EntitySlime;
import net.minecraft.server.v1_12_R1.EntityTNTPrimed;
import net.minecraft.server.v1_12_R1.EntityVillager;
import net.minecraft.server.v1_12_R1.EntityWeather;
import net.minecraft.server.v1_12_R1.EntityWither;
import net.minecraft.server.v1_12_R1.MathHelper;
import net.minecraft.server.v1_12_R1.MinecraftServer;
import net.minecraft.server.v1_12_R1.World;
import org.bukkit.craftbukkit.v1_12_R1.SpigotTimings;
import org.spigotmc.SpigotWorldConfig;

public class ActivationRange {
    static AxisAlignedBB maxBB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static AxisAlignedBB miscBB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static AxisAlignedBB animalBB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static AxisAlignedBB monsterBB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public static byte initializeEntityActivationType(Entity entity) {
        if (entity instanceof EntityMonster || entity instanceof EntitySlime) {
            return 1;
        }
        if (entity instanceof EntityCreature || entity instanceof EntityAmbient) {
            return 2;
        }
        return 3;
    }

    public static boolean initializeEntityActivationState(Entity entity, SpigotWorldConfig config) {
        return entity.activationType == 3 && config.miscActivationRange == 0 || entity.activationType == 2 && config.animalActivationRange == 0 || entity.activationType == 1 && config.monsterActivationRange == 0 || entity instanceof EntityHuman || entity instanceof EntityProjectile || entity instanceof EntityEnderDragon || entity instanceof EntityComplexPart || entity instanceof EntityWither || entity instanceof EntityFireball || entity instanceof EntityWeather || entity instanceof EntityTNTPrimed || entity instanceof EntityEnderCrystal || entity instanceof EntityFireworks;
    }

    public static void activateEntities(World world) {
        SpigotTimings.entityActivationCheckTimer.startTiming();
        int miscActivationRange = world.spigotConfig.miscActivationRange;
        int animalActivationRange = world.spigotConfig.animalActivationRange;
        int monsterActivationRange = world.spigotConfig.monsterActivationRange;
        int maxRange = Math.max(monsterActivationRange, animalActivationRange);
        maxRange = Math.max(maxRange, miscActivationRange);
        maxRange = Math.min((world.spigotConfig.viewDistance << 4) - 8, maxRange);
        for (EntityHuman player : world.players) {
            player.activatedTick = MinecraftServer.currentTick;
            maxBB = player.getBoundingBox().grow((double)maxRange, 256.0, (double)maxRange);
            miscBB = player.getBoundingBox().grow((double)miscActivationRange, 256.0, (double)miscActivationRange);
            animalBB = player.getBoundingBox().grow((double)animalActivationRange, 256.0, (double)animalActivationRange);
            monsterBB = player.getBoundingBox().grow((double)monsterActivationRange, 256.0, (double)monsterActivationRange);
            int i = MathHelper.floor((double)(ActivationRange.maxBB.a / 16.0));
            int j = MathHelper.floor((double)(ActivationRange.maxBB.d / 16.0));
            int k = MathHelper.floor((double)(ActivationRange.maxBB.c / 16.0));
            int l = MathHelper.floor((double)(ActivationRange.maxBB.f / 16.0));
            int i1 = i;
            while (i1 <= j) {
                int j1 = k;
                while (j1 <= l) {
                    if (world.getWorld().isChunkLoaded(i1, j1)) {
                        ActivationRange.activateChunkEntities(world.getChunkAt(i1, j1));
                    }
                    ++j1;
                }
                ++i1;
            }
        }
        SpigotTimings.entityActivationCheckTimer.stopTiming();
    }

    private static void activateChunkEntities(Chunk chunk) {
        List[] listArray = chunk.entitySlices;
        int n = chunk.entitySlices.length;
        int n2 = 0;
        while (n2 < n) {
            List slice = listArray[n2];
            block5: for (Entity entity : slice) {
                if ((long)MinecraftServer.currentTick <= entity.activatedTick) continue;
                if (entity.defaultActivationState) {
                    entity.activatedTick = MinecraftServer.currentTick;
                    continue;
                }
                switch (entity.activationType) {
                    case 1: {
                        if (!monsterBB.c(entity.getBoundingBox())) continue block5;
                        entity.activatedTick = MinecraftServer.currentTick;
                        break;
                    }
                    case 2: {
                        if (!animalBB.c(entity.getBoundingBox())) continue block5;
                        entity.activatedTick = MinecraftServer.currentTick;
                        break;
                    }
                    default: {
                        if (!miscBB.c(entity.getBoundingBox())) continue block5;
                        entity.activatedTick = MinecraftServer.currentTick;
                    }
                }
            }
            ++n2;
        }
    }

    public static boolean checkEntityImmunities(Entity entity) {
        if (entity.inWater || entity.fireTicks > 0) {
            return true;
        }
        if (!(entity instanceof EntityArrow) ? !entity.onGround || !entity.passengers.isEmpty() || entity.isPassenger() : !((EntityArrow)entity).inGround) {
            return true;
        }
        if (entity instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)entity;
            if (living.hurtTicks > 0 || living.effects.size() > 0) {
                return true;
            }
            if (entity instanceof EntityCreature && ((EntityCreature)entity).getGoalTarget() != null) {
                return true;
            }
            if (entity instanceof EntityVillager && ((EntityVillager)entity).isInLove()) {
                return true;
            }
            if (entity instanceof EntityAnimal) {
                EntityAnimal animal = (EntityAnimal)entity;
                if (animal.isBaby() || animal.isInLove()) {
                    return true;
                }
                if (entity instanceof EntitySheep && ((EntitySheep)entity).isSheared()) {
                    return true;
                }
            }
            if (entity instanceof EntityCreeper && ((EntityCreeper)entity).isIgnited()) {
                return true;
            }
        }
        return false;
    }

    public static boolean checkIfActive(Entity entity) {
        boolean isActive;
        SpigotTimings.checkIfActiveTimer.startTiming();
        if (!entity.aa || entity instanceof EntityFireworks) {
            SpigotTimings.checkIfActiveTimer.stopTiming();
            return true;
        }
        boolean bl = isActive = entity.activatedTick >= (long)MinecraftServer.currentTick || entity.defaultActivationState;
        if (!isActive) {
            if (((long)MinecraftServer.currentTick - entity.activatedTick - 1L) % 20L == 0L) {
                if (ActivationRange.checkEntityImmunities(entity)) {
                    entity.activatedTick = MinecraftServer.currentTick + 20;
                }
                isActive = true;
            }
        } else if (!entity.defaultActivationState && entity.ticksLived % 4 == 0 && !ActivationRange.checkEntityImmunities(entity)) {
            isActive = false;
        }
        int x = MathHelper.floor((double)entity.locX);
        int z = MathHelper.floor((double)entity.locZ);
        Chunk chunk = entity.world.getChunkIfLoaded(x >> 4, z >> 4);
        if (isActive && (chunk == null || !chunk.areNeighborsLoaded(1))) {
            isActive = false;
        }
        SpigotTimings.checkIfActiveTimer.stopTiming();
        return isActive;
    }
}

