/*
 * Decompiled with CFR 0.152.
 */
package catserver.server;

import catserver.server.CatServer;
import com.google.common.collect.Lists;
import java.util.List;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class WorldCapture {
    private oo world;
    private boolean capture;
    private aed curPlayer;
    private aip curItemStack;
    private ub curHand;
    private List<EntitySnap> entitySnap = Lists.newArrayList();
    private List<ItemSnap> itemSnap = Lists.newArrayList();
    private static Class<?>[] excludeEntities = new Class[]{aed.class, abc.class};

    public WorldCapture(oo world) {
        this.world = world;
    }

    public void startCapture(aed player, aip stack, ub hand) {
        if (!CatServer.getConfig().enableCapture) {
            return;
        }
        this.curPlayer = player;
        this.curItemStack = stack;
        this.curHand = hand;
        this.entitySnap.clear();
        this.itemSnap.clear();
        this.capture = true;
    }

    public void stopCapture() {
        this.capture = false;
    }

    public boolean isCapture() {
        return this.capture && this.world.captureBlockSnapshots;
    }

    public void apply() {
        for (EntitySnap entitySnap : this.entitySnap) {
            entitySnap.apply();
        }
        for (ItemSnap itemSnap : this.itemSnap) {
            itemSnap.apply();
        }
    }

    public void restore() {
        this.curPlayer.a(this.curHand, this.curItemStack);
    }

    public void addEntitySnap(vg entity, CreatureSpawnEvent.SpawnReason reason) {
        if (this.world.restoringBlockSnapshots) {
            return;
        }
        this.entitySnap.add(new EntitySnap(entity, reason));
    }

    public void addItemSnap(aed player, aip stack) {
        if (this.world.restoringBlockSnapshots) {
            return;
        }
        this.itemSnap.add(new ItemSnap(player, stack));
    }

    public static boolean canCapture(vg entity) {
        for (Class<?> excludeEntity : excludeEntities) {
            if (!excludeEntity.isAssignableFrom(entity.getClass())) continue;
            return false;
        }
        return true;
    }

    class ItemSnap {
        private final aed player;
        private final aip stack;
        private boolean isApply;

        public ItemSnap(aed player, aip stack) {
            this.player = player;
            this.stack = stack;
        }

        public void apply() {
            if (!this.isApply) {
                if (this.player.bv.e(this.stack)) {
                    this.player.l.a((vg)new acl(this.player.l, this.player.p, this.player.q, this.player.r, this.stack));
                }
                this.isApply = true;
            }
        }
    }

    class EntitySnap {
        private final vg entity;
        private final CreatureSpawnEvent.SpawnReason reason;
        private boolean isApply;

        public EntitySnap(vg entity, CreatureSpawnEvent.SpawnReason reason) {
            this.entity = entity;
            this.reason = reason;
        }

        public void apply() {
            if (!this.isApply) {
                WorldCapture.this.world.addEntity(this.entity, this.reason);
                this.isApply = true;
            }
        }
    }
}

