/*
 * Decompiled with CFR 0.152.
 */
package catserver.server.command.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.common.FMLLog;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class CommandChunkStats
extends Command {
    private static Map<axw, Long> chunks = new HashMap<axw, Long>();
    public static boolean chunkStats = false;

    public CommandChunkStats(String name) {
        super(name);
        this.description = "Chunk Stats Command";
        this.usageMessage = "/chunkstats start/stop";
        this.setPermission("catserver.command.chunkstats");
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length != 1) {
            return false;
        }
        if (args[0].equals("start")) {
            chunks = new HashMap<axw, Long>();
            chunkStats = true;
            sender.sendMessage("Chunk stats started.");
            return true;
        }
        if (args[0].equals("stop")) {
            sender.sendMessage("Checking... Please see console");
            ArrayList<ChunkTime> chunkList = new ArrayList<ChunkTime>();
            for (int i = 0; i < 5; ++i) {
                axw hight = null;
                long t = 0L;
                for (axw chunk : chunks.keySet()) {
                    if (hight == null) {
                        hight = chunk;
                        t = chunks.get(chunk);
                        continue;
                    }
                    long tt = chunks.get(chunk);
                    if (tt <= t) continue;
                    hight = chunk;
                    t = tt;
                }
                chunkList.add(new ChunkTime(hight, t));
                chunks.remove(hight);
            }
            FMLLog.log.info("Chunks Time:");
            for (ChunkTime chunkTime : chunkList) {
                axw chunk = chunkTime.chunk;
                FMLLog.log.info("World:{} X:{} Z:{}, has run time: {} ns", (Object)chunk.q().x.j(), (Object)(chunk.b << 4), (Object)(chunk.c << 4), (Object)chunkTime.time);
            }
            return true;
        }
        return false;
    }

    public static void addTime(axw chunk, long time) {
        if (!chunkStats) {
            return;
        }
        Long oldTime = chunks.get(chunk);
        if (oldTime == null) {
            oldTime = 0L;
        }
        oldTime = oldTime + time;
        chunks.put(chunk, oldTime);
    }

    class ChunkTime {
        public final axw chunk;
        public final long time;

        public ChunkTime(axw chunk, long time) {
            this.chunk = chunk;
            this.time = time;
        }
    }
}

