/*
 * Decompiled with CFR 0.152.
 */
package catserver.server.remapper;

import catserver.server.remapper.CatClassLoader;
import catserver.server.remapper.CatHandleLookup;
import catserver.server.remapper.CatServerRemapper;
import catserver.server.remapper.CatURLClassLoader;
import catserver.server.remapper.ClassInheritanceProvider;
import catserver.server.remapper.MappingLoader;
import catserver.server.remapper.ReflectionMethods;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.provider.JointProvider;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class ReflectionTransformer {
    protected static Map<String, Class> remapStaticMethod = Maps.newHashMap();
    protected static Map<String, Class> remapVirtualMethod = Maps.newHashMap();
    protected static Map<String, Class> remapVirtualMethodToStatic = Maps.newHashMap();
    protected static Map<String, Class> remapSuperClass = Maps.newHashMap();
    public static JarMapping jarMapping;
    public static CatServerRemapper remapper;
    public static final HashMap<String, String> classDeMapping;
    public static final Multimap<String, String> methodDeMapping;
    public static final Multimap<String, String> fieldDeMapping;
    public static final Multimap<String, String> methodFastMapping;

    public static void init() {
        jarMapping = MappingLoader.loadMapping();
        JointProvider provider = new JointProvider();
        provider.add((InheritanceProvider)new ClassInheritanceProvider());
        jarMapping.setFallbackInheritanceProvider((InheritanceProvider)provider);
        remapper = new CatServerRemapper(jarMapping);
        ReflectionTransformer.jarMapping.classes.forEach((k, v) -> classDeMapping.put((String)v, (String)k));
        ReflectionTransformer.jarMapping.methods.forEach((k, v) -> methodDeMapping.put(v, k));
        ReflectionTransformer.jarMapping.fields.forEach((k, v) -> fieldDeMapping.put(v, k));
        ReflectionTransformer.jarMapping.methods.forEach((k, v) -> methodFastMapping.put((Object)k.split("\\s+")[0], k));
        try {
            Class.forName("catserver.server.remapper.CatHandleLookup");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static byte[] transform(byte[] code) {
        ClassReader reader = new ClassReader(code);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        boolean remapCL = false;
        Class remappedSuperClass = remapSuperClass.get(node.superName);
        if (remappedSuperClass != null) {
            if (remappedSuperClass == CatClassLoader.class) {
                remapVirtualMethod.put(node.name + ";defineClass", CatClassLoader.class);
            }
            node.superName = Type.getInternalName((Class)remappedSuperClass);
            remapCL = true;
        }
        for (MethodNode method : node.methods) {
            for (AbstractInsnNode next : method.instructions) {
                MethodInsnNode insn;
                if (next instanceof TypeInsnNode && next.getOpcode() == 187) {
                    insn = (TypeInsnNode)next;
                    Class remappedClass = remapSuperClass.get(insn.desc);
                    if (remappedClass != null) {
                        insn.desc = Type.getInternalName((Class)remappedClass);
                        remapCL = true;
                    }
                }
                if (!(next instanceof MethodInsnNode)) continue;
                insn = (MethodInsnNode)next;
                switch (insn.getOpcode()) {
                    case 182: {
                        ReflectionTransformer.remapVirtual((AbstractInsnNode)insn);
                        break;
                    }
                    case 184: {
                        ReflectionTransformer.remapStatic((AbstractInsnNode)insn);
                        break;
                    }
                    case 183: {
                        if (!remapCL) break;
                        ReflectionTransformer.remapSuperClass(insn);
                    }
                }
                if (!insn.owner.equals("javax/script/ScriptEngineManager") || !insn.desc.equals("()V") || !insn.name.equals("<init>")) continue;
                insn.desc = "(Ljava/lang/ClassLoader;)V";
                method.instructions.insertBefore((AbstractInsnNode)insn, (AbstractInsnNode)new MethodInsnNode(184, "java/lang/ClassLoader", "getSystemClassLoader", "()Ljava/lang/ClassLoader;"));
                ++method.maxStack;
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static void remapStatic(AbstractInsnNode insn) {
        MethodInsnNode method = (MethodInsnNode)insn;
        Class remappedClass = remapStaticMethod.get(method.owner + ";" + method.name);
        if (remappedClass != null) {
            method.owner = Type.getInternalName((Class)remappedClass);
        }
    }

    public static void remapVirtual(AbstractInsnNode insn) {
        MethodInsnNode method = (MethodInsnNode)insn;
        Class remappedClass = remapVirtualMethodToStatic.get(method.owner + ";" + method.name);
        if (remappedClass != null) {
            Type returnType = Type.getReturnType((String)method.desc);
            ArrayList<Type> args = new ArrayList<Type>();
            args.add(Type.getObjectType((String)method.owner));
            args.addAll(Arrays.asList(Type.getArgumentTypes((String)method.desc)));
            method.setOpcode(184);
            method.owner = Type.getInternalName((Class)remappedClass);
            method.desc = Type.getMethodDescriptor((Type)returnType, (Type[])args.toArray(new Type[0]));
        } else {
            remappedClass = remapVirtualMethod.get(method.owner + ";" + method.name);
            if (remappedClass != null) {
                method.name = method.name + "Remap";
                method.owner = Type.getInternalName((Class)remappedClass);
            }
        }
    }

    private static void remapSuperClass(MethodInsnNode method) {
        Class remappedClass = remapSuperClass.get(method.owner);
        if (remappedClass != null && method.name.equals("<init>")) {
            method.owner = Type.getInternalName((Class)remappedClass);
        }
    }

    static {
        classDeMapping = Maps.newHashMap();
        methodDeMapping = ArrayListMultimap.create();
        fieldDeMapping = ArrayListMultimap.create();
        methodFastMapping = ArrayListMultimap.create();
        remapStaticMethod.put("java/lang/Class;forName", ReflectionMethods.class);
        remapStaticMethod.put("java/lang/invoke/MethodType;fromMethodDescriptorString", CatHandleLookup.class);
        remapVirtualMethodToStatic.put("java/lang/Class;getField", ReflectionMethods.class);
        remapVirtualMethodToStatic.put("java/lang/Class;getDeclaredField", ReflectionMethods.class);
        remapVirtualMethodToStatic.put("java/lang/Class;getMethod", ReflectionMethods.class);
        remapVirtualMethodToStatic.put("java/lang/Class;getDeclaredMethod", ReflectionMethods.class);
        remapVirtualMethodToStatic.put("java/lang/Class;getSimpleName", ReflectionMethods.class);
        remapVirtualMethodToStatic.put("java/lang/Class;getDeclaredMethods", ReflectionMethods.class);
        remapVirtualMethodToStatic.put("java/lang/reflect/Field;getName", ReflectionMethods.class);
        remapVirtualMethodToStatic.put("java/lang/reflect/Method;getName", ReflectionMethods.class);
        remapVirtualMethodToStatic.put("java/lang/ClassLoader;loadClass", ReflectionMethods.class);
        remapVirtualMethodToStatic.put("java/lang/invoke/MethodHandles$Lookup;findVirtual", CatHandleLookup.class);
        remapVirtualMethodToStatic.put("java/lang/invoke/MethodHandles$Lookup;findStatic", CatHandleLookup.class);
        remapVirtualMethodToStatic.put("java/lang/invoke/MethodHandles$Lookup;findSpecial", CatHandleLookup.class);
        remapVirtualMethodToStatic.put("java/lang/invoke/MethodHandles$Lookup;unreflect", CatHandleLookup.class);
        remapSuperClass.put("java/net/URLClassLoader", CatURLClassLoader.class);
        remapSuperClass.put("java/lang/ClassLoader", CatClassLoader.class);
    }
}

