/*
 * Decompiled with CFR 0.152.
 */
package catserver.server.utils;

import catserver.server.CatServer;
import catserver.server.utils.LanguageUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import java.util.function.Predicate;
import net.minecraftforge.fml.common.FMLLog;
import org.bukkit.Bukkit;
import org.spigotmc.AsyncCatcher;

public class ThreadSafeList<E>
extends Vector<E> {
    private static final String message = LanguageUtils.I18nToString("async.caught_async");
    private final boolean warn;

    public ThreadSafeList(boolean warn) {
        this.warn = warn;
    }

    @Override
    public boolean add(E e) {
        if (this.checkThread()) {
            CatServer.postPrimaryThread(() -> super.add(e));
            if (this.warn) {
                FMLLog.log.debug((Object)new UnsupportedOperationException(message));
            }
            return true;
        }
        return super.add(e);
    }

    @Override
    public void add(int index, E element) {
        if (this.checkThread()) {
            CatServer.postPrimaryThread(() -> super.add(index, element));
            if (this.warn) {
                FMLLog.log.debug((Object)new UnsupportedOperationException(message));
            }
            return;
        }
        super.add(index, element);
    }

    @Override
    public boolean remove(Object o) {
        if (this.checkThread()) {
            CatServer.postPrimaryThread(() -> super.remove(o));
            if (this.warn) {
                FMLLog.log.debug((Object)new UnsupportedOperationException(message));
            }
            return super.contains(o);
        }
        return super.remove(o);
    }

    @Override
    public synchronized E remove(int index) {
        if (this.checkThread()) {
            Object removeE = super.get(index);
            CatServer.postPrimaryThread(() -> super.remove(removeE));
            if (this.warn) {
                FMLLog.log.debug((Object)new UnsupportedOperationException(message));
            }
            return removeE;
        }
        return super.remove(index);
    }

    @Override
    public void clear() {
        if (this.checkThread()) {
            CatServer.postPrimaryThread(() -> super.clear());
            if (this.warn) {
                FMLLog.log.debug((Object)new UnsupportedOperationException(message));
            }
            return;
        }
        super.clear();
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> c2) {
        if (this.checkThread()) {
            CatServer.postPrimaryThread(() -> super.addAll(c2));
            if (this.warn) {
                FMLLog.log.debug((Object)new UnsupportedOperationException(message));
            }
            return true;
        }
        return super.addAll(c2);
    }

    @Override
    public synchronized boolean addAll(int index, Collection<? extends E> c2) {
        if (this.checkThread()) {
            CatServer.postPrimaryThread(() -> super.addAll(index, c2));
            if (this.warn) {
                FMLLog.log.debug((Object)new UnsupportedOperationException(message));
            }
            return true;
        }
        return super.addAll(index, c2);
    }

    @Override
    public synchronized void addElement(E obj) {
        if (this.checkThread()) {
            CatServer.postPrimaryThread(() -> super.addElement(obj));
            if (this.warn) {
                FMLLog.log.debug((Object)new UnsupportedOperationException(message));
            }
            return;
        }
        super.addElement(obj);
    }

    @Override
    public synchronized void removeElementAt(int index) {
        if (this.checkThread()) {
            if (this.warn) {
                FMLLog.log.debug((Object)new UnsupportedOperationException(message));
            }
            return;
        }
        super.removeElementAt(index);
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c2) {
        if (this.checkThread()) {
            if (this.warn) {
                FMLLog.log.debug((Object)new UnsupportedOperationException(message));
            }
            return false;
        }
        return super.removeAll(c2);
    }

    @Override
    public synchronized void removeAllElements() {
        if (this.checkThread()) {
            if (this.warn) {
                FMLLog.log.debug((Object)new UnsupportedOperationException(message));
            }
            return;
        }
        super.removeAllElements();
    }

    @Override
    public synchronized boolean removeElement(Object obj) {
        if (this.checkThread()) {
            if (this.warn) {
                FMLLog.log.debug((Object)new UnsupportedOperationException(message));
            }
            return false;
        }
        return super.removeElement(obj);
    }

    @Override
    public synchronized boolean removeIf(Predicate<? super E> filter) {
        if (this.checkThread()) {
            if (this.warn) {
                FMLLog.log.debug((Object)new UnsupportedOperationException(message));
            }
            return false;
        }
        return super.removeIf(filter);
    }

    @Override
    public synchronized Iterator<E> iterator() {
        if (this.checkThread()) {
            if (this.warn) {
                FMLLog.log.debug((Object)new UnsupportedOperationException(message));
            }
            return new ArrayList(this).iterator();
        }
        return super.iterator();
    }

    private boolean checkThread() {
        return AsyncCatcher.enabled && !Bukkit.isPrimaryThread();
    }
}

