/*
 * Decompiled with CFR 0.152.
 */
package com.conversantmedia.util.concurrent;

import com.conversantmedia.util.concurrent.ConcurrentQueue;
import com.conversantmedia.util.concurrent.ContendedAtomicLong;

class MPMCConcurrentQueue<E>
implements ConcurrentQueue<E> {
    protected final int size;
    final long mask;
    final Cell<E>[] buffer;
    final ContendedAtomicLong head = new ContendedAtomicLong(0L);
    final ContendedAtomicLong tail = new ContendedAtomicLong(0L);

    public MPMCConcurrentQueue(int capacity) {
        int c2;
        for (c2 = 2; c2 < capacity; c2 <<= 1) {
        }
        this.size = c2;
        this.mask = (long)this.size - 1L;
        this.buffer = new Cell[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.buffer[i] = new Cell(i);
        }
    }

    @Override
    public boolean offer(E e) {
        Cell<E> cell;
        long tail = this.tail.get();
        while (true) {
            cell = this.buffer[(int)(tail & this.mask)];
            long seq = cell.seq.get();
            long dif = seq - tail;
            if (dif == 0L) {
                if (!this.tail.compareAndSet(tail, tail + 1L)) continue;
                break;
            }
            if (dif < 0L) {
                return false;
            }
            tail = this.tail.get();
        }
        cell.entry = e;
        cell.seq.set(tail + 1L);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        Cell<E> cell;
        long head = this.head.get();
        while (true) {
            cell = this.buffer[(int)(head & this.mask)];
            long seq = cell.seq.get();
            long dif = seq - (head + 1L);
            if (dif == 0L) {
                if (!this.head.compareAndSet(head, head + 1L)) continue;
                break;
            }
            if (dif < 0L) {
                return null;
            }
            head = this.head.get();
        }
        try {
            Object r = cell.entry;
            return (E)r;
        }
        finally {
            cell.entry = null;
            cell.seq.set(head + this.mask + 1L);
        }
    }

    @Override
    public final E peek() {
        return (E)this.buffer[(int)(this.head.get() & this.mask)].entry;
    }

    @Override
    public int remove(E[] e) {
        int nRead = 0;
        while (nRead < e.length && !this.isEmpty()) {
            E entry = this.poll();
            if (entry == null) continue;
            e[nRead++] = entry;
        }
        return nRead;
    }

    @Override
    public final int size() {
        return (int)Math.max(this.tail.get() - this.head.get(), 0L);
    }

    @Override
    public int capacity() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.head.get() == this.tail.get();
    }

    @Override
    public void clear() {
        while (!this.isEmpty()) {
            this.poll();
        }
    }

    @Override
    public final boolean contains(Object o) {
        for (int i = 0; i < this.size(); ++i) {
            int slot = (int)(this.head.get() + (long)i & this.mask);
            if (this.buffer[slot].entry == null || !this.buffer[slot].entry.equals(o)) continue;
            return true;
        }
        return false;
    }

    protected static final class Cell<R> {
        final ContendedAtomicLong seq = new ContendedAtomicLong(0L);
        public long p1;
        public long p2;
        public long p3;
        public long p4;
        public long p5;
        public long p6;
        public long p7;
        R entry;
        public long a1;
        public long a2;
        public long a3;
        public long a4;
        public long a5;
        public long a6;
        public long a7;
        public long a8;

        Cell(long s) {
            this.seq.set(s);
            this.entry = null;
        }

        public long sumToAvoidOptimization() {
            return this.p1 + this.p2 + this.p3 + this.p4 + this.p5 + this.p6 + this.p7 + this.a1 + this.a2 + this.a3 + this.a4 + this.a5 + this.a6 + this.a7 + this.a8;
        }
    }
}

