/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.common.util.FakePlayer;

public class FakePlayerFactory {
    private static GameProfile MINECRAFT = new GameProfile(UUID.fromString("41C82C87-7AfB-4024-BA57-13D2C99CAE77"), "[Minecraft]");
    private static Map<GameProfile, FakePlayer> fakePlayers = Maps.newHashMap();
    private static WeakReference<FakePlayer> MINECRAFT_PLAYER = null;

    public static FakePlayer getMinecraft(oo world) {
        FakePlayer ret;
        FakePlayer fakePlayer = ret = MINECRAFT_PLAYER != null ? (FakePlayer)((Object)MINECRAFT_PLAYER.get()) : null;
        if (ret == null) {
            ret = FakePlayerFactory.get(world, MINECRAFT);
            MINECRAFT_PLAYER = new WeakReference<FakePlayer>(ret);
        }
        return ret;
    }

    public static FakePlayer get(oo world, GameProfile username) {
        if (username == null || username.getName() == null) {
            return null;
        }
        for (Map.Entry<GameProfile, FakePlayer> mapEntry : fakePlayers.entrySet()) {
            GameProfile gameprofile = mapEntry.getKey();
            if (!gameprofile.getName().equals(username.getName())) continue;
            return mapEntry.getValue();
        }
        FakePlayer fakePlayer = new FakePlayer(world, username);
        if (username.getId() == null) {
            username = new GameProfile(UUID.nameUUIDFromBytes(("OfflinePlayer:" + username.getName()).getBytes(StandardCharsets.UTF_8)), username.getName());
        }
        fakePlayers.put(username, fakePlayer);
        return fakePlayers.get(username);
    }

    public static void unloadWorld(oo world) {
        FakePlayer mc;
        fakePlayers.entrySet().removeIf(entry -> ((FakePlayer)((Object)((Object)entry.getValue()))).l == world);
        if (MINECRAFT_PLAYER != null && MINECRAFT_PLAYER.get() != null && ((FakePlayer)((Object)FakePlayerFactory.MINECRAFT_PLAYER.get())).l == world && (mc = (FakePlayer)((Object)MINECRAFT_PLAYER.get())) != null && mc.l == world) {
            MINECRAFT_PLAYER = null;
        }
    }
}

