/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.launcher;

import io.netty.util.internal.ConcurrentSet;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.launcher.FMLTweaker;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;

public class FMLServerTweaker
extends FMLTweaker {
    @Override
    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
        super.acceptOptions(args, gameDir, assetsDir, profile);
        if (System.getProperty("log4j.configurationFile") == null) {
            System.setProperty("log4j.configurationFile", "log4j2.xml");
            ((LoggerContext)LogManager.getContext((boolean)false)).reconfigure();
        }
    }

    @Override
    public String getLaunchTarget() {
        return "net.minecraft.server.MinecraftServer";
    }

    @Override
    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
        classLoader.addClassLoaderExclusion("com.mojang.util.QueueLogAppender");
        classLoader.addClassLoaderExclusion("jline.");
        classLoader.addClassLoaderExclusion("org.fusesource.");
        classLoader.addClassLoaderExclusion("net.minecraftforge.server.console.log4j.TerminalConsoleAppender");
        ReflectionHelper.setPrivateValue(LaunchClassLoader.class, classLoader, new HashSet<String>(){

            @Override
            public boolean contains(Object o) {
                return false;
            }

            @Override
            public boolean add(String s) {
                return true;
            }
        }, "invalidClasses");
        ConcurrentSet currSet = new ConcurrentSet();
        currSet.addAll((Collection)ReflectionHelper.getPrivateValue(LaunchClassLoader.class, classLoader, "transformerExceptions"));
        ReflectionHelper.setPrivateValue(LaunchClassLoader.class, classLoader, currSet, "transformerExceptions");
        FMLLaunchHandler.configureForServerLaunch(classLoader, this);
        FMLLaunchHandler.appendCoreMods();
    }
}

