/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.relauncher;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.apache.commons.lang3.StringUtils;

@Deprecated
public class ReflectionHelper {
    @Deprecated
    public static Field findField(Class<?> clazz, String ... fieldNames) {
        Exception failed = null;
        for (String fieldName : fieldNames) {
            try {
                Field f2 = clazz.getDeclaredField(fieldName);
                f2.setAccessible(true);
                return f2;
            }
            catch (Exception e2) {
                failed = e2;
            }
        }
        throw new UnableToFindFieldException(fieldNames, failed);
    }

    @Nonnull
    public static Field findField(@Nonnull Class<?> clazz, @Nonnull String fieldName, @Nullable String fieldObfName) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)fieldName), (Object)"Field name cannot be empty");
        String nameToFind = FMLLaunchHandler.isDeobfuscatedEnvironment() ? fieldName : (String)MoreObjects.firstNonNull((Object)fieldObfName, (Object)fieldName);
        try {
            Field f2 = clazz.getDeclaredField(nameToFind);
            f2.setAccessible(true);
            return f2;
        }
        catch (Exception e2) {
            throw new UnableToFindFieldException(e2);
        }
    }

    @Deprecated
    public static <T, E> T getPrivateValue(Class<? super E> classToAccess, @Nullable E instance, int fieldIndex) {
        try {
            Field f2 = classToAccess.getDeclaredFields()[fieldIndex];
            f2.setAccessible(true);
            return (T)f2.get(instance);
        }
        catch (Exception e2) {
            throw new UnableToAccessFieldException(e2);
        }
    }

    @Deprecated
    public static <T, E> T getPrivateValue(Class<? super E> classToAccess, E instance, String ... fieldNames) {
        try {
            return (T)ReflectionHelper.findField(classToAccess, fieldNames).get(instance);
        }
        catch (Exception e2) {
            throw new UnableToAccessFieldException(fieldNames, e2);
        }
    }

    public static <T, E> T getPrivateValue(Class<? super E> classToAccess, @Nullable E instance, String fieldName, @Nullable String fieldObfName) {
        try {
            return (T)ReflectionHelper.findField(classToAccess, fieldName, fieldObfName).get(instance);
        }
        catch (Exception e2) {
            throw new UnableToAccessFieldException(e2);
        }
    }

    @Deprecated
    public static <T, E> void setPrivateValue(Class<? super T> classToAccess, T instance, E value, int fieldIndex) {
        try {
            Field f2 = classToAccess.getDeclaredFields()[fieldIndex];
            f2.setAccessible(true);
            f2.set(instance, value);
        }
        catch (Exception e2) {
            throw new UnableToAccessFieldException(e2);
        }
    }

    @Deprecated
    public static <T, E> void setPrivateValue(Class<? super T> classToAccess, T instance, E value, String ... fieldNames) {
        try {
            ReflectionHelper.findField(classToAccess, fieldNames).set(instance, value);
        }
        catch (Exception e2) {
            throw new UnableToAccessFieldException(fieldNames, e2);
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> classToAccess, @Nullable T instance, @Nullable E value, String fieldName, @Nullable String fieldObfName) {
        try {
            ReflectionHelper.findField(classToAccess, fieldName, fieldObfName).set(instance, value);
        }
        catch (Exception e2) {
            throw new UnableToAccessFieldException(e2);
        }
    }

    public static Class<? super Object> getClass(ClassLoader loader, String ... classNames) {
        Exception err = null;
        for (String className : classNames) {
            try {
                return Class.forName(className, false, loader);
            }
            catch (Exception e2) {
                err = e2;
            }
        }
        throw new UnableToFindClassException(classNames, err);
    }

    @Nonnull
    public static Method findMethod(@Nonnull Class<?> clazz, @Nonnull String methodName, @Nullable String methodObfName, Class<?> ... parameterTypes) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)methodName), (Object)"Method name cannot be empty");
        String nameToFind = FMLLaunchHandler.isDeobfuscatedEnvironment() ? methodName : (String)MoreObjects.firstNonNull((Object)methodObfName, (Object)methodName);
        try {
            Method m = clazz.getDeclaredMethod(nameToFind, parameterTypes);
            m.setAccessible(true);
            return m;
        }
        catch (Exception e2) {
            throw new UnableToFindMethodException(e2);
        }
    }

    @Nonnull
    public static <T> Constructor<T> findConstructor(@Nonnull Class<T> klass, Class<?> ... parameterTypes) {
        Preconditions.checkNotNull(klass, (Object)"class");
        Preconditions.checkNotNull(parameterTypes, (Object)"parameter types");
        try {
            Constructor<T> constructor = klass.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException e2) {
            StringBuilder desc = new StringBuilder();
            desc.append(klass.getSimpleName());
            StringJoiner joiner = new StringJoiner(", ", "(", ")");
            for (Class<?> type : parameterTypes) {
                joiner.add(type.getSimpleName());
            }
            desc.append(joiner);
            throw new UnknownConstructorException("Could not find constructor '" + desc.toString() + "' in " + klass);
        }
    }

    public static class UnknownConstructorException
    extends RuntimeException {
        public UnknownConstructorException(String message) {
            super(message);
        }
    }

    public static class UnableToFindFieldException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        @Deprecated
        public UnableToFindFieldException(String[] fieldNameList, Exception e2) {
            super(e2);
        }

        public UnableToFindFieldException(Exception e2) {
            super(e2);
        }
    }

    public static class UnableToAccessFieldException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        @Deprecated
        public UnableToAccessFieldException(String[] fieldNames, Exception e2) {
            super(e2);
        }

        public UnableToAccessFieldException(Exception e2) {
            super(e2);
        }
    }

    public static class UnableToFindClassException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnableToFindClassException(String[] classNames, @Nullable Exception err) {
            super(err);
        }
    }

    public static class UnableToFindMethodException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        @Deprecated
        public UnableToFindMethodException(String[] methodNames, Exception failed) {
            super(failed);
        }

        public UnableToFindMethodException(Throwable failed) {
            super(failed);
        }
    }
}

