/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.util.Date;
import java.util.Set;
import java.util.logging.Level;
import net.minecraft.server.v1_12_R1.GameProfileBanEntry;
import net.minecraft.server.v1_12_R1.GameProfileBanList;
import net.minecraft.server.v1_12_R1.JsonListEntry;
import net.minecraft.server.v1_12_R1.MinecraftServer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_12_R1.CraftProfileBanEntry;

public class CraftProfileBanList
implements BanList {
    private final GameProfileBanList list;

    public CraftProfileBanList(GameProfileBanList list) {
        this.list = list;
    }

    @Override
    public BanEntry getBanEntry(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null");
        GameProfile profile = MinecraftServer.getServer().getUserCache().getProfile(target);
        if (profile == null) {
            return null;
        }
        GameProfileBanEntry entry = (GameProfileBanEntry)this.list.get((Object)profile);
        if (entry == null) {
            return null;
        }
        return new CraftProfileBanEntry(profile, entry, this.list);
    }

    @Override
    public BanEntry addBan(String target, String reason, Date expires, String source) {
        Validate.notNull((Object)target, (String)"Ban target cannot be null");
        GameProfile profile = MinecraftServer.getServer().getUserCache().getProfile(target);
        if (profile == null) {
            return null;
        }
        GameProfileBanEntry entry = new GameProfileBanEntry(profile, new Date(), StringUtils.isBlank((String)source) ? null : source, expires, StringUtils.isBlank((String)reason) ? null : reason);
        this.list.add((JsonListEntry)entry);
        try {
            this.list.save();
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Failed to save banned-players.json, {0}", ex.getMessage());
        }
        return new CraftProfileBanEntry(profile, entry, this.list);
    }

    @Override
    public Set<BanEntry> getBanEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JsonListEntry entry : this.list.getValues()) {
            GameProfile profile = (GameProfile)entry.getKey();
            builder.add((Object)new CraftProfileBanEntry(profile, (GameProfileBanEntry)entry, this.list));
        }
        return builder.build();
    }

    @Override
    public boolean isBanned(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null");
        GameProfile profile = MinecraftServer.getServer().getUserCache().getProfile(target);
        if (profile == null) {
            return false;
        }
        return this.list.isBanned(profile);
    }

    @Override
    public void pardon(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null");
        GameProfile profile = MinecraftServer.getServer().getUserCache().getProfile(target);
        this.list.remove((Object)profile);
    }
}

