/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.block;

import java.util.Objects;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.TileEntityEndGateway;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.EndGateway;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBlockEntityState;

public class CraftEndGateway
extends CraftBlockEntityState<TileEntityEndGateway>
implements EndGateway {
    public CraftEndGateway(Block block) {
        super(block, TileEntityEndGateway.class);
    }

    public CraftEndGateway(Material material, TileEntityEndGateway te) {
        super(material, te);
    }

    @Override
    public Location getExitLocation() {
        BlockPosition pos = ((TileEntityEndGateway)this.getSnapshot()).exitPortal;
        return pos == null ? null : new Location(this.isPlaced() ? this.getWorld() : null, pos.getX(), pos.getY(), pos.getZ());
    }

    @Override
    public void setExitLocation(Location location) {
        if (location == null) {
            ((TileEntityEndGateway)this.getSnapshot()).exitPortal = null;
        } else {
            if (!Objects.equals(location.getWorld(), this.isPlaced() ? this.getWorld() : null)) {
                throw new IllegalArgumentException("Cannot set exit location to different world");
            }
            ((TileEntityEndGateway)this.getSnapshot()).exitPortal = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        }
    }

    @Override
    public boolean isExactTeleport() {
        return ((TileEntityEndGateway)this.getSnapshot()).exactTeleport;
    }

    @Override
    public void setExactTeleport(boolean exact) {
        ((TileEntityEndGateway)this.getSnapshot()).exactTeleport = exact;
    }

    @Override
    public void applyTo(TileEntityEndGateway endGateway) {
        super.applyTo(endGateway);
        if (((TileEntityEndGateway)this.getSnapshot()).exitPortal == null) {
            endGateway.exitPortal = null;
        }
    }
}

