/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.block;

import com.google.common.base.Preconditions;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.EnumBlockMirror;
import net.minecraft.server.v1_12_R1.EnumBlockRotation;
import net.minecraft.server.v1_12_R1.TileEntityStructure;
import org.apache.commons.lang3.Validate;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Structure;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.block.structure.UsageMode;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftLivingEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.BlockVector;

public class CraftStructureBlock
extends CraftBlockEntityState<TileEntityStructure>
implements Structure {
    private static final int MAX_SIZE = 32;

    public CraftStructureBlock(Block block) {
        super(block, TileEntityStructure.class);
    }

    public CraftStructureBlock(Material material, TileEntityStructure structure) {
        super(material, structure);
    }

    @Override
    public String getStructureName() {
        return ((TileEntityStructure)this.getSnapshot()).a();
    }

    @Override
    public void setStructureName(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Structure Name cannot be null");
        ((TileEntityStructure)this.getSnapshot()).a(name);
    }

    @Override
    public String getAuthor() {
        return ((TileEntityStructure)this.getSnapshot()).f;
    }

    @Override
    public void setAuthor(String author) {
        Preconditions.checkArgument((author != null && !author.isEmpty() ? 1 : 0) != 0, (Object)"Author name cannot be null nor empty");
        ((TileEntityStructure)this.getSnapshot()).f = author;
    }

    @Override
    public void setAuthor(LivingEntity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Structure Block author entity cannot be null");
        ((TileEntityStructure)this.getSnapshot()).a(((CraftLivingEntity)entity).getHandle());
    }

    @Override
    public BlockVector getRelativePosition() {
        return new BlockVector(((TileEntityStructure)this.getSnapshot()).h.getX(), ((TileEntityStructure)this.getSnapshot()).h.getY(), ((TileEntityStructure)this.getSnapshot()).h.getZ());
    }

    @Override
    public void setRelativePosition(BlockVector vector) {
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(vector.getBlockX(), -32, 32), (String)"Structure Size (X) must be between -32 and 32", (Object[])new Object[0]);
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(vector.getBlockY(), -32, 32), (String)"Structure Size (Y) must be between -32 and 32", (Object[])new Object[0]);
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(vector.getBlockZ(), -32, 32), (String)"Structure Size (Z) must be between -32 and 32", (Object[])new Object[0]);
        ((TileEntityStructure)this.getSnapshot()).h = new BlockPosition(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    @Override
    public BlockVector getStructureSize() {
        return new BlockVector(((TileEntityStructure)this.getSnapshot()).i.getX(), ((TileEntityStructure)this.getSnapshot()).i.getY(), ((TileEntityStructure)this.getSnapshot()).i.getZ());
    }

    @Override
    public void setStructureSize(BlockVector vector) {
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(vector.getBlockX(), 0, 32), (String)"Structure Size (X) must be between 0 and 32", (Object[])new Object[0]);
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(vector.getBlockY(), 0, 32), (String)"Structure Size (Y) must be between 0 and 32", (Object[])new Object[0]);
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(vector.getBlockZ(), 0, 32), (String)"Structure Size (Z) must be between 0 and 32", (Object[])new Object[0]);
        ((TileEntityStructure)this.getSnapshot()).i = new BlockPosition(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    @Override
    public void setMirror(Mirror mirror) {
        ((TileEntityStructure)this.getSnapshot()).j = EnumBlockMirror.valueOf((String)mirror.name());
    }

    @Override
    public Mirror getMirror() {
        return Mirror.valueOf(((TileEntityStructure)this.getSnapshot()).j.name());
    }

    @Override
    public void setRotation(StructureRotation rotation) {
        ((TileEntityStructure)this.getSnapshot()).k = EnumBlockRotation.valueOf((String)rotation.name());
    }

    @Override
    public StructureRotation getRotation() {
        return StructureRotation.valueOf(((TileEntityStructure)this.getSnapshot()).k.name());
    }

    @Override
    public void setUsageMode(UsageMode mode) {
        ((TileEntityStructure)this.getSnapshot()).a(TileEntityStructure.UsageMode.valueOf((String)mode.name()));
    }

    @Override
    public UsageMode getUsageMode() {
        return UsageMode.valueOf(((TileEntityStructure)this.getSnapshot()).k().name());
    }

    @Override
    public void setIgnoreEntities(boolean flag) {
        ((TileEntityStructure)this.getSnapshot()).m = flag;
    }

    @Override
    public boolean isIgnoreEntities() {
        return ((TileEntityStructure)this.getSnapshot()).m;
    }

    @Override
    public void setShowAir(boolean showAir) {
        ((TileEntityStructure)this.getSnapshot()).o = showAir;
    }

    @Override
    public boolean isShowAir() {
        return ((TileEntityStructure)this.getSnapshot()).o;
    }

    @Override
    public void setBoundingBoxVisible(boolean showBoundingBox) {
        ((TileEntityStructure)this.getSnapshot()).p = showBoundingBox;
    }

    @Override
    public boolean isBoundingBoxVisible() {
        return ((TileEntityStructure)this.getSnapshot()).p;
    }

    @Override
    public void setIntegrity(float integrity) {
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(integrity, 0.0f, 1.0f), (String)"Integrity must be between 0.0f and 1.0f", (Object[])new Object[0]);
        ((TileEntityStructure)this.getSnapshot()).q = integrity;
    }

    @Override
    public float getIntegrity() {
        return ((TileEntityStructure)this.getSnapshot()).q;
    }

    @Override
    public void setSeed(long seed) {
        ((TileEntityStructure)this.getSnapshot()).r = seed;
    }

    @Override
    public long getSeed() {
        return ((TileEntityStructure)this.getSnapshot()).r;
    }

    @Override
    public void setMetadata(String metadata) {
        Validate.notNull((Object)metadata, (String)"Structure metadata cannot be null", (Object[])new Object[0]);
        if (this.getUsageMode() == UsageMode.DATA) {
            ((TileEntityStructure)this.getSnapshot()).g = metadata;
        }
    }

    @Override
    public String getMetadata() {
        return ((TileEntityStructure)this.getSnapshot()).g;
    }

    private static boolean isBetween(int num, int min, int max) {
        return num >= min && num <= max;
    }

    private static boolean isBetween(float num, float min, float max) {
        return num >= min && num <= max;
    }
}

