/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.boss;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.server.v1_12_R1.BossBattle;
import net.minecraft.server.v1_12_R1.BossBattleServer;
import net.minecraft.server.v1_12_R1.EntityPlayer;
import net.minecraft.server.v1_12_R1.PacketPlayOutBoss;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_12_R1.util.CraftChatMessage;
import org.bukkit.entity.Player;

public class CraftBossBar
implements BossBar {
    private final BossBattleServer handle;
    private final Set<BarFlag> flags;
    private BarColor color;
    private BarStyle style;

    public CraftBossBar(String title, BarColor color, BarStyle style, BarFlag ... flags) {
        this.flags = flags.length > 0 ? EnumSet.of(flags[0], flags) : EnumSet.noneOf(BarFlag.class);
        this.color = color;
        this.style = style;
        this.handle = new BossBattleServer(CraftChatMessage.fromString(title, true)[0], this.convertColor(color), this.convertStyle(style));
        this.updateFlags();
    }

    private BossBattle.BarColor convertColor(BarColor color) {
        BossBattle.BarColor nmsColor = BossBattle.BarColor.valueOf((String)color.name());
        return nmsColor == null ? BossBattle.BarColor.WHITE : nmsColor;
    }

    private BossBattle.BarStyle convertStyle(BarStyle style) {
        switch (style) {
            default: {
                return BossBattle.BarStyle.PROGRESS;
            }
            case SEGMENTED_6: {
                return BossBattle.BarStyle.NOTCHED_6;
            }
            case SEGMENTED_10: {
                return BossBattle.BarStyle.NOTCHED_10;
            }
            case SEGMENTED_12: {
                return BossBattle.BarStyle.NOTCHED_12;
            }
            case SEGMENTED_20: 
        }
        return BossBattle.BarStyle.NOTCHED_20;
    }

    private void updateFlags() {
        this.handle.a(this.hasFlag(BarFlag.DARKEN_SKY));
        this.handle.b(this.hasFlag(BarFlag.PLAY_BOSS_MUSIC));
        this.handle.c(this.hasFlag(BarFlag.CREATE_FOG));
    }

    @Override
    public String getTitle() {
        return CraftChatMessage.fromComponent(this.handle.e());
    }

    @Override
    public void setTitle(String title) {
        this.handle.title = CraftChatMessage.fromString(title, true)[0];
        this.handle.sendUpdate(PacketPlayOutBoss.Action.UPDATE_NAME);
    }

    @Override
    public BarColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(BarColor color) {
        this.color = color;
        this.handle.color = this.convertColor(color);
        this.handle.sendUpdate(PacketPlayOutBoss.Action.UPDATE_STYLE);
    }

    @Override
    public BarStyle getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(BarStyle style) {
        this.style = style;
        this.handle.style = this.convertStyle(style);
        this.handle.sendUpdate(PacketPlayOutBoss.Action.UPDATE_STYLE);
    }

    @Override
    public void addFlag(BarFlag flag) {
        this.flags.add(flag);
        this.updateFlags();
    }

    @Override
    public void removeFlag(BarFlag flag) {
        this.flags.remove((Object)flag);
        this.updateFlags();
    }

    @Override
    public boolean hasFlag(BarFlag flag) {
        return this.flags.contains((Object)flag);
    }

    @Override
    public void setProgress(double progress) {
        Preconditions.checkArgument((progress >= 0.0 && progress <= 1.0 ? 1 : 0) != 0, (String)"Progress must be between 0.0 and 1.0 (%s)", (Object)progress);
        this.handle.setProgress((float)progress);
    }

    @Override
    public double getProgress() {
        return this.handle.getProgress();
    }

    @Override
    public void addPlayer(Player player) {
        this.handle.addPlayer(((CraftPlayer)player).getHandle());
    }

    @Override
    public void removePlayer(Player player) {
        this.handle.removePlayer(((CraftPlayer)player).getHandle());
    }

    @Override
    public List<Player> getPlayers() {
        ImmutableList.Builder players = ImmutableList.builder();
        for (EntityPlayer p : this.handle.getPlayers()) {
            players.add((Object)p.getBukkitEntity());
        }
        return players.build();
    }

    @Override
    public void setVisible(boolean visible) {
        this.handle.setVisible(visible);
    }

    @Override
    public boolean isVisible() {
        return this.handle.visible;
    }

    @Override
    public void show() {
        this.handle.setVisible(true);
    }

    @Override
    public void hide() {
        this.handle.setVisible(false);
    }

    @Override
    public void removeAll() {
        for (Player player : this.getPlayers()) {
            this.removePlayer(player);
        }
    }
}

