/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.server.v1_12_R1.Entity;
import net.minecraft.server.v1_12_R1.EntityArrow;
import org.apache.commons.lang.Validate;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.entity.AbstractProjectile;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftLivingEntity;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.projectiles.ProjectileSource;

public class CraftArrow
extends AbstractProjectile
implements Arrow {
    private final Arrow.Spigot spigot = new Arrow.Spigot(){

        @Override
        public double getDamage() {
            return CraftArrow.this.getHandle().k();
        }

        @Override
        public void setDamage(double damage) {
            CraftArrow.this.getHandle().c(damage);
        }
    };

    public CraftArrow(CraftServer server, EntityArrow entity) {
        super(server, (Entity)entity);
    }

    @Override
    public void setKnockbackStrength(int knockbackStrength) {
        Validate.isTrue((knockbackStrength >= 0 ? 1 : 0) != 0, (String)"Knockback cannot be negative");
        this.getHandle().setKnockbackStrength(knockbackStrength);
    }

    @Override
    public int getKnockbackStrength() {
        return this.getHandle().knockbackStrength;
    }

    @Override
    public boolean isCritical() {
        return this.getHandle().isCritical();
    }

    @Override
    public void setCritical(boolean critical) {
        this.getHandle().setCritical(critical);
    }

    @Override
    public ProjectileSource getShooter() {
        return this.getHandle().projectileSource;
    }

    @Override
    public void setShooter(ProjectileSource shooter) {
        this.getHandle().shooter = shooter instanceof LivingEntity ? ((CraftLivingEntity)shooter).getHandle() : null;
        this.getHandle().projectileSource = shooter;
    }

    @Override
    public boolean isInBlock() {
        return this.getHandle().inGround;
    }

    @Override
    public Block getAttachedBlock() {
        if (!this.isInBlock()) {
            return null;
        }
        EntityArrow handle = this.getHandle();
        return this.getWorld().getBlockAt(handle.h, handle.at, handle.au);
    }

    @Override
    public Arrow.PickupStatus getPickupStatus() {
        return Arrow.PickupStatus.values()[this.getHandle().fromPlayer.ordinal()];
    }

    @Override
    public void setPickupStatus(Arrow.PickupStatus status) {
        Preconditions.checkNotNull((Object)((Object)status), (Object)"status");
        this.getHandle().fromPlayer = EntityArrow.PickupStatus.a((int)status.ordinal());
    }

    public EntityArrow getHandle() {
        return (EntityArrow)this.entity;
    }

    @Override
    public String toString() {
        return "CraftArrow";
    }

    @Override
    public EntityType getType() {
        return EntityType.ARROW;
    }

    @Override
    public Arrow.Spigot spigot() {
        return this.spigot;
    }
}

