/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.entity;

import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.Entity;
import net.minecraft.server.v1_12_R1.EntityFishingHook;
import net.minecraft.server.v1_12_R1.EntityHuman;
import net.minecraft.server.v1_12_R1.MathHelper;
import org.apache.commons.lang.Validate;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.entity.AbstractProjectile;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftHumanEntity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fish;
import org.bukkit.projectiles.ProjectileSource;

public class CraftFish
extends AbstractProjectile
implements Fish {
    private double biteChance = -1.0;

    public CraftFish(CraftServer server, EntityFishingHook entity) {
        super(server, (Entity)entity);
    }

    @Override
    public ProjectileSource getShooter() {
        if (this.getHandle().owner != null) {
            return this.getHandle().owner.getBukkitEntity();
        }
        return null;
    }

    @Override
    public void setShooter(ProjectileSource shooter) {
        if (shooter instanceof CraftHumanEntity) {
            this.getHandle().owner = (EntityHuman)((CraftHumanEntity)shooter).entity;
        }
    }

    public EntityFishingHook getHandle() {
        return (EntityFishingHook)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFish";
    }

    @Override
    public EntityType getType() {
        return EntityType.FISHING_HOOK;
    }

    @Override
    public double getBiteChance() {
        EntityFishingHook hook = this.getHandle();
        if (this.biteChance == -1.0) {
            if (hook.world.isRainingAt(new BlockPosition(MathHelper.floor((double)hook.locX), MathHelper.floor((double)hook.locY) + 1, MathHelper.floor((double)hook.locZ)))) {
                return 0.0033333333333333335;
            }
            return 0.002;
        }
        return this.biteChance;
    }

    @Override
    public void setBiteChance(double chance) {
        Validate.isTrue((chance >= 0.0 && chance <= 1.0 ? 1 : 0) != 0, (String)"The bite chance must be between 0 and 1.");
        this.biteChance = chance;
    }
}

