/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.server.v1_12_R1.EntityAgeable;
import net.minecraft.server.v1_12_R1.EntityVillager;
import net.minecraft.server.v1_12_R1.IInventory;
import net.minecraft.server.v1_12_R1.IMerchant;
import org.apache.commons.lang.Validate;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftAgeable;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMerchant;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.MerchantRecipe;

public class CraftVillager
extends CraftAgeable
implements Villager,
InventoryHolder {
    private static final Map<Villager.Career, Integer> careerIDMap = new HashMap<Villager.Career, Integer>();
    private CraftMerchant merchant;

    static {
        int id = 0;
        Villager.Profession[] professionArray = Villager.Profession.values();
        int n = professionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Villager.Profession prof = professionArray[n2];
            List<Villager.Career> careers = prof.getCareers();
            if (!careers.isEmpty()) {
                for (Villager.Career c : careers) {
                    careerIDMap.put(c, ++id);
                }
            }
            Validate.isTrue((id == careers.size() ? 1 : 0) != 0, (String)"Career id registration mismatch");
            id = 0;
            ++n2;
        }
    }

    public CraftVillager(CraftServer server, EntityVillager entity) {
        super(server, (EntityAgeable)entity);
    }

    public EntityVillager getHandle() {
        return (EntityVillager)this.entity;
    }

    @Override
    public String toString() {
        return "CraftVillager";
    }

    @Override
    public EntityType getType() {
        return EntityType.VILLAGER;
    }

    @Override
    public Villager.Profession getProfession() {
        return Villager.Profession.values()[this.getHandle().getProfession() + 1];
    }

    @Override
    public void setProfession(Villager.Profession profession) {
        Validate.notNull((Object)((Object)profession));
        Validate.isTrue((!profession.isZombie() ? 1 : 0) != 0, (String)"Profession is reserved for Zombies: ", (Object)((Object)profession));
        this.getHandle().setProfession(profession.ordinal() - 1);
    }

    @Override
    public Villager.Career getCareer() {
        return CraftVillager.getCareer(this.getProfession(), this.getHandle().bK);
    }

    @Override
    public void setCareer(Villager.Career career) {
        this.setCareer(career, true);
    }

    @Override
    public void setCareer(Villager.Career career, boolean resetTrades) {
        if (career == null) {
            this.getHandle().bK = 0;
        } else {
            Validate.isTrue((career.getProfession() == this.getProfession() ? 1 : 0) != 0, (String)("Career assignment mismatch. Found (" + (Object)((Object)this.getProfession()) + ") Required (" + (Object)((Object)career.getProfession()) + ")"));
            this.getHandle().bK = CraftVillager.getCareerID(career);
        }
        if (resetTrades) {
            this.getHandle().trades = null;
            this.getHandle().dx();
        }
    }

    @Override
    public Inventory getInventory() {
        return new CraftInventory((IInventory)this.getHandle().inventory);
    }

    private CraftMerchant getMerchant() {
        return this.merchant == null ? (this.merchant = new CraftMerchant((IMerchant)this.getHandle())) : this.merchant;
    }

    @Override
    public List<MerchantRecipe> getRecipes() {
        return this.getMerchant().getRecipes();
    }

    @Override
    public void setRecipes(List<MerchantRecipe> recipes) {
        this.getMerchant().setRecipes(recipes);
    }

    @Override
    public MerchantRecipe getRecipe(int i) {
        return this.getMerchant().getRecipe(i);
    }

    @Override
    public void setRecipe(int i, MerchantRecipe merchantRecipe) {
        this.getMerchant().setRecipe(i, merchantRecipe);
    }

    @Override
    public int getRecipeCount() {
        return this.getMerchant().getRecipeCount();
    }

    @Override
    public boolean isTrading() {
        return this.getTrader() != null;
    }

    @Override
    public HumanEntity getTrader() {
        return this.getMerchant().getTrader();
    }

    @Override
    public int getRiches() {
        return this.getHandle().riches;
    }

    @Override
    public void setRiches(int riches) {
        this.getHandle().riches = riches;
    }

    @Nullable
    private static Villager.Career getCareer(Villager.Profession profession, int id) {
        Validate.isTrue((id > 0 ? 1 : 0) != 0, (String)"Career id must be greater than 0");
        List<Villager.Career> careers = profession.getCareers();
        for (Villager.Career c : careers) {
            if (!careerIDMap.containsKey((Object)c) || careerIDMap.get((Object)c) != id) continue;
            return c;
        }
        return null;
    }

    private static int getCareerID(Villager.Career career) {
        return careerIDMap.getOrDefault((Object)career, 0);
    }
}

