/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.map;

import java.util.UUID;
import net.minecraft.server.v1_12_R1.MapIcon;
import net.minecraft.server.v1_12_R1.WorldMap;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_12_R1.map.CraftMapView;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapCursorCollection;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public class CraftMapRenderer
extends MapRenderer {
    private final WorldMap worldMap;

    public CraftMapRenderer(CraftMapView mapView, WorldMap worldMap) {
        super(false);
        this.worldMap = worldMap;
    }

    @Override
    public void render(MapView map, MapCanvas canvas, Player player) {
        int x = 0;
        while (x < 128) {
            int y = 0;
            while (y < 128) {
                canvas.setPixel(x, y, this.worldMap.colors[y * 128 + x]);
                ++y;
            }
            ++x;
        }
        MapCursorCollection cursors = canvas.getCursors();
        while (cursors.size() > 0) {
            cursors.removeCursor(cursors.getCursor(0));
        }
        for (UUID key : this.worldMap.decorations.keySet()) {
            Player other = Bukkit.getPlayer(key);
            if (other != null && !player.canSee(other)) continue;
            MapIcon decoration = (MapIcon)this.worldMap.decorations.get(key);
            cursors.addCursor(decoration.getX(), decoration.getY(), (byte)(decoration.getRotation() & 0xF), decoration.getType());
        }
    }
}

