/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.minecraft.server.v1_12_R1.WorldMap;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_12_R1.map.CraftMapCanvas;
import org.bukkit.craftbukkit.v1_12_R1.map.CraftMapRenderer;
import org.bukkit.craftbukkit.v1_12_R1.map.RenderData;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public final class CraftMapView
implements MapView {
    private final Map<CraftPlayer, RenderData> renderCache = new HashMap<CraftPlayer, RenderData>();
    private final List<MapRenderer> renderers = new ArrayList<MapRenderer>();
    private final Map<MapRenderer, Map<CraftPlayer, CraftMapCanvas>> canvases = new HashMap<MapRenderer, Map<CraftPlayer, CraftMapCanvas>>();
    protected final WorldMap worldMap;

    public CraftMapView(WorldMap worldMap) {
        this.worldMap = worldMap;
        this.addRenderer(new CraftMapRenderer(this, worldMap));
    }

    @Override
    public short getId() {
        String text = this.worldMap.id;
        if (text.startsWith("map_")) {
            try {
                return Short.parseShort(text.substring("map_".length()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException("Map has non-numeric ID");
            }
        }
        throw new IllegalStateException("Map has invalid ID");
    }

    @Override
    public boolean isVirtual() {
        return this.renderers.size() > 0 && !(this.renderers.get(0) instanceof CraftMapRenderer);
    }

    @Override
    public MapView.Scale getScale() {
        return MapView.Scale.valueOf(this.worldMap.scale);
    }

    @Override
    public void setScale(MapView.Scale scale) {
        this.worldMap.scale = scale.getValue();
    }

    @Override
    public World getWorld() {
        byte dimension = this.worldMap.map;
        for (World world : Bukkit.getServer().getWorlds()) {
            if (((CraftWorld)world).getHandle().dimension != dimension) continue;
            return world;
        }
        return null;
    }

    @Override
    public void setWorld(World world) {
        this.worldMap.map = (byte)((CraftWorld)world).getHandle().dimension;
    }

    @Override
    public int getCenterX() {
        return this.worldMap.centerX;
    }

    @Override
    public int getCenterZ() {
        return this.worldMap.centerZ;
    }

    @Override
    public void setCenterX(int x) {
        this.worldMap.centerX = x;
    }

    @Override
    public void setCenterZ(int z) {
        this.worldMap.centerZ = z;
    }

    @Override
    public List<MapRenderer> getRenderers() {
        return new ArrayList<MapRenderer>(this.renderers);
    }

    @Override
    public void addRenderer(MapRenderer renderer) {
        if (!this.renderers.contains(renderer)) {
            this.renderers.add(renderer);
            this.canvases.put(renderer, new HashMap());
            renderer.initialize(this);
        }
    }

    @Override
    public boolean removeRenderer(MapRenderer renderer) {
        if (this.renderers.contains(renderer)) {
            this.renderers.remove(renderer);
            for (Map.Entry<CraftPlayer, CraftMapCanvas> entry : this.canvases.get(renderer).entrySet()) {
                int x = 0;
                while (x < 128) {
                    int y = 0;
                    while (y < 128) {
                        entry.getValue().setPixel(x, y, (byte)-1);
                        ++y;
                    }
                    ++x;
                }
            }
            this.canvases.remove(renderer);
            return true;
        }
        return false;
    }

    private boolean isContextual() {
        for (MapRenderer renderer : this.renderers) {
            if (!renderer.isContextual()) continue;
            return true;
        }
        return false;
    }

    public RenderData render(CraftPlayer player) {
        boolean context = this.isContextual();
        RenderData render = this.renderCache.get(context ? player : null);
        if (render == null) {
            render = new RenderData();
            this.renderCache.put(context ? player : null, render);
        }
        if (context && this.renderCache.containsKey(null)) {
            this.renderCache.remove(null);
        }
        Arrays.fill(render.buffer, (byte)0);
        render.cursors.clear();
        Iterator<MapRenderer> iterator = this.renderers.iterator();
        while (iterator.hasNext()) {
            MapRenderer renderer;
            CraftMapCanvas canvas = this.canvases.get(renderer).get((renderer = iterator.next()).isContextual() ? player : null);
            if (canvas == null) {
                canvas = new CraftMapCanvas(this);
                this.canvases.get(renderer).put(renderer.isContextual() ? player : null, canvas);
            }
            canvas.setBase(render.buffer);
            try {
                renderer.render(this, canvas, player);
            }
            catch (Throwable ex) {
                Bukkit.getLogger().log(Level.SEVERE, "Could not render map using renderer " + renderer.getClass().getName(), ex);
            }
            byte[] buf = canvas.getBuffer();
            int i = 0;
            while (i < buf.length) {
                byte color = buf[i];
                if (color >= 0 || color <= -49) {
                    render.buffer[i] = color;
                }
                ++i;
            }
            i = 0;
            while (i < canvas.getCursors().size()) {
                render.cursors.add(canvas.getCursors().getCursor(i));
                ++i;
            }
        }
        return render;
    }

    @Override
    public boolean isUnlimitedTracking() {
        return this.worldMap.unlimitedTracking;
    }

    @Override
    public void setUnlimitedTracking(boolean unlimited) {
        this.worldMap.unlimitedTracking = unlimited;
    }
}

