/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.projectiles;

import java.util.Random;
import net.minecraft.server.v1_12_R1.BlockDispenser;
import net.minecraft.server.v1_12_R1.Entity;
import net.minecraft.server.v1_12_R1.EntityArrow;
import net.minecraft.server.v1_12_R1.EntityEgg;
import net.minecraft.server.v1_12_R1.EntityEnderPearl;
import net.minecraft.server.v1_12_R1.EntityFireball;
import net.minecraft.server.v1_12_R1.EntityLargeFireball;
import net.minecraft.server.v1_12_R1.EntityPotion;
import net.minecraft.server.v1_12_R1.EntityProjectile;
import net.minecraft.server.v1_12_R1.EntitySmallFireball;
import net.minecraft.server.v1_12_R1.EntitySnowball;
import net.minecraft.server.v1_12_R1.EntitySpectralArrow;
import net.minecraft.server.v1_12_R1.EntityThrownExpBottle;
import net.minecraft.server.v1_12_R1.EntityTippedArrow;
import net.minecraft.server.v1_12_R1.EntityWitherSkull;
import net.minecraft.server.v1_12_R1.EnumDirection;
import net.minecraft.server.v1_12_R1.IBlockState;
import net.minecraft.server.v1_12_R1.IPosition;
import net.minecraft.server.v1_12_R1.IProjectile;
import net.minecraft.server.v1_12_R1.ISourceBlock;
import net.minecraft.server.v1_12_R1.MathHelper;
import net.minecraft.server.v1_12_R1.SourceBlock;
import net.minecraft.server.v1_12_R1.TileEntityDispenser;
import net.minecraft.server.v1_12_R1.World;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_12_R1.potion.CraftPotionUtil;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.WitherSkull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.util.Vector;

public class CraftBlockProjectileSource
implements BlockProjectileSource {
    private final TileEntityDispenser dispenserBlock;

    public CraftBlockProjectileSource(TileEntityDispenser dispenserBlock) {
        this.dispenserBlock = dispenserBlock;
    }

    @Override
    public Block getBlock() {
        return this.dispenserBlock.getWorld().getWorld().getBlockAt(this.dispenserBlock.getPosition().getX(), this.dispenserBlock.getPosition().getY(), this.dispenserBlock.getPosition().getZ());
    }

    @Override
    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile) {
        return this.launchProjectile(projectile, null);
    }

    @Override
    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity) {
        Validate.isTrue((this.getBlock().getType() == Material.DISPENSER ? 1 : 0) != 0, (String)"Block is no longer dispenser");
        SourceBlock isourceblock = new SourceBlock(this.dispenserBlock.getWorld(), this.dispenserBlock.getPosition());
        IPosition iposition = BlockDispenser.a((ISourceBlock)isourceblock);
        EnumDirection enumdirection = (EnumDirection)isourceblock.e().get((IBlockState)BlockDispenser.FACING);
        World world = this.dispenserBlock.getWorld();
        Object launch = null;
        if (Snowball.class.isAssignableFrom(projectile)) {
            launch = new EntitySnowball(world, iposition.getX(), iposition.getY(), iposition.getZ());
        } else if (Egg.class.isAssignableFrom(projectile)) {
            launch = new EntityEgg(world, iposition.getX(), iposition.getY(), iposition.getZ());
        } else if (EnderPearl.class.isAssignableFrom(projectile)) {
            launch = new EntityEnderPearl(world, null);
            launch.setPosition(iposition.getX(), iposition.getY(), iposition.getZ());
        } else if (ThrownExpBottle.class.isAssignableFrom(projectile)) {
            launch = new EntityThrownExpBottle(world, iposition.getX(), iposition.getY(), iposition.getZ());
        } else if (ThrownPotion.class.isAssignableFrom(projectile)) {
            launch = LingeringPotion.class.isAssignableFrom(projectile) ? new EntityPotion(world, iposition.getX(), iposition.getY(), iposition.getZ(), CraftItemStack.asNMSCopy(new ItemStack(Material.LINGERING_POTION, 1))) : new EntityPotion(world, iposition.getX(), iposition.getY(), iposition.getZ(), CraftItemStack.asNMSCopy(new ItemStack(Material.SPLASH_POTION, 1)));
        } else if (Arrow.class.isAssignableFrom(projectile)) {
            if (TippedArrow.class.isAssignableFrom(projectile)) {
                launch = new EntityTippedArrow(world, iposition.getX(), iposition.getY(), iposition.getZ());
                ((EntityTippedArrow)launch).setType(CraftPotionUtil.fromBukkit(new PotionData(PotionType.WATER, false, false)));
            } else {
                launch = SpectralArrow.class.isAssignableFrom(projectile) ? new EntitySpectralArrow(world, iposition.getX(), iposition.getY(), iposition.getZ()) : new EntityTippedArrow(world, iposition.getX(), iposition.getY(), iposition.getZ());
            }
            ((EntityArrow)launch).fromPlayer = EntityArrow.PickupStatus.ALLOWED;
            ((EntityArrow)launch).projectileSource = this;
        } else if (Fireball.class.isAssignableFrom(projectile)) {
            double d0 = iposition.getX() + (double)((float)enumdirection.getAdjacentX() * 0.3f);
            double d1 = iposition.getY() + (double)((float)enumdirection.getAdjacentY() * 0.3f);
            double d2 = iposition.getZ() + (double)((float)enumdirection.getAdjacentZ() * 0.3f);
            Random random = world.random;
            double d3 = random.nextGaussian() * 0.05 + (double)enumdirection.getAdjacentX();
            double d4 = random.nextGaussian() * 0.05 + (double)enumdirection.getAdjacentY();
            double d5 = random.nextGaussian() * 0.05 + (double)enumdirection.getAdjacentZ();
            if (SmallFireball.class.isAssignableFrom(projectile)) {
                launch = new EntitySmallFireball(world, null, d0, d1, d2);
            } else if (WitherSkull.class.isAssignableFrom(projectile)) {
                launch = new EntityWitherSkull(world);
                launch.setPosition(d0, d1, d2);
                double d6 = MathHelper.sqrt((double)(d3 * d3 + d4 * d4 + d5 * d5));
                ((EntityFireball)launch).dirX = d3 / d6 * 0.1;
                ((EntityFireball)launch).dirY = d4 / d6 * 0.1;
                ((EntityFireball)launch).dirZ = d5 / d6 * 0.1;
            } else {
                launch = new EntityLargeFireball(world);
                launch.setPosition(d0, d1, d2);
                double d6 = MathHelper.sqrt((double)(d3 * d3 + d4 * d4 + d5 * d5));
                ((EntityFireball)launch).dirX = d3 / d6 * 0.1;
                ((EntityFireball)launch).dirY = d4 / d6 * 0.1;
                ((EntityFireball)launch).dirZ = d5 / d6 * 0.1;
            }
            ((EntityFireball)launch).projectileSource = this;
        }
        Validate.notNull((Object)launch, (String)"Projectile not supported");
        if (launch instanceof IProjectile) {
            if (launch instanceof EntityProjectile) {
                ((EntityProjectile)launch).projectileSource = this;
            }
            float a = 6.0f;
            float b = 1.1f;
            if (launch instanceof EntityPotion || launch instanceof ThrownExpBottle) {
                a *= 0.5f;
                b *= 1.25f;
            }
            ((IProjectile)launch).shoot((double)enumdirection.getAdjacentX(), (double)((float)enumdirection.getAdjacentY() + 0.1f), (double)enumdirection.getAdjacentZ(), b, a);
        }
        if (velocity != null) {
            ((Projectile)((Object)launch.getBukkitEntity())).setVelocity(velocity);
        }
        world.addEntity((Entity)launch);
        return (T)((Projectile)((Object)launch.getBukkitEntity()));
    }
}

