/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.scoreboard;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.server.v1_12_R1.ScoreboardTeam;
import net.minecraft.server.v1_12_R1.ScoreboardTeamBase;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_12_R1.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_12_R1.scoreboard.CraftScoreboardComponent;
import org.bukkit.craftbukkit.v1_12_R1.util.CraftChatMessage;
import org.bukkit.scoreboard.NameTagVisibility;
import org.bukkit.scoreboard.Team;

final class CraftTeam
extends CraftScoreboardComponent
implements Team {
    private final ScoreboardTeam team;

    CraftTeam(CraftScoreboard scoreboard, ScoreboardTeam team) {
        super(scoreboard);
        this.team = team;
    }

    @Override
    public String getName() throws IllegalStateException {
        this.checkState();
        return this.team.getName();
    }

    @Override
    public String getDisplayName() throws IllegalStateException {
        this.checkState();
        return this.team.getDisplayName();
    }

    @Override
    public void setDisplayName(String displayName) throws IllegalStateException {
        Validate.notNull((Object)displayName, (String)"Display name cannot be null");
        Validate.isTrue((displayName.length() <= 32 ? 1 : 0) != 0, (String)("Display name '" + displayName + "' is longer than the limit of 32 characters"));
        this.checkState();
        this.team.setDisplayName(displayName);
    }

    @Override
    public String getPrefix() throws IllegalStateException {
        this.checkState();
        return this.team.getPrefix();
    }

    @Override
    public void setPrefix(String prefix) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)prefix, (String)"Prefix cannot be null");
        Validate.isTrue((prefix.length() <= 16 ? 1 : 0) != 0, (String)("Prefix '" + prefix + "' is longer than the limit of 16 characters"));
        this.checkState();
        this.team.setPrefix(prefix);
    }

    @Override
    public String getSuffix() throws IllegalStateException {
        this.checkState();
        return this.team.getSuffix();
    }

    @Override
    public void setSuffix(String suffix) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)suffix, (String)"Suffix cannot be null");
        Validate.isTrue((suffix.length() <= 16 ? 1 : 0) != 0, (String)("Suffix '" + suffix + "' is longer than the limit of 16 characters"));
        this.checkState();
        this.team.setSuffix(suffix);
    }

    @Override
    public ChatColor getColor() throws IllegalStateException {
        this.checkState();
        return CraftChatMessage.getColor(this.team.getColor());
    }

    @Override
    public void setColor(ChatColor color) {
        Validate.notNull((Object)((Object)color), (String)"Color cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        this.team.setColor(CraftChatMessage.getColor(color));
        scoreboard.board.handleTeamChanged(this.team);
    }

    @Override
    public boolean allowFriendlyFire() throws IllegalStateException {
        this.checkState();
        return this.team.allowFriendlyFire();
    }

    @Override
    public void setAllowFriendlyFire(boolean enabled) throws IllegalStateException {
        this.checkState();
        this.team.setAllowFriendlyFire(enabled);
    }

    @Override
    public boolean canSeeFriendlyInvisibles() throws IllegalStateException {
        this.checkState();
        return this.team.canSeeFriendlyInvisibles();
    }

    @Override
    public void setCanSeeFriendlyInvisibles(boolean enabled) throws IllegalStateException {
        this.checkState();
        this.team.setCanSeeFriendlyInvisibles(enabled);
    }

    @Override
    public NameTagVisibility getNameTagVisibility() throws IllegalArgumentException {
        this.checkState();
        return CraftTeam.notchToBukkit(this.team.getNameTagVisibility());
    }

    @Override
    public void setNameTagVisibility(NameTagVisibility visibility) throws IllegalArgumentException {
        this.checkState();
        this.team.setNameTagVisibility(CraftTeam.bukkitToNotch(visibility));
    }

    @Override
    public Set<OfflinePlayer> getPlayers() throws IllegalStateException {
        this.checkState();
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (String playerName : this.team.getPlayerNameSet()) {
            players.add((Object)Bukkit.getOfflinePlayer(playerName));
        }
        return players.build();
    }

    @Override
    public Set<String> getEntries() throws IllegalStateException {
        this.checkState();
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (String playerName : this.team.getPlayerNameSet()) {
            entries.add((Object)playerName);
        }
        return entries.build();
    }

    @Override
    public int getSize() throws IllegalStateException {
        this.checkState();
        return this.team.getPlayerNameSet().size();
    }

    @Override
    public void addPlayer(OfflinePlayer player) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null");
        this.addEntry(player.getName());
    }

    @Override
    public void addEntry(String entry) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.addPlayerToTeam(entry, this.team.getName());
    }

    @Override
    public boolean removePlayer(OfflinePlayer player) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null");
        return this.removeEntry(player.getName());
    }

    @Override
    public boolean removeEntry(String entry) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        if (!this.team.getPlayerNameSet().contains(entry)) {
            return false;
        }
        scoreboard.board.removePlayerFromTeam(entry, this.team);
        return true;
    }

    @Override
    public boolean hasPlayer(OfflinePlayer player) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null");
        return this.hasEntry(player.getName());
    }

    @Override
    public boolean hasEntry(String entry) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull((Object)"Entry cannot be null");
        this.checkState();
        return this.team.getPlayerNameSet().contains(entry);
    }

    @Override
    public void unregister() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.removeTeam(this.team);
    }

    @Override
    public Team.OptionStatus getOption(Team.Option option) throws IllegalStateException {
        this.checkState();
        switch (option) {
            case NAME_TAG_VISIBILITY: {
                return Team.OptionStatus.values()[this.team.getNameTagVisibility().ordinal()];
            }
            case DEATH_MESSAGE_VISIBILITY: {
                return Team.OptionStatus.values()[this.team.getDeathMessageVisibility().ordinal()];
            }
            case COLLISION_RULE: {
                return Team.OptionStatus.values()[this.team.getCollisionRule().ordinal()];
            }
        }
        throw new IllegalArgumentException("Unrecognised option " + (Object)((Object)option));
    }

    @Override
    public void setOption(Team.Option option, Team.OptionStatus status) throws IllegalStateException {
        this.checkState();
        switch (option) {
            case NAME_TAG_VISIBILITY: {
                this.team.setNameTagVisibility(ScoreboardTeamBase.EnumNameTagVisibility.values()[status.ordinal()]);
                break;
            }
            case DEATH_MESSAGE_VISIBILITY: {
                this.team.setDeathMessageVisibility(ScoreboardTeamBase.EnumNameTagVisibility.values()[status.ordinal()]);
                break;
            }
            case COLLISION_RULE: {
                this.team.setCollisionRule(ScoreboardTeamBase.EnumTeamPush.values()[status.ordinal()]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognised option " + (Object)((Object)option));
            }
        }
    }

    public static ScoreboardTeamBase.EnumNameTagVisibility bukkitToNotch(NameTagVisibility visibility) {
        switch (visibility) {
            case ALWAYS: {
                return ScoreboardTeamBase.EnumNameTagVisibility.ALWAYS;
            }
            case NEVER: {
                return ScoreboardTeamBase.EnumNameTagVisibility.NEVER;
            }
            case HIDE_FOR_OTHER_TEAMS: {
                return ScoreboardTeamBase.EnumNameTagVisibility.HIDE_FOR_OTHER_TEAMS;
            }
            case HIDE_FOR_OWN_TEAM: {
                return ScoreboardTeamBase.EnumNameTagVisibility.HIDE_FOR_OWN_TEAM;
            }
        }
        throw new IllegalArgumentException("Unknown visibility level " + (Object)((Object)visibility));
    }

    public static NameTagVisibility notchToBukkit(ScoreboardTeamBase.EnumNameTagVisibility visibility) {
        switch (visibility) {
            case ALWAYS: {
                return NameTagVisibility.ALWAYS;
            }
            case NEVER: {
                return NameTagVisibility.NEVER;
            }
            case HIDE_FOR_OTHER_TEAMS: {
                return NameTagVisibility.HIDE_FOR_OTHER_TEAMS;
            }
            case HIDE_FOR_OWN_TEAM: {
                return NameTagVisibility.HIDE_FOR_OWN_TEAM;
            }
        }
        throw new IllegalArgumentException("Unknown visibility level " + visibility);
    }

    @Override
    CraftScoreboard checkState() throws IllegalStateException {
        if (((CraftScoreboard)this.getScoreboard()).board.getTeam(this.team.getName()) == null) {
            throw new IllegalStateException("Unregistered scoreboard component");
        }
        return this.getScoreboard();
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (this.team != null ? this.team.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftTeam other = (CraftTeam)obj;
        return this.team == other.team || this.team != null && this.team.equals(other.team);
    }
}

