/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.util;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.v1_12_R1.Advancement;
import net.minecraft.server.v1_12_R1.AdvancementDataWorld;
import net.minecraft.server.v1_12_R1.Blocks;
import net.minecraft.server.v1_12_R1.ChatDeserializer;
import net.minecraft.server.v1_12_R1.Item;
import net.minecraft.server.v1_12_R1.MinecraftKey;
import net.minecraft.server.v1_12_R1.MinecraftServer;
import net.minecraft.server.v1_12_R1.MojangsonParseException;
import net.minecraft.server.v1_12_R1.MojangsonParser;
import net.minecraft.server.v1_12_R1.StatisticList;
import org.bukkit.Achievement;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Statistic;
import org.bukkit.UnsafeValues;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_12_R1.CraftStatistic;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_12_R1.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.StringUtil;

public final class CraftMagicNumbers
implements UnsafeValues {
    public static final UnsafeValues INSTANCE = new CraftMagicNumbers();

    private CraftMagicNumbers() {
    }

    public static net.minecraft.server.v1_12_R1.Block getBlock(Block block) {
        return CraftMagicNumbers.getBlock(block.getType());
    }

    @Deprecated
    public static net.minecraft.server.v1_12_R1.Block getBlock(int id) {
        return CraftMagicNumbers.getBlock(Material.getMaterial(id));
    }

    @Deprecated
    public static int getId(net.minecraft.server.v1_12_R1.Block block) {
        return net.minecraft.server.v1_12_R1.Block.getId((net.minecraft.server.v1_12_R1.Block)block);
    }

    public static Material getMaterial(net.minecraft.server.v1_12_R1.Block block) {
        return Material.getMaterial(net.minecraft.server.v1_12_R1.Block.getId((net.minecraft.server.v1_12_R1.Block)block));
    }

    public static Item getItem(Material material) {
        Item item = Item.getById((int)material.getId());
        return item;
    }

    @Deprecated
    public static Item getItem(int id) {
        return Item.getById((int)id);
    }

    @Deprecated
    public static int getId(Item item) {
        return Item.getId((Item)item);
    }

    public static Material getMaterial(Item item) {
        Material material = Material.getMaterial(Item.getId((Item)item));
        if (material == null) {
            return Material.AIR;
        }
        return material;
    }

    public static net.minecraft.server.v1_12_R1.Block getBlock(Material material) {
        if (material == null) {
            return null;
        }
        net.minecraft.server.v1_12_R1.Block block = net.minecraft.server.v1_12_R1.Block.getById((int)material.getId());
        if (block == null) {
            return Blocks.AIR;
        }
        return block;
    }

    @Override
    public Material getMaterialFromInternalName(String name) {
        return CraftMagicNumbers.getMaterial((Item)Item.REGISTRY.get((Object)new MinecraftKey(name)));
    }

    @Override
    public List<String> tabCompleteInternalMaterialName(String token, List<String> completions) {
        ArrayList results = Lists.newArrayList();
        for (MinecraftKey key : Item.REGISTRY.keySet()) {
            results.add(key.toString());
        }
        return StringUtil.copyPartialMatches(token, results, completions);
    }

    @Override
    public ItemStack modifyItemStack(ItemStack stack, String arguments) {
        net.minecraft.server.v1_12_R1.ItemStack nmsStack = CraftItemStack.asNMSCopy(stack);
        try {
            nmsStack.setTag(MojangsonParser.parse((String)arguments));
        }
        catch (MojangsonParseException ex) {
            Logger.getLogger(CraftMagicNumbers.class.getName()).log(Level.SEVERE, null, ex);
        }
        stack.setItemMeta(CraftItemStack.getItemMeta(nmsStack));
        return stack;
    }

    @Override
    public Statistic getStatisticFromInternalName(String name) {
        return CraftStatistic.getBukkitStatisticByName(name);
    }

    @Override
    public Achievement getAchievementFromInternalName(String name) {
        throw new UnsupportedOperationException("Not supported in this Minecraft version.");
    }

    @Override
    public List<String> tabCompleteInternalStatisticOrAchievementName(String token, List<String> completions) {
        ArrayList<String> matches = new ArrayList<String>();
        Iterator iterator = StatisticList.stats.iterator();
        while (iterator.hasNext()) {
            String statistic = ((net.minecraft.server.v1_12_R1.Statistic)iterator.next()).name;
            if (!statistic.startsWith(token)) continue;
            matches.add(statistic);
        }
        return matches;
    }

    @Override
    public Advancement loadAdvancement(NamespacedKey key, String advancement) {
        if (Bukkit.getAdvancement(key) != null) {
            throw new IllegalArgumentException("Advancement " + key + " already exists.");
        }
        Advancement.SerializedAdvancement nms = (Advancement.SerializedAdvancement)ChatDeserializer.a((Gson)AdvancementDataWorld.DESERIALIZER, (String)advancement, Advancement.SerializedAdvancement.class);
        if (nms != null) {
            AdvancementDataWorld.REGISTRY.a((Map)Maps.newHashMap(Collections.singletonMap(CraftNamespacedKey.toMinecraft(key), nms)));
            Advancement bukkit = Bukkit.getAdvancement(key);
            if (bukkit != null) {
                File file = new File(MinecraftServer.getServer().getAdvancementData().folder, String.valueOf(key.getNamespace()) + File.separator + key.getKey() + ".json");
                file.getParentFile().mkdirs();
                try {
                    Files.write((CharSequence)advancement, (File)file, (Charset)Charsets.UTF_8);
                }
                catch (IOException ex) {
                    Bukkit.getLogger().log(Level.SEVERE, "Error saving advancement " + key, ex);
                }
                MinecraftServer.getServer().getPlayerList().reload();
                return bukkit;
            }
        }
        return null;
    }

    @Override
    public boolean removeAdvancement(NamespacedKey key) {
        File file = new File(MinecraftServer.getServer().getAdvancementData().folder, String.valueOf(key.getNamespace()) + File.separator + key.getKey() + ".json");
        return file.delete();
    }

    public static class NBT {
        public static final int TAG_END = 0;
        public static final int TAG_BYTE = 1;
        public static final int TAG_SHORT = 2;
        public static final int TAG_INT = 3;
        public static final int TAG_LONG = 4;
        public static final int TAG_FLOAT = 5;
        public static final int TAG_DOUBLE = 6;
        public static final int TAG_BYTE_ARRAY = 7;
        public static final int TAG_STRING = 8;
        public static final int TAG_LIST = 9;
        public static final int TAG_COMPOUND = 10;
        public static final int TAG_INT_ARRAY = 11;
        public static final int TAG_ANY_NUMBER = 99;
    }
}

