/*
 * Decompiled with CFR 0.152.
 */
package catserver.server;

import catserver.server.CatServerConfig;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLLog;

public class CatServer {
    private static final String version = "2.0.0";
    private static final String native_version = "v1_12_R1";
    private static CatServerConfig config = new CatServerConfig("catserver.yml");

    public static String getVersion() {
        return version;
    }

    public static String getNativeVersion() {
        return native_version;
    }

    public static boolean asyncCatch(String reason) {
        if (Thread.currentThread() != MinecraftServer.getServerInst().primaryThread) {
            FMLLog.getLogger().debug("Try to asynchronously " + reason + ", caught!", (Throwable)new RuntimeException());
            return true;
        }
        return false;
    }

    public static void runWatchdogForceExitTask() {
        MinecraftServer.getServerInst().primaryThread.suspend();
        new Timer("WatchdogForceExitTask").schedule(new TimerTask(){

            @Override
            public void run() {
                Runtime.getRuntime().exit(0);
            }
        }, 300000L);
    }

    public static boolean isSendDataSerializers(Map<String, String> modList) {
        String forgeVersion = modList.get("forge");
        if (forgeVersion != null) {
            try {
                if (Integer.valueOf(forgeVersion.split("\\.")[3]) < 2826) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public static CatServerConfig getConfig() {
        return config;
    }

    public static void postPrimaryThread(Runnable runnable) {
        MinecraftServer.getServerInst().a(runnable);
    }
}

