/*
 * Decompiled with CFR 0.152.
 */
package catserver.server.command.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.SimplePluginManager;

public class CommandPlugin
extends Command {
    public CommandPlugin(String name) {
        super(name);
        this.description = "Load or unload plugin";
        this.usageMessage = "/plugin <load|unload> <name>";
        this.setPermission("catserver.command.plugin");
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage((Object)((Object)ChatColor.GOLD) + "Usage: " + this.usageMessage);
            return false;
        }
        String action = args[0].toLowerCase();
        String pluginName = args[1];
        try {
            if (action.equals("unload")) {
                this.unloadPlugin(pluginName, sender);
            } else if (action.equals("load")) {
                this.loadPlugin(pluginName, sender);
            } else {
                sender.sendMessage((Object)((Object)ChatColor.GREEN) + "Invalid action specified.");
            }
        }
        catch (Exception e) {
            sender.sendMessage((Object)((Object)ChatColor.GREEN) + "Error with " + pluginName + ": " + e.toString());
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        ArrayList tabs;
        block2: {
            String action;
            block3: {
                tabs = Lists.newArrayList();
                if (args.length <= 1) break block2;
                action = args[0].toLowerCase();
                if (!action.equals("unload")) break block3;
                for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
                    tabs.add(plugin.getName());
                }
                break block2;
            }
            if (!action.equals("load")) break block2;
            for (File file : new File("plugins").listFiles()) {
                if (!file.isFile() || !file.getName().toLowerCase().endsWith(".jar")) continue;
                tabs.add(file.getName().substring(0, file.getName().length() - 4));
            }
        }
        return tabs;
    }

    private void unloadPlugin(String pluginName, CommandSender sender) throws Exception {
        SimplePluginManager manager = (SimplePluginManager)Bukkit.getServer().getPluginManager();
        List plugins = (List)ReflectionHelper.getPrivateValue(SimplePluginManager.class, manager, "plugins");
        Map lookupNames = (Map)ReflectionHelper.getPrivateValue(SimplePluginManager.class, manager, "lookupNames");
        SimpleCommandMap commandMap = (SimpleCommandMap)ReflectionHelper.getPrivateValue(SimplePluginManager.class, manager, "commandMap");
        Map knownCommands = (Map)ReflectionHelper.getPrivateValue(SimpleCommandMap.class, commandMap, "knownCommands");
        for (Plugin plugin : manager.getPlugins()) {
            if (!plugin.getDescription().getName().equalsIgnoreCase(pluginName)) continue;
            manager.disablePlugin(plugin);
            plugins.remove(plugin);
            lookupNames.remove(pluginName);
            Iterator it = knownCommands.entrySet().iterator();
            while (it.hasNext()) {
                PluginCommand command;
                Map.Entry entry = it.next();
                if (!(entry.getValue() instanceof PluginCommand) || (command = (PluginCommand)entry.getValue()).getPlugin() != plugin) continue;
                command.unregister(commandMap);
                it.remove();
            }
            sender.sendMessage((Object)((Object)ChatColor.GREEN) + "Unloaded " + pluginName + " successfully!");
            return;
        }
        sender.sendMessage((Object)((Object)ChatColor.GREEN) + "Can't found loaded plugin: " + pluginName);
    }

    private void loadPlugin(String pluginName, CommandSender sender) {
        try {
            PluginManager manager = Bukkit.getServer().getPluginManager();
            File pluginFile = new File("plugins", pluginName + ".jar");
            if (!pluginFile.exists() || !pluginFile.isFile()) {
                sender.sendMessage((Object)((Object)ChatColor.GREEN) + "Error loading " + pluginName + ".jar, no plugin with that name was found.");
                return;
            }
            Plugin plugin = manager.loadPlugin(pluginFile);
            plugin.onLoad();
            manager.enablePlugin(plugin);
            sender.sendMessage((Object)((Object)ChatColor.GREEN) + "Loaded " + pluginName + " successfully!");
        }
        catch (Exception e) {
            sender.sendMessage((Object)((Object)ChatColor.GREEN) + "Error loading " + pluginName + ".jar, this plugin must be reloaded by restarting the server.");
        }
    }
}

