/*
 * Decompiled with CFR 0.152.
 */
package catserver.server.remapper;

import catserver.server.remapper.CatServerRemapper;
import catserver.server.remapper.ClassInheritanceProvider;
import catserver.server.remapper.MappingLoader;
import catserver.server.remapper.ReflectionTransformer;
import java.nio.ByteBuffer;
import java.security.ProtectionDomain;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.provider.ClassLoaderProvider;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.provider.JointProvider;
import net.md_5.specialsource.repo.ClassRepo;
import net.md_5.specialsource.repo.RuntimeRepo;

public class CatClassLoader
extends ClassLoader {
    private JarMapping jarMapping = MappingLoader.loadMapping();
    private CatServerRemapper remapper;

    protected CatClassLoader() {
        JointProvider provider = new JointProvider();
        provider.add((InheritanceProvider)new ClassInheritanceProvider());
        provider.add((InheritanceProvider)new ClassLoaderProvider((ClassLoader)this));
        this.jarMapping.setFallbackInheritanceProvider((InheritanceProvider)provider);
        this.remapper = new CatServerRemapper(this.jarMapping);
    }

    protected CatClassLoader(ClassLoader parent) {
        super(parent);
        JointProvider provider = new JointProvider();
        provider.add((InheritanceProvider)new ClassInheritanceProvider());
        provider.add((InheritanceProvider)new ClassLoaderProvider((ClassLoader)this));
        this.jarMapping.setFallbackInheritanceProvider((InheritanceProvider)provider);
        this.remapper = new CatServerRemapper(this.jarMapping);
    }

    public final Class<?> defineClassRemap(byte[] b2, int off, int len) throws ClassFormatError {
        return this.defineClassRemap(null, b2, off, len, null);
    }

    public final Class<?> defineClassRemap(String name, byte[] b2, int off, int len) throws ClassFormatError {
        return this.defineClassRemap(name, b2, off, len, null);
    }

    public final Class<?> defineClassRemap(String name, ByteBuffer b2, ProtectionDomain protectionDomain) throws ClassFormatError {
        if (!b2.isDirect() && b2.hasArray()) {
            return this.remappedFindClass(name, b2.array(), protectionDomain);
        }
        return this.defineClass(name, b2, protectionDomain);
    }

    public final Class<?> defineClassRemap(String name, byte[] b2, int off, int len, ProtectionDomain protectionDomain) throws ClassFormatError {
        if (off == 0) {
            return this.remappedFindClass(name, b2, protectionDomain);
        }
        return this.defineClass(name, b2, off, len, protectionDomain);
    }

    private Class<?> remappedFindClass(String name, byte[] stream, ProtectionDomain protectionDomain) throws ClassFormatError {
        Class<?> result = null;
        try {
            byte[] bytecode = this.remapper.remapClassFile(stream, (ClassRepo)RuntimeRepo.getInstance());
            bytecode = ReflectionTransformer.transform(bytecode);
            result = this.defineClass(name, bytecode, 0, bytecode.length, protectionDomain);
        }
        catch (Throwable t) {
            throw new ClassFormatError("Failed to remap class " + name);
        }
        return result;
    }
}

