/*
 * Decompiled with CFR 0.152.
 */
package com.conversantmedia.util.concurrent;

import com.conversantmedia.util.concurrent.AbstractCondition;
import com.conversantmedia.util.concurrent.AbstractSpinningCondition;
import com.conversantmedia.util.concurrent.AbstractWaitingCondition;
import com.conversantmedia.util.concurrent.Condition;
import com.conversantmedia.util.concurrent.MultithreadConcurrentQueue;
import com.conversantmedia.util.concurrent.SpinPolicy;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

public final class NoLockDisruptorBlockingQueue<E>
extends MultithreadConcurrentQueue<E>
implements Serializable,
Iterable<E>,
Collection<E>,
BlockingQueue<E>,
Queue<E> {
    protected final Condition queueNotFullCondition;
    protected final Condition queueNotEmptyCondition;

    public NoLockDisruptorBlockingQueue(int capacity) {
        this(capacity, SpinPolicy.WAITING);
    }

    public NoLockDisruptorBlockingQueue(int capacity, SpinPolicy spinPolicy) {
        super(capacity);
        switch (spinPolicy) {
            case BLOCKING: {
                this.queueNotFullCondition = new QueueNotFull();
                this.queueNotEmptyCondition = new QueueNotEmpty();
                break;
            }
            case SPINNING: {
                this.queueNotFullCondition = new SpinningQueueNotFull();
                this.queueNotEmptyCondition = new SpinningQueueNotEmpty();
                break;
            }
            default: {
                this.queueNotFullCondition = new WaitingQueueNotFull();
                this.queueNotEmptyCondition = new WaitingQueueNotEmpty();
            }
        }
    }

    public NoLockDisruptorBlockingQueue(int capacity, Collection<? extends E> c2) {
        this(capacity);
        for (E e : c2) {
            this.offer(e);
        }
    }

    @Override
    public final boolean offer(E e) {
        return super.offer(e);
    }

    @Override
    public final E poll() {
        Object e = super.poll();
        return e;
    }

    @Override
    public int remove(E[] e) {
        int n = super.remove(e);
        return n;
    }

    @Override
    public E remove() {
        return this.poll();
    }

    @Override
    public E element() {
        Object val = this.peek();
        if (val != null) {
            return val;
        }
        throw new NoSuchElementException("No element found.");
    }

    @Override
    public void put(E e) throws InterruptedException {
        while (!this.offer(e)) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            this.queueNotFullCondition.await();
        }
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        do {
            if (!this.offer(e)) continue;
            return true;
        } while (Condition.waitStatus(timeout, unit, this.queueNotFullCondition));
        return false;
    }

    @Override
    public E take() throws InterruptedException {
        E pollObj;
        while ((pollObj = this.poll()) == null) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            LockSupport.parkNanos(10000L);
        }
        return pollObj;
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        do {
            E pollObj;
            if ((pollObj = this.poll()) == null) continue;
            return pollObj;
        } while (Condition.waitStatus(timeout, unit, this.queueNotEmptyCondition));
        return null;
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public int remainingCapacity() {
        return this.size - this.size();
    }

    @Override
    public int drainTo(Collection<? super E> c2) {
        return this.drainTo(c2, this.size());
    }

    @Override
    public int drainTo(Collection<? super E> c2, int maxElements) {
        if (this == c2) {
            throw new IllegalArgumentException("Can not drain to self.");
        }
        Object[] pollObj = new Object[Math.min(this.size(), maxElements)];
        int nEle = this.remove(pollObj);
        int nRead = 0;
        for (int i = 0; i < nEle; ++i) {
            if (!c2.add(pollObj[i])) continue;
            ++nRead;
        }
        return nRead;
    }

    @Override
    public Object[] toArray() {
        Object[] e = new Object[this.size()];
        this.toArray(e);
        return e;
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        this.remove(a2);
        return a2;
    }

    @Override
    public boolean add(E e) {
        if (this.offer(e)) {
            return true;
        }
        throw new IllegalStateException("queue is full");
    }

    @Override
    public boolean remove(Object o) {
        long tail;
        long head;
        while (!this.headCursor.compareAndSet(head = this.head.sum(), head + 1L)) {
        }
        while (!this.tailCursor.compareAndSet(tail = this.tail.sum(), tail + 1L)) {
        }
        int n = 0;
        for (int i = 0; i < this.size(); ++i) {
            int slot = (int)(this.head.sum() + (long)i & this.mask);
            if (this.buffer[slot] == null || !this.buffer[slot].equals(o)) continue;
            ++n;
            for (int j = i; j > 0; --j) {
                int cSlot = (int)(this.head.sum() + (long)j - 1L & this.mask);
                int nextSlot = (int)(this.head.sum() + (long)j & this.mask);
                this.buffer[nextSlot] = this.buffer[cSlot];
            }
        }
        if (n > 0) {
            this.headCursor.set(head + (long)n);
            this.tailCursor.set(tail);
            this.head.add(n);
            return true;
        }
        this.tailCursor.set(tail);
        this.headCursor.set(head);
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c2) {
        for (Object o : c2) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c2) {
        boolean rc = false;
        for (E e : c2) {
            if (!this.offer(e)) continue;
            rc = true;
        }
        return rc;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        boolean isChanged = false;
        for (Object o : c2) {
            if (!this.remove(o)) continue;
            isChanged = true;
        }
        return isChanged;
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        boolean isChanged = false;
        for (int i = 0; i < this.size(); ++i) {
            int headSlot = (int)(this.head.sum() + (long)i & this.mask);
            if (this.buffer[headSlot] == null || c2.contains(this.buffer[headSlot]) || !this.remove(this.buffer[headSlot])) continue;
            --i;
            isChanged = true;
        }
        return isChanged;
    }

    @Override
    public Iterator<E> iterator() {
        return new RingIter();
    }

    private boolean isFull() {
        long queueStart = this.tail.sum() - (long)this.size;
        return this.head.sum() == queueStart;
    }

    private final class SpinningQueueNotEmpty
    extends AbstractSpinningCondition {
        private SpinningQueueNotEmpty() {
        }

        @Override
        public final boolean test() {
            return NoLockDisruptorBlockingQueue.this.isEmpty();
        }
    }

    private final class SpinningQueueNotFull
    extends AbstractSpinningCondition {
        private SpinningQueueNotFull() {
        }

        @Override
        public final boolean test() {
            return NoLockDisruptorBlockingQueue.this.isFull();
        }
    }

    private final class WaitingQueueNotEmpty
    extends AbstractWaitingCondition {
        private WaitingQueueNotEmpty() {
        }

        @Override
        public final boolean test() {
            return NoLockDisruptorBlockingQueue.this.isEmpty();
        }
    }

    private final class WaitingQueueNotFull
    extends AbstractWaitingCondition {
        private WaitingQueueNotFull() {
        }

        @Override
        public final boolean test() {
            return NoLockDisruptorBlockingQueue.this.isFull();
        }
    }

    private final class QueueNotEmpty
    extends AbstractCondition {
        private QueueNotEmpty() {
        }

        @Override
        public final boolean test() {
            return NoLockDisruptorBlockingQueue.this.isEmpty();
        }
    }

    private final class QueueNotFull
    extends AbstractCondition {
        private QueueNotFull() {
        }

        @Override
        public final boolean test() {
            return NoLockDisruptorBlockingQueue.this.isFull();
        }
    }

    private final class RingIter
    implements Iterator<E> {
        int dx = 0;
        E lastObj = null;

        private RingIter() {
        }

        @Override
        public boolean hasNext() {
            return this.dx < NoLockDisruptorBlockingQueue.this.size();
        }

        @Override
        public E next() {
            long pollPos = NoLockDisruptorBlockingQueue.this.head.sum();
            int slot = (int)(pollPos + (long)this.dx++ & NoLockDisruptorBlockingQueue.this.mask);
            this.lastObj = NoLockDisruptorBlockingQueue.this.buffer[slot];
            return this.lastObj;
        }

        @Override
        public void remove() {
            NoLockDisruptorBlockingQueue.this.remove(this.lastObj);
        }
    }
}

