/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.event;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import net.minecraftforge.fml.common.event.FMLEvent;

public class FMLModIdMappingEvent
extends FMLEvent {
    private final Map<nf, ImmutableList<ModRemapping>> remaps;
    private final ImmutableSet<nf> keys;
    public final boolean isFrozen;

    public FMLModIdMappingEvent(Map<nf, Map<nf, Integer[]>> remaps, boolean isFrozen) {
        this.isFrozen = isFrozen;
        this.remaps = Maps.newHashMap();
        remaps.forEach((name, rm) -> {
            ArrayList tmp = Lists.newArrayList();
            rm.forEach((key, value) -> tmp.add(new ModRemapping((nf)name, (nf)key, value[0], value[1])));
            tmp.sort(Comparator.comparingInt(o -> o.newId));
            this.remaps.put((nf)name, (ImmutableList<ModRemapping>)ImmutableList.copyOf((Collection)tmp));
        });
        this.keys = ImmutableSet.copyOf(this.remaps.keySet());
    }

    public ImmutableSet<nf> getRegistries() {
        return this.keys;
    }

    public ImmutableList<ModRemapping> getRemaps(nf registry) {
        return this.remaps.get(registry);
    }

    public class ModRemapping {
        public final nf registry;
        public final nf key;
        public final int oldId;
        public final int newId;

        private ModRemapping(nf registry, nf key, int oldId, int newId) {
            this.registry = registry;
            this.key = key;
            this.oldId = oldId;
            this.newId = newId;
        }
    }
}

