/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1;

import com.google.common.base.CaseFormat;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import net.minecraft.server.v1_12_R1.Block;
import net.minecraft.server.v1_12_R1.EntityTypes;
import net.minecraft.server.v1_12_R1.Item;
import net.minecraft.server.v1_12_R1.MinecraftKey;
import net.minecraft.server.v1_12_R1.StatisticList;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.craftbukkit.v1_12_R1.util.CraftMagicNumbers;
import org.bukkit.entity.EntityType;

public class CraftStatistic {
    private static final BiMap<String, Statistic> statistics;

    static {
        ImmutableBiMap.Builder statisticBuilder = ImmutableBiMap.builder();
        Statistic[] statisticArray = Statistic.values();
        int n = statisticArray.length;
        int n2 = 0;
        while (n2 < n) {
            Statistic statistic = statisticArray[n2];
            if (statistic == Statistic.PLAY_ONE_TICK) {
                statisticBuilder.put((Object)"stat.playOneMinute", (Object)statistic);
            } else {
                statisticBuilder.put((Object)("stat." + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, statistic.name())), (Object)statistic);
            }
            ++n2;
        }
        statistics = statisticBuilder.build();
    }

    private CraftStatistic() {
    }

    public static Statistic getBukkitStatistic(net.minecraft.server.v1_12_R1.Statistic statistic) {
        return CraftStatistic.getBukkitStatisticByName(statistic.name);
    }

    public static Statistic getBukkitStatisticByName(String name) {
        if (name.startsWith("stat.killEntity.")) {
            name = "stat.killEntity";
        }
        if (name.startsWith("stat.entityKilledBy.")) {
            name = "stat.entityKilledBy";
        }
        if (name.startsWith("stat.breakItem.")) {
            name = "stat.breakItem";
        }
        if (name.startsWith("stat.useItem.")) {
            name = "stat.useItem";
        }
        if (name.startsWith("stat.mineBlock.")) {
            name = "stat.mineBlock";
        }
        if (name.startsWith("stat.craftItem.")) {
            name = "stat.craftItem";
        }
        if (name.startsWith("stat.drop.")) {
            name = "stat.drop";
        }
        if (name.startsWith("stat.pickup.")) {
            name = "stat.pickup";
        }
        return (Statistic)((Object)statistics.get((Object)name));
    }

    public static net.minecraft.server.v1_12_R1.Statistic getNMSStatistic(Statistic statistic) {
        return StatisticList.getStatistic((String)((String)statistics.inverse().get((Object)statistic)));
    }

    public static net.minecraft.server.v1_12_R1.Statistic getMaterialStatistic(Statistic stat, Material material) {
        try {
            if (stat == Statistic.MINE_BLOCK) {
                return StatisticList.a((Block)CraftMagicNumbers.getBlock(material));
            }
            if (stat == Statistic.CRAFT_ITEM) {
                return StatisticList.a((Item)CraftMagicNumbers.getItem(material));
            }
            if (stat == Statistic.USE_ITEM) {
                return StatisticList.b((Item)CraftMagicNumbers.getItem(material));
            }
            if (stat == Statistic.BREAK_ITEM) {
                return StatisticList.c((Item)CraftMagicNumbers.getItem(material));
            }
            if (stat == Statistic.PICKUP) {
                return StatisticList.d((Item)CraftMagicNumbers.getItem(material));
            }
            if (stat == Statistic.DROP) {
                return StatisticList.e((Item)CraftMagicNumbers.getItem(material));
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
        return null;
    }

    public static net.minecraft.server.v1_12_R1.Statistic getEntityStatistic(Statistic stat, EntityType entity) {
        EntityTypes.MonsterEggInfo monsteregginfo = (EntityTypes.MonsterEggInfo)EntityTypes.eggInfo.get(new MinecraftKey(entity.getName()));
        if (monsteregginfo != null) {
            if (stat == Statistic.KILL_ENTITY) {
                return monsteregginfo.killEntityStatistic;
            }
            if (stat == Statistic.ENTITY_KILLED_BY) {
                return monsteregginfo.killedByEntityStatistic;
            }
        }
        return null;
    }

    public static EntityType getEntityTypeFromStatistic(net.minecraft.server.v1_12_R1.Statistic statistic) {
        String statisticString = statistic.name;
        return EntityType.fromName(statisticString.substring(statisticString.lastIndexOf(".") + 1));
    }

    public static Material getMaterialFromStatistic(net.minecraft.server.v1_12_R1.Statistic statistic) {
        String statisticString = statistic.name;
        String val = statisticString.substring(statisticString.lastIndexOf(".") + 1);
        Item item = (Item)Item.REGISTRY.get((Object)new MinecraftKey(val));
        if (item != null) {
            return Material.getMaterial(Item.getId((Item)item));
        }
        Block block = (Block)Block.REGISTRY.get((Object)new MinecraftKey(val));
        if (block != null) {
            return Material.getMaterial(Block.getId((Block)block));
        }
        try {
            return Material.getMaterial(Integer.parseInt(val));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

