/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.v1_12_R1.AxisAlignedBB;
import net.minecraft.server.v1_12_R1.BiomeBase;
import net.minecraft.server.v1_12_R1.Block;
import net.minecraft.server.v1_12_R1.BlockChorusFlower;
import net.minecraft.server.v1_12_R1.BlockDiodeAbstract;
import net.minecraft.server.v1_12_R1.BlockLeaves;
import net.minecraft.server.v1_12_R1.BlockLeaves1;
import net.minecraft.server.v1_12_R1.BlockLog1;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.BlockWood;
import net.minecraft.server.v1_12_R1.Blocks;
import net.minecraft.server.v1_12_R1.ChunkCoordIntPair;
import net.minecraft.server.v1_12_R1.ChunkProviderServer;
import net.minecraft.server.v1_12_R1.EntityAreaEffectCloud;
import net.minecraft.server.v1_12_R1.EntityArmorStand;
import net.minecraft.server.v1_12_R1.EntityBat;
import net.minecraft.server.v1_12_R1.EntityBlaze;
import net.minecraft.server.v1_12_R1.EntityBoat;
import net.minecraft.server.v1_12_R1.EntityCaveSpider;
import net.minecraft.server.v1_12_R1.EntityChicken;
import net.minecraft.server.v1_12_R1.EntityCow;
import net.minecraft.server.v1_12_R1.EntityCreeper;
import net.minecraft.server.v1_12_R1.EntityDragonFireball;
import net.minecraft.server.v1_12_R1.EntityEgg;
import net.minecraft.server.v1_12_R1.EntityEnderCrystal;
import net.minecraft.server.v1_12_R1.EntityEnderDragon;
import net.minecraft.server.v1_12_R1.EntityEnderPearl;
import net.minecraft.server.v1_12_R1.EntityEnderSignal;
import net.minecraft.server.v1_12_R1.EntityEnderman;
import net.minecraft.server.v1_12_R1.EntityEndermite;
import net.minecraft.server.v1_12_R1.EntityEvoker;
import net.minecraft.server.v1_12_R1.EntityEvokerFangs;
import net.minecraft.server.v1_12_R1.EntityExperienceOrb;
import net.minecraft.server.v1_12_R1.EntityFallingBlock;
import net.minecraft.server.v1_12_R1.EntityFireball;
import net.minecraft.server.v1_12_R1.EntityFireworks;
import net.minecraft.server.v1_12_R1.EntityGhast;
import net.minecraft.server.v1_12_R1.EntityGiantZombie;
import net.minecraft.server.v1_12_R1.EntityGuardian;
import net.minecraft.server.v1_12_R1.EntityGuardianElder;
import net.minecraft.server.v1_12_R1.EntityHanging;
import net.minecraft.server.v1_12_R1.EntityHorse;
import net.minecraft.server.v1_12_R1.EntityHorseDonkey;
import net.minecraft.server.v1_12_R1.EntityHorseMule;
import net.minecraft.server.v1_12_R1.EntityHorseSkeleton;
import net.minecraft.server.v1_12_R1.EntityHorseZombie;
import net.minecraft.server.v1_12_R1.EntityHuman;
import net.minecraft.server.v1_12_R1.EntityIllagerIllusioner;
import net.minecraft.server.v1_12_R1.EntityInsentient;
import net.minecraft.server.v1_12_R1.EntityIronGolem;
import net.minecraft.server.v1_12_R1.EntityItem;
import net.minecraft.server.v1_12_R1.EntityItemFrame;
import net.minecraft.server.v1_12_R1.EntityLargeFireball;
import net.minecraft.server.v1_12_R1.EntityLeash;
import net.minecraft.server.v1_12_R1.EntityLightning;
import net.minecraft.server.v1_12_R1.EntityLlama;
import net.minecraft.server.v1_12_R1.EntityLlamaSpit;
import net.minecraft.server.v1_12_R1.EntityMagmaCube;
import net.minecraft.server.v1_12_R1.EntityMinecartChest;
import net.minecraft.server.v1_12_R1.EntityMinecartCommandBlock;
import net.minecraft.server.v1_12_R1.EntityMinecartFurnace;
import net.minecraft.server.v1_12_R1.EntityMinecartHopper;
import net.minecraft.server.v1_12_R1.EntityMinecartMobSpawner;
import net.minecraft.server.v1_12_R1.EntityMinecartRideable;
import net.minecraft.server.v1_12_R1.EntityMinecartTNT;
import net.minecraft.server.v1_12_R1.EntityMushroomCow;
import net.minecraft.server.v1_12_R1.EntityOcelot;
import net.minecraft.server.v1_12_R1.EntityPainting;
import net.minecraft.server.v1_12_R1.EntityParrot;
import net.minecraft.server.v1_12_R1.EntityPig;
import net.minecraft.server.v1_12_R1.EntityPigZombie;
import net.minecraft.server.v1_12_R1.EntityPolarBear;
import net.minecraft.server.v1_12_R1.EntityPotion;
import net.minecraft.server.v1_12_R1.EntityRabbit;
import net.minecraft.server.v1_12_R1.EntitySheep;
import net.minecraft.server.v1_12_R1.EntityShulker;
import net.minecraft.server.v1_12_R1.EntityShulkerBullet;
import net.minecraft.server.v1_12_R1.EntitySilverfish;
import net.minecraft.server.v1_12_R1.EntitySkeleton;
import net.minecraft.server.v1_12_R1.EntitySkeletonStray;
import net.minecraft.server.v1_12_R1.EntitySkeletonWither;
import net.minecraft.server.v1_12_R1.EntitySlime;
import net.minecraft.server.v1_12_R1.EntitySmallFireball;
import net.minecraft.server.v1_12_R1.EntitySnowball;
import net.minecraft.server.v1_12_R1.EntitySnowman;
import net.minecraft.server.v1_12_R1.EntitySpectralArrow;
import net.minecraft.server.v1_12_R1.EntitySpider;
import net.minecraft.server.v1_12_R1.EntitySquid;
import net.minecraft.server.v1_12_R1.EntityTNTPrimed;
import net.minecraft.server.v1_12_R1.EntityThrownExpBottle;
import net.minecraft.server.v1_12_R1.EntityTippedArrow;
import net.minecraft.server.v1_12_R1.EntityVex;
import net.minecraft.server.v1_12_R1.EntityVillager;
import net.minecraft.server.v1_12_R1.EntityVindicator;
import net.minecraft.server.v1_12_R1.EntityWitch;
import net.minecraft.server.v1_12_R1.EntityWither;
import net.minecraft.server.v1_12_R1.EntityWitherSkull;
import net.minecraft.server.v1_12_R1.EntityWolf;
import net.minecraft.server.v1_12_R1.EntityZombie;
import net.minecraft.server.v1_12_R1.EntityZombieHusk;
import net.minecraft.server.v1_12_R1.EntityZombieVillager;
import net.minecraft.server.v1_12_R1.EnumDifficulty;
import net.minecraft.server.v1_12_R1.EnumDirection;
import net.minecraft.server.v1_12_R1.EnumParticle;
import net.minecraft.server.v1_12_R1.ExceptionWorldConflict;
import net.minecraft.server.v1_12_R1.IBlockData;
import net.minecraft.server.v1_12_R1.IBlockState;
import net.minecraft.server.v1_12_R1.IChunkProvider;
import net.minecraft.server.v1_12_R1.Packet;
import net.minecraft.server.v1_12_R1.PacketPlayOutCustomSoundEffect;
import net.minecraft.server.v1_12_R1.PacketPlayOutUpdateTime;
import net.minecraft.server.v1_12_R1.PacketPlayOutWorldEvent;
import net.minecraft.server.v1_12_R1.PacketPlayOutWorldParticles;
import net.minecraft.server.v1_12_R1.PlayerChunk;
import net.minecraft.server.v1_12_R1.TileEntity;
import net.minecraft.server.v1_12_R1.WorldGenAcaciaTree;
import net.minecraft.server.v1_12_R1.WorldGenBigTree;
import net.minecraft.server.v1_12_R1.WorldGenForest;
import net.minecraft.server.v1_12_R1.WorldGenForestTree;
import net.minecraft.server.v1_12_R1.WorldGenGroundBush;
import net.minecraft.server.v1_12_R1.WorldGenHugeMushroom;
import net.minecraft.server.v1_12_R1.WorldGenJungleTree;
import net.minecraft.server.v1_12_R1.WorldGenMegaTree;
import net.minecraft.server.v1_12_R1.WorldGenSwampTree;
import net.minecraft.server.v1_12_R1.WorldGenTaiga1;
import net.minecraft.server.v1_12_R1.WorldGenTaiga2;
import net.minecraft.server.v1_12_R1.WorldGenTrees;
import net.minecraft.server.v1_12_R1.WorldNBTStorage;
import net.minecraft.server.v1_12_R1.WorldProviderHell;
import net.minecraft.server.v1_12_R1.WorldProviderNormal;
import net.minecraft.server.v1_12_R1.WorldProviderTheEnd;
import net.minecraft.server.v1_12_R1.WorldServer;
import org.apache.commons.lang.Validate;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Difficulty;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_12_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_12_R1.CraftEffect;
import org.bukkit.craftbukkit.v1_12_R1.CraftParticle;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.CraftSound;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftItem;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftLightningStrike;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_12_R1.metadata.BlockMetadataStore;
import org.bukkit.craftbukkit.v1_12_R1.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_12_R1.util.CraftMagicNumbers;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Boat;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.ComplexLivingEntity;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Donkey;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Egg;
import org.bukkit.entity.ElderGuardian;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Giant;
import org.bukkit.entity.Golem;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Husk;
import org.bukkit.entity.Illager;
import org.bukkit.entity.Illusioner;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LeashHitch;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Mule;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.PolarBear;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.entity.Slime;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.Spellcaster;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Squid;
import org.bukkit.entity.Stray;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Vindicator;
import org.bukkit.entity.Weather;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkeleton;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieHorse;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.entity.minecart.SpawnerMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;
import org.bukkit.util.Consumer;
import org.bukkit.util.Vector;
import org.spigotmc.AsyncCatcher;

public class CraftWorld
implements World {
    public static final int CUSTOM_DIMENSION_OFFSET = 10;
    private final WorldServer world;
    private WorldBorder worldBorder;
    private World.Environment environment;
    private final CraftServer server = (CraftServer)Bukkit.getServer();
    private final ChunkGenerator generator;
    private final List<BlockPopulator> populators = new ArrayList<BlockPopulator>();
    private final BlockMetadataStore blockMetadata = new BlockMetadataStore(this);
    private int monsterSpawn = -1;
    private int animalSpawn = -1;
    private int waterAnimalSpawn = -1;
    private int ambientSpawn = -1;
    private int chunkLoadCount = 0;
    private int chunkGCTickCount;
    private static final Random rand = new Random();
    private final World.Spigot spigot = new World.Spigot(){

        @Override
        public void playEffect(Location location, Effect effect, int id, int data, float offsetX, float offsetY, float offsetZ, float speed, int particleCount, int radius) {
            PacketPlayOutWorldEvent packet;
            Validate.notNull((Object)location, (String)"Location cannot be null");
            Validate.notNull((Object)((Object)effect), (String)"Effect cannot be null");
            Validate.notNull((Object)location.getWorld(), (String)"World cannot be null");
            if (effect.getType() != Effect.Type.PARTICLE) {
                int packetData = effect.getId();
                packet = new PacketPlayOutWorldEvent(packetData, new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()), id, false);
            } else {
                EnumParticle particle = null;
                int[] extra = null;
                EnumParticle[] enumParticleArray = EnumParticle.values();
                int n = enumParticleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    EnumParticle p = enumParticleArray[n2];
                    if (effect.getName().startsWith(p.b().replace("_", ""))) {
                        particle = p;
                        if (effect.getData() == null) break;
                        if (effect.getData().equals(Material.class)) {
                            extra = new int[]{id};
                            break;
                        }
                        extra = new int[]{data << 12 | id & 0xFFF};
                        break;
                    }
                    ++n2;
                }
                if (extra == null) {
                    extra = new int[]{};
                }
                packet = new PacketPlayOutWorldParticles(particle, true, (float)location.getX(), (float)location.getY(), (float)location.getZ(), offsetX, offsetY, offsetZ, speed, particleCount, extra);
            }
            radius *= radius;
            for (Player player : CraftWorld.this.getPlayers()) {
                int distance;
                if (((CraftPlayer)player).getHandle().playerConnection == null || !location.getWorld().equals(player.getWorld()) || (distance = (int)player.getLocation().distanceSquared(location)) > radius) continue;
                ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packet);
            }
        }

        @Override
        public void playEffect(Location location, Effect effect) {
            CraftWorld.this.playEffect(location, effect, 0);
        }

        @Override
        public LightningStrike strikeLightning(Location loc, boolean isSilent) {
            EntityLightning lightning = new EntityLightning((net.minecraft.server.v1_12_R1.World)CraftWorld.this.world, loc.getX(), loc.getY(), loc.getZ(), false, isSilent);
            CraftWorld.this.world.strikeLightning((net.minecraft.server.v1_12_R1.Entity)lightning);
            return new CraftLightningStrike(CraftWorld.this.server, lightning);
        }

        @Override
        public LightningStrike strikeLightningEffect(Location loc, boolean isSilent) {
            EntityLightning lightning = new EntityLightning((net.minecraft.server.v1_12_R1.World)CraftWorld.this.world, loc.getX(), loc.getY(), loc.getZ(), true, isSilent);
            CraftWorld.this.world.strikeLightning((net.minecraft.server.v1_12_R1.Entity)lightning);
            return new CraftLightningStrike(CraftWorld.this.server, lightning);
        }
    };

    public CraftWorld(WorldServer world, ChunkGenerator gen, World.Environment env) {
        this.world = world;
        this.generator = gen;
        this.environment = env;
        if (this.server.chunkGCPeriod > 0) {
            this.chunkGCTickCount = rand.nextInt(this.server.chunkGCPeriod);
        }
    }

    @Override
    public org.bukkit.block.Block getBlockAt(int x, int y, int z) {
        return this.getChunkAt(x >> 4, z >> 4).getBlock(x & 0xF, y, z & 0xF);
    }

    @Override
    public int getBlockTypeIdAt(int x, int y, int z) {
        return CraftMagicNumbers.getId(this.world.getType(new BlockPosition(x, y, z)).getBlock());
    }

    @Override
    public int getHighestBlockYAt(int x, int z) {
        if (!this.isChunkLoaded(x >> 4, z >> 4)) {
            this.loadChunk(x >> 4, z >> 4);
        }
        return this.world.getHighestBlockYAt(new BlockPosition(x, 0, z)).getY();
    }

    @Override
    public Location getSpawnLocation() {
        BlockPosition spawn = this.world.getSpawn();
        return new Location(this, spawn.getX(), spawn.getY(), spawn.getZ());
    }

    @Override
    public boolean setSpawnLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location");
        return this.equals(location.getWorld()) ? this.setSpawnLocation(location.getBlockX(), location.getBlockY(), location.getBlockZ()) : false;
    }

    @Override
    public boolean setSpawnLocation(int x, int y, int z) {
        try {
            Location previousLocation = this.getSpawnLocation();
            this.world.worldData.setSpawn(new BlockPosition(x, y, z));
            SpawnChangeEvent event = new SpawnChangeEvent(this, previousLocation);
            this.server.getPluginManager().callEvent(event);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public Chunk getChunkAt(int x, int z) {
        return this.world.getChunkProviderServer().getChunkAt((int)x, (int)z).bukkitChunk;
    }

    @Override
    public Chunk getChunkAt(org.bukkit.block.Block block) {
        return this.getChunkAt(block.getX() >> 4, block.getZ() >> 4);
    }

    @Override
    public boolean isChunkLoaded(int x, int z) {
        return this.world.getChunkProviderServer().isLoaded(x, z);
    }

    @Override
    public Chunk[] getLoadedChunks() {
        Object[] chunks = this.world.getChunkProviderServer().chunks.values().toArray();
        Chunk[] craftChunks = new CraftChunk[chunks.length];
        int i = 0;
        while (i < chunks.length) {
            net.minecraft.server.v1_12_R1.Chunk chunk = (net.minecraft.server.v1_12_R1.Chunk)chunks[i];
            craftChunks[i] = chunk.bukkitChunk;
            ++i;
        }
        return craftChunks;
    }

    @Override
    public void loadChunk(int x, int z) {
        this.loadChunk(x, z, true);
    }

    @Override
    public boolean unloadChunk(Chunk chunk) {
        return this.unloadChunk(chunk.getX(), chunk.getZ());
    }

    @Override
    public boolean unloadChunk(int x, int z) {
        return this.unloadChunk(x, z, true);
    }

    @Override
    public boolean unloadChunk(int x, int z, boolean save) {
        return this.unloadChunk(x, z, save, false);
    }

    @Override
    public boolean unloadChunkRequest(int x, int z) {
        return this.unloadChunkRequest(x, z, true);
    }

    @Override
    public boolean unloadChunkRequest(int x, int z, boolean safe) {
        AsyncCatcher.catchOp("chunk unload");
        if (safe && this.isChunkInUse(x, z)) {
            return false;
        }
        net.minecraft.server.v1_12_R1.Chunk chunk = this.world.getChunkProviderServer().getLoadedChunkAt(x, z);
        if (chunk != null) {
            this.world.getChunkProviderServer().unload(chunk);
        }
        return true;
    }

    @Override
    public boolean unloadChunk(int x, int z, boolean save, boolean safe) {
        AsyncCatcher.catchOp("chunk unload");
        if (this.isChunkInUse(x, z)) {
            return false;
        }
        return this.unloadChunk0(x, z, save);
    }

    private boolean unloadChunk0(int x, int z, boolean save) {
        net.minecraft.server.v1_12_R1.Chunk chunk = this.world.getChunkProviderServer().getChunkIfLoaded(x, z);
        if (chunk == null) {
            return true;
        }
        return this.world.getChunkProviderServer().unloadChunk(chunk, chunk.mustSave || save);
    }

    @Override
    public boolean regenerateChunk(int x, int z) {
        if (!this.unloadChunk0(x, z, false)) {
            return false;
        }
        long chunkKey = ChunkCoordIntPair.a((int)x, (int)z);
        this.world.getChunkProviderServer().unloadQueue.remove(chunkKey);
        net.minecraft.server.v1_12_R1.Chunk chunk = null;
        chunk = this.world.getChunkProviderServer().chunkGenerator.getOrCreateChunk(x, z);
        PlayerChunk playerChunk = this.world.getPlayerChunkMap().getChunk(x, z);
        if (playerChunk != null) {
            playerChunk.chunk = chunk;
        }
        if (chunk != null) {
            this.world.getChunkProviderServer().chunks.put(chunkKey, (Object)chunk);
            chunk.addEntities();
            chunk.loadNearby((IChunkProvider)this.world.getChunkProviderServer(), this.world.getChunkProviderServer().chunkGenerator, true);
            this.refreshChunk(x, z);
        }
        return chunk != null;
    }

    @Override
    public boolean refreshChunk(int x, int z) {
        if (!this.isChunkLoaded(x, z)) {
            return false;
        }
        int px = x << 4;
        int pz = z << 4;
        int height = this.getMaxHeight() / 16;
        int idx = 0;
        while (idx < 64) {
            this.world.notify(new BlockPosition(px + idx / height, idx % height * 16, pz), Blocks.AIR.getBlockData(), Blocks.STONE.getBlockData(), 3);
            ++idx;
        }
        this.world.notify(new BlockPosition(px + 15, height * 16 - 1, pz + 15), Blocks.AIR.getBlockData(), Blocks.STONE.getBlockData(), 3);
        return true;
    }

    @Override
    public boolean isChunkInUse(int x, int z) {
        return this.world.getPlayerChunkMap().isChunkInUse(x, z);
    }

    @Override
    public boolean loadChunk(int x, int z, boolean generate) {
        AsyncCatcher.catchOp("chunk load");
        ++this.chunkLoadCount;
        if (generate) {
            return this.world.getChunkProviderServer().getChunkAt(x, z) != null;
        }
        return this.world.getChunkProviderServer().getOrLoadChunkAt(x, z) != null;
    }

    @Override
    public boolean isChunkLoaded(Chunk chunk) {
        return this.isChunkLoaded(chunk.getX(), chunk.getZ());
    }

    @Override
    public void loadChunk(Chunk chunk) {
        this.loadChunk(chunk.getX(), chunk.getZ());
        ((CraftChunk)this.getChunkAt((int)chunk.getX(), (int)chunk.getZ())).getHandle().bukkitChunk = chunk;
    }

    public WorldServer getHandle() {
        return this.world;
    }

    @Override
    public Item dropItem(Location loc, ItemStack item) {
        Validate.notNull((Object)item, (String)"Cannot drop a Null item.");
        Validate.isTrue((item.getTypeId() != 0 ? 1 : 0) != 0, (String)"Cannot drop AIR.");
        EntityItem entity = new EntityItem((net.minecraft.server.v1_12_R1.World)this.world, loc.getX(), loc.getY(), loc.getZ(), CraftItemStack.asNMSCopy(item));
        entity.pickupDelay = 10;
        this.world.addEntity((net.minecraft.server.v1_12_R1.Entity)entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return new CraftItem(this.world.getServer(), entity);
    }

    private static void randomLocationWithinBlock(Location loc, double xs, double ys, double zs) {
        double prevX = loc.getX();
        double prevY = loc.getY();
        double prevZ = loc.getZ();
        loc.add(xs, ys, zs);
        if (loc.getX() < Math.floor(prevX)) {
            loc.setX(Math.floor(prevX));
        }
        if (loc.getX() >= Math.ceil(prevX)) {
            loc.setX(Math.ceil(prevX - 0.01));
        }
        if (loc.getY() < Math.floor(prevY)) {
            loc.setY(Math.floor(prevY));
        }
        if (loc.getY() >= Math.ceil(prevY)) {
            loc.setY(Math.ceil(prevY - 0.01));
        }
        if (loc.getZ() < Math.floor(prevZ)) {
            loc.setZ(Math.floor(prevZ));
        }
        if (loc.getZ() >= Math.ceil(prevZ)) {
            loc.setZ(Math.ceil(prevZ - 0.01));
        }
    }

    @Override
    public Item dropItemNaturally(Location loc, ItemStack item) {
        double xs = (double)(this.world.random.nextFloat() * 0.7f) - 0.35;
        double ys = (double)(this.world.random.nextFloat() * 0.7f) - 0.35;
        double zs = (double)(this.world.random.nextFloat() * 0.7f) - 0.35;
        loc = loc.clone();
        CraftWorld.randomLocationWithinBlock(loc, xs, ys, zs);
        return this.dropItem(loc, item);
    }

    @Override
    public Arrow spawnArrow(Location loc, Vector velocity, float speed, float spread) {
        return this.spawnArrow(loc, velocity, speed, spread, Arrow.class);
    }

    @Override
    public <T extends Arrow> T spawnArrow(Location loc, Vector velocity, float speed, float spread, Class<T> clazz) {
        Object arrow;
        Validate.notNull((Object)loc, (String)"Can not spawn arrow with a null location");
        Validate.notNull((Object)velocity, (String)"Can not spawn arrow with a null velocity");
        Validate.notNull(clazz, (String)"Can not spawn an arrow with no class");
        if (TippedArrow.class.isAssignableFrom(clazz)) {
            arrow = new EntityTippedArrow((net.minecraft.server.v1_12_R1.World)this.world);
            arrow.setType(CraftPotionUtil.fromBukkit(new PotionData(PotionType.WATER, false, false)));
        } else {
            arrow = SpectralArrow.class.isAssignableFrom(clazz) ? new EntitySpectralArrow((net.minecraft.server.v1_12_R1.World)this.world) : new EntityTippedArrow((net.minecraft.server.v1_12_R1.World)this.world);
        }
        arrow.setPositionRotation(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        arrow.shoot(velocity.getX(), velocity.getY(), velocity.getZ(), speed, spread);
        this.world.addEntity((net.minecraft.server.v1_12_R1.Entity)arrow);
        return (T)((Arrow)((Object)arrow.getBukkitEntity()));
    }

    @Override
    public Entity spawnEntity(Location loc, EntityType entityType) {
        return this.spawn(loc, entityType.getEntityClass());
    }

    @Override
    public LightningStrike strikeLightning(Location loc) {
        EntityLightning lightning = new EntityLightning((net.minecraft.server.v1_12_R1.World)this.world, loc.getX(), loc.getY(), loc.getZ(), false);
        this.world.strikeLightning((net.minecraft.server.v1_12_R1.Entity)lightning);
        return new CraftLightningStrike(this.server, lightning);
    }

    @Override
    public LightningStrike strikeLightningEffect(Location loc) {
        EntityLightning lightning = new EntityLightning((net.minecraft.server.v1_12_R1.World)this.world, loc.getX(), loc.getY(), loc.getZ(), true);
        this.world.strikeLightning((net.minecraft.server.v1_12_R1.Entity)lightning);
        return new CraftLightningStrike(this.server, lightning);
    }

    @Override
    public boolean generateTree(Location loc, TreeType type) {
        WorldGenTaiga1 gen;
        BlockPosition pos = new BlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        switch (type) {
            case BIG_TREE: {
                gen = new WorldGenBigTree(true);
                break;
            }
            case BIRCH: {
                gen = new WorldGenForest(true, false);
                break;
            }
            case REDWOOD: {
                gen = new WorldGenTaiga2(true);
                break;
            }
            case TALL_REDWOOD: {
                gen = new WorldGenTaiga1();
                break;
            }
            case JUNGLE: {
                IBlockData iblockdata1 = Blocks.LOG.getBlockData().set((IBlockState)BlockLog1.VARIANT, (Comparable)BlockWood.EnumLogVariant.JUNGLE);
                IBlockData iblockdata2 = Blocks.LEAVES.getBlockData().set((IBlockState)BlockLeaves1.VARIANT, (Comparable)BlockWood.EnumLogVariant.JUNGLE).set((IBlockState)BlockLeaves.CHECK_DECAY, (Comparable)Boolean.valueOf(false));
                gen = new WorldGenJungleTree(true, 10, 20, iblockdata1, iblockdata2);
                break;
            }
            case SMALL_JUNGLE: {
                IBlockData iblockdata1 = Blocks.LOG.getBlockData().set((IBlockState)BlockLog1.VARIANT, (Comparable)BlockWood.EnumLogVariant.JUNGLE);
                IBlockData iblockdata2 = Blocks.LEAVES.getBlockData().set((IBlockState)BlockLeaves1.VARIANT, (Comparable)BlockWood.EnumLogVariant.JUNGLE).set((IBlockState)BlockLeaves.CHECK_DECAY, (Comparable)Boolean.valueOf(false));
                gen = new WorldGenTrees(true, 4 + rand.nextInt(7), iblockdata1, iblockdata2, false);
                break;
            }
            case COCOA_TREE: {
                IBlockData iblockdata1 = Blocks.LOG.getBlockData().set((IBlockState)BlockLog1.VARIANT, (Comparable)BlockWood.EnumLogVariant.JUNGLE);
                IBlockData iblockdata2 = Blocks.LEAVES.getBlockData().set((IBlockState)BlockLeaves1.VARIANT, (Comparable)BlockWood.EnumLogVariant.JUNGLE).set((IBlockState)BlockLeaves.CHECK_DECAY, (Comparable)Boolean.valueOf(false));
                gen = new WorldGenTrees(true, 4 + rand.nextInt(7), iblockdata1, iblockdata2, true);
                break;
            }
            case JUNGLE_BUSH: {
                IBlockData iblockdata1 = Blocks.LOG.getBlockData().set((IBlockState)BlockLog1.VARIANT, (Comparable)BlockWood.EnumLogVariant.JUNGLE);
                IBlockData iblockdata2 = Blocks.LEAVES.getBlockData().set((IBlockState)BlockLeaves1.VARIANT, (Comparable)BlockWood.EnumLogVariant.OAK).set((IBlockState)BlockLeaves.CHECK_DECAY, (Comparable)Boolean.valueOf(false));
                gen = new WorldGenGroundBush(iblockdata1, iblockdata2);
                break;
            }
            case RED_MUSHROOM: {
                gen = new WorldGenHugeMushroom(Blocks.RED_MUSHROOM_BLOCK);
                break;
            }
            case BROWN_MUSHROOM: {
                gen = new WorldGenHugeMushroom(Blocks.BROWN_MUSHROOM_BLOCK);
                break;
            }
            case SWAMP: {
                gen = new WorldGenSwampTree();
                break;
            }
            case ACACIA: {
                gen = new WorldGenAcaciaTree(true);
                break;
            }
            case DARK_OAK: {
                gen = new WorldGenForestTree(true);
                break;
            }
            case MEGA_REDWOOD: {
                gen = new WorldGenMegaTree(false, rand.nextBoolean());
                break;
            }
            case TALL_BIRCH: {
                gen = new WorldGenForest(true, true);
                break;
            }
            case CHORUS_PLANT: {
                BlockChorusFlower.a((net.minecraft.server.v1_12_R1.World)this.world, (BlockPosition)pos, (Random)rand, (int)8);
                return true;
            }
            default: {
                gen = new WorldGenTrees(true);
            }
        }
        return gen.generate((net.minecraft.server.v1_12_R1.World)this.world, rand, pos);
    }

    @Override
    public boolean generateTree(Location loc, TreeType type, BlockChangeDelegate delegate) {
        this.world.captureTreeGeneration = true;
        this.world.captureBlockStates = true;
        boolean grownTree = this.generateTree(loc, type);
        this.world.captureBlockStates = false;
        this.world.captureTreeGeneration = false;
        if (grownTree) {
            for (BlockState blockstate : this.world.capturedBlockStates) {
                int x = blockstate.getX();
                int y = blockstate.getY();
                int z = blockstate.getZ();
                BlockPosition position = new BlockPosition(x, y, z);
                IBlockData oldBlock = this.world.getType(position);
                int typeId = blockstate.getTypeId();
                byte data = blockstate.getRawData();
                int flag = ((CraftBlockState)blockstate).getFlag();
                delegate.setTypeIdAndData(x, y, z, typeId, data);
                IBlockData newBlock = this.world.getType(position);
                this.world.notifyAndUpdatePhysics(position, null, oldBlock, newBlock, flag);
            }
            this.world.capturedBlockStates.clear();
            return true;
        }
        this.world.capturedBlockStates.clear();
        return false;
    }

    public TileEntity getTileEntityAt(int x, int y, int z) {
        return this.world.getTileEntity(new BlockPosition(x, y, z));
    }

    @Override
    public String getName() {
        return this.world.worldData.getName();
    }

    @Deprecated
    public long getId() {
        return this.world.worldData.getSeed();
    }

    @Override
    public UUID getUID() {
        return this.world.getDataManager().getUUID();
    }

    public String toString() {
        return "CraftWorld{name=" + this.getName() + '}';
    }

    @Override
    public long getTime() {
        long time = this.getFullTime() % 24000L;
        if (time < 0L) {
            time += 24000L;
        }
        return time;
    }

    @Override
    public void setTime(long time) {
        long margin = (time - this.getFullTime()) % 24000L;
        if (margin < 0L) {
            margin += 24000L;
        }
        this.setFullTime(this.getFullTime() + margin);
    }

    @Override
    public long getFullTime() {
        return this.world.getDayTime();
    }

    @Override
    public void setFullTime(long time) {
        this.world.setDayTime(time);
        for (Player p : this.getPlayers()) {
            CraftPlayer cp = (CraftPlayer)p;
            if (cp.getHandle().playerConnection == null) continue;
            cp.getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutUpdateTime(cp.getHandle().world.getTime(), cp.getHandle().getPlayerTime(), cp.getHandle().world.getGameRules().getBoolean("doDaylightCycle")));
        }
    }

    @Override
    public boolean createExplosion(double x, double y, double z, float power) {
        return this.createExplosion(x, y, z, power, false, true);
    }

    @Override
    public boolean createExplosion(double x, double y, double z, float power, boolean setFire) {
        return this.createExplosion(x, y, z, power, setFire, true);
    }

    @Override
    public boolean createExplosion(double x, double y, double z, float power, boolean setFire, boolean breakBlocks) {
        return !this.world.createExplosion(null, (double)x, (double)y, (double)z, (float)power, (boolean)setFire, (boolean)breakBlocks).wasCanceled;
    }

    @Override
    public boolean createExplosion(Location loc, float power) {
        return this.createExplosion(loc, power, false);
    }

    @Override
    public boolean createExplosion(Location loc, float power, boolean setFire) {
        return this.createExplosion(loc.getX(), loc.getY(), loc.getZ(), power, setFire);
    }

    @Override
    public World.Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(World.Environment env) {
        if (this.environment != env) {
            this.environment = env;
            switch (env) {
                case NORMAL: {
                    this.world.worldProvider = new WorldProviderNormal();
                    break;
                }
                case NETHER: {
                    this.world.worldProvider = new WorldProviderHell();
                    break;
                }
                case THE_END: {
                    this.world.worldProvider = new WorldProviderTheEnd();
                }
            }
        }
    }

    @Override
    public org.bukkit.block.Block getBlockAt(Location location) {
        return this.getBlockAt(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Override
    public int getBlockTypeIdAt(Location location) {
        return this.getBlockTypeIdAt(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Override
    public int getHighestBlockYAt(Location location) {
        return this.getHighestBlockYAt(location.getBlockX(), location.getBlockZ());
    }

    @Override
    public Chunk getChunkAt(Location location) {
        return this.getChunkAt(location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    @Override
    public ChunkGenerator getGenerator() {
        return this.generator;
    }

    @Override
    public List<BlockPopulator> getPopulators() {
        return this.populators;
    }

    @Override
    public org.bukkit.block.Block getHighestBlockAt(int x, int z) {
        return this.getBlockAt(x, this.getHighestBlockYAt(x, z), z);
    }

    @Override
    public org.bukkit.block.Block getHighestBlockAt(Location location) {
        return this.getHighestBlockAt(location.getBlockX(), location.getBlockZ());
    }

    @Override
    public Biome getBiome(int x, int z) {
        return CraftBlock.biomeBaseToBiome(this.world.getBiome(new BlockPosition(x, 0, z)));
    }

    @Override
    public void setBiome(int x, int z, Biome bio) {
        net.minecraft.server.v1_12_R1.Chunk chunk;
        BiomeBase bb = CraftBlock.biomeToBiomeBase(bio);
        if (this.world.isLoaded(new BlockPosition(x, 0, z)) && (chunk = this.world.getChunkAtWorldCoords(new BlockPosition(x, 0, z))) != null) {
            byte[] biomevals = chunk.getBiomeIndex();
            biomevals[(z & 0xF) << 4 | x & 0xF] = (byte)BiomeBase.REGISTRY_ID.a((Object)bb);
            chunk.markDirty();
        }
    }

    @Override
    public double getTemperature(int x, int z) {
        return this.world.getBiome(new BlockPosition(x, 0, z)).getTemperature();
    }

    @Override
    public double getHumidity(int x, int z) {
        return this.world.getBiome(new BlockPosition(x, 0, z)).getHumidity();
    }

    @Override
    public List<Entity> getEntities() {
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (Object o : this.world.entityList) {
            net.minecraft.server.v1_12_R1.Entity mcEnt;
            CraftEntity bukkitEntity;
            if (!(o instanceof net.minecraft.server.v1_12_R1.Entity) || (bukkitEntity = (mcEnt = (net.minecraft.server.v1_12_R1.Entity)o).getBukkitEntity()) == null) continue;
            list.add(bukkitEntity);
        }
        return list;
    }

    @Override
    public List<LivingEntity> getLivingEntities() {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        for (Object o : this.world.entityList) {
            net.minecraft.server.v1_12_R1.Entity mcEnt;
            CraftEntity bukkitEntity;
            if (!(o instanceof net.minecraft.server.v1_12_R1.Entity) || (bukkitEntity = (mcEnt = (net.minecraft.server.v1_12_R1.Entity)o).getBukkitEntity()) == null || !(bukkitEntity instanceof LivingEntity)) continue;
            list.add((LivingEntity)((Object)bukkitEntity));
        }
        return list;
    }

    @Override
    @Deprecated
    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> ... classes) {
        return this.getEntitiesByClasses(classes);
    }

    @Override
    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> clazz) {
        ArrayList<CraftEntity> list = new ArrayList<CraftEntity>();
        for (Object entity : this.world.entityList) {
            Class<?> bukkitClass;
            CraftEntity bukkitEntity;
            if (!(entity instanceof net.minecraft.server.v1_12_R1.Entity) || (bukkitEntity = ((net.minecraft.server.v1_12_R1.Entity)entity).getBukkitEntity()) == null || !clazz.isAssignableFrom(bukkitClass = bukkitEntity.getClass())) continue;
            list.add(bukkitEntity);
        }
        return list;
    }

    @Override
    public Collection<Entity> getEntitiesByClasses(Class<?> ... classes) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        block0: for (Object entity : this.world.entityList) {
            CraftEntity bukkitEntity;
            if (!(entity instanceof net.minecraft.server.v1_12_R1.Entity) || (bukkitEntity = ((net.minecraft.server.v1_12_R1.Entity)entity).getBukkitEntity()) == null) continue;
            Class<?> bukkitClass = bukkitEntity.getClass();
            Class<?>[] classArray = classes;
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> clazz = classArray[n2];
                if (clazz.isAssignableFrom(bukkitClass)) {
                    list.add(bukkitEntity);
                    continue block0;
                }
                ++n2;
            }
        }
        return list;
    }

    @Override
    public Collection<Entity> getNearbyEntities(Location location, double x, double y, double z) {
        if (location == null || !location.getWorld().equals(this)) {
            return Collections.emptyList();
        }
        AxisAlignedBB bb = new AxisAlignedBB(location.getX() - x, location.getY() - y, location.getZ() - z, location.getX() + x, location.getY() + y, location.getZ() + z);
        List entityList = this.getHandle().getEntities(null, bb, null);
        ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(entityList.size());
        for (Object entity : entityList) {
            bukkitEntityList.add(((net.minecraft.server.v1_12_R1.Entity)entity).getBukkitEntity());
        }
        return bukkitEntityList;
    }

    @Override
    public List<Player> getPlayers() {
        ArrayList<Player> list = new ArrayList<Player>(this.world.players.size());
        for (EntityHuman human : this.world.players) {
            CraftHumanEntity bukkitEntity = human.getBukkitEntity();
            if (bukkitEntity == null || !(bukkitEntity instanceof Player)) continue;
            list.add((Player)((Object)bukkitEntity));
        }
        return list;
    }

    @Override
    public void save() {
        this.save(true);
    }

    public void save(boolean forceSave) {
        this.server.checkSaveState();
        try {
            boolean oldSave = this.world.savingDisabled;
            this.world.savingDisabled = false;
            this.world.save(forceSave, null);
            this.world.savingDisabled = oldSave;
        }
        catch (ExceptionWorldConflict ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean isAutoSave() {
        return !this.world.savingDisabled;
    }

    @Override
    public void setAutoSave(boolean value) {
        this.world.savingDisabled = !value;
    }

    @Override
    public void setDifficulty(Difficulty difficulty) {
        this.getHandle().worldData.setDifficulty(EnumDifficulty.getById((int)difficulty.getValue()));
    }

    @Override
    public Difficulty getDifficulty() {
        return Difficulty.getByValue(this.getHandle().getDifficulty().ordinal());
    }

    public BlockMetadataStore getBlockMetadata() {
        return this.blockMetadata;
    }

    @Override
    public boolean hasStorm() {
        return this.world.worldData.hasStorm();
    }

    @Override
    public void setStorm(boolean hasStorm) {
        this.world.worldData.setStorm(hasStorm);
        this.setWeatherDuration(0);
    }

    @Override
    public int getWeatherDuration() {
        return this.world.worldData.getWeatherDuration();
    }

    @Override
    public void setWeatherDuration(int duration) {
        this.world.worldData.setWeatherDuration(duration);
    }

    @Override
    public boolean isThundering() {
        return this.world.worldData.isThundering();
    }

    @Override
    public void setThundering(boolean thundering) {
        this.world.worldData.setThundering(thundering);
        this.setThunderDuration(0);
    }

    @Override
    public int getThunderDuration() {
        return this.world.worldData.getThunderDuration();
    }

    @Override
    public void setThunderDuration(int duration) {
        this.world.worldData.setThunderDuration(duration);
    }

    @Override
    public long getSeed() {
        return this.world.worldData.getSeed();
    }

    @Override
    public boolean getPVP() {
        return this.world.pvpMode;
    }

    @Override
    public void setPVP(boolean pvp) {
        this.world.pvpMode = pvp;
    }

    public void playEffect(Player player, Effect effect, int data) {
        this.playEffect(player.getLocation(), effect, data, 0);
    }

    @Override
    public void playEffect(Location location, Effect effect, int data) {
        this.playEffect(location, effect, data, 64);
    }

    @Override
    public <T> void playEffect(Location loc, Effect effect, T data) {
        this.playEffect(loc, effect, data, 64);
    }

    @Override
    public <T> void playEffect(Location loc, Effect effect, T data, int radius) {
        if (data != null) {
            Validate.isTrue((effect.getData() != null && effect.getData().isAssignableFrom(data.getClass()) ? 1 : 0) != 0, (String)"Wrong kind of data for this effect!");
        } else {
            Validate.isTrue((effect.getData() == null ? 1 : 0) != 0, (String)"Wrong kind of data for this effect!");
        }
        if (data != null && data.getClass().equals(MaterialData.class)) {
            MaterialData materialData = (MaterialData)data;
            Validate.isTrue((boolean)materialData.getItemType().isBlock(), (String)"Material must be block");
            this.spigot().playEffect(loc, effect, materialData.getItemType().getId(), materialData.getData(), 0.0f, 0.0f, 0.0f, 1.0f, 1, radius);
        } else {
            int dataValue = data == null ? 0 : CraftEffect.getDataValue(effect, data);
            this.playEffect(loc, effect, dataValue, radius);
        }
    }

    @Override
    public void playEffect(Location location, Effect effect, int data, int radius) {
        this.spigot().playEffect(location, effect, data, 0, 0.0f, 0.0f, 0.0f, 1.0f, 1, radius);
    }

    @Override
    public <T extends Entity> T spawn(Location location, Class<T> clazz) throws IllegalArgumentException {
        return this.spawn(location, clazz, null, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    @Override
    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<T> function) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    @Override
    public FallingBlock spawnFallingBlock(Location location, MaterialData data) throws IllegalArgumentException {
        Validate.notNull((Object)data, (String)"MaterialData cannot be null");
        return this.spawnFallingBlock(location, data.getItemType(), data.getData());
    }

    @Override
    public FallingBlock spawnFallingBlock(Location location, Material material, byte data) throws IllegalArgumentException {
        Validate.notNull((Object)location, (String)"Location cannot be null");
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        Validate.isTrue((boolean)material.isBlock(), (String)"Material must be a block");
        EntityFallingBlock entity = new EntityFallingBlock((net.minecraft.server.v1_12_R1.World)this.world, location.getX(), location.getY(), location.getZ(), CraftMagicNumbers.getBlock(material).fromLegacyData((int)data));
        entity.ticksLived = 1;
        this.world.addEntity((net.minecraft.server.v1_12_R1.Entity)entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (FallingBlock)((Object)entity.getBukkitEntity());
    }

    @Override
    public FallingBlock spawnFallingBlock(Location location, int blockId, byte blockData) throws IllegalArgumentException {
        return this.spawnFallingBlock(location, Material.getMaterial(blockId), blockData);
    }

    public net.minecraft.server.v1_12_R1.Entity createEntity(Location location, Class<? extends Entity> clazz) throws IllegalArgumentException {
        if (location == null || clazz == null) {
            throw new IllegalArgumentException("Location or entity class cannot be null");
        }
        Object entity = null;
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        float pitch = location.getPitch();
        float yaw = location.getYaw();
        if (Boat.class.isAssignableFrom(clazz)) {
            entity = new EntityBoat((net.minecraft.server.v1_12_R1.World)this.world, x, y, z);
            entity.setPositionRotation(x, y, z, yaw, pitch);
        } else if (FallingBlock.class.isAssignableFrom(clazz)) {
            entity = new EntityFallingBlock((net.minecraft.server.v1_12_R1.World)this.world, x, y, z, this.world.getType(new BlockPosition(x, y, z)));
        } else if (Projectile.class.isAssignableFrom(clazz)) {
            if (Snowball.class.isAssignableFrom(clazz)) {
                entity = new EntitySnowball((net.minecraft.server.v1_12_R1.World)this.world, x, y, z);
            } else if (Egg.class.isAssignableFrom(clazz)) {
                entity = new EntityEgg((net.minecraft.server.v1_12_R1.World)this.world, x, y, z);
            } else if (Arrow.class.isAssignableFrom(clazz)) {
                if (TippedArrow.class.isAssignableFrom(clazz)) {
                    entity = new EntityTippedArrow((net.minecraft.server.v1_12_R1.World)this.world);
                    ((EntityTippedArrow)entity).setType(CraftPotionUtil.fromBukkit(new PotionData(PotionType.WATER, false, false)));
                } else {
                    entity = SpectralArrow.class.isAssignableFrom(clazz) ? new EntitySpectralArrow((net.minecraft.server.v1_12_R1.World)this.world) : new EntityTippedArrow((net.minecraft.server.v1_12_R1.World)this.world);
                }
                entity.setPositionRotation(x, y, z, 0.0f, 0.0f);
            } else if (ThrownExpBottle.class.isAssignableFrom(clazz)) {
                entity = new EntityThrownExpBottle((net.minecraft.server.v1_12_R1.World)this.world);
                entity.setPositionRotation(x, y, z, 0.0f, 0.0f);
            } else if (EnderPearl.class.isAssignableFrom(clazz)) {
                entity = new EntityEnderPearl((net.minecraft.server.v1_12_R1.World)this.world);
                entity.setPositionRotation(x, y, z, 0.0f, 0.0f);
            } else if (ThrownPotion.class.isAssignableFrom(clazz)) {
                entity = LingeringPotion.class.isAssignableFrom(clazz) ? new EntityPotion((net.minecraft.server.v1_12_R1.World)this.world, x, y, z, CraftItemStack.asNMSCopy(new ItemStack(Material.LINGERING_POTION, 1))) : new EntityPotion((net.minecraft.server.v1_12_R1.World)this.world, x, y, z, CraftItemStack.asNMSCopy(new ItemStack(Material.SPLASH_POTION, 1)));
            } else if (Fireball.class.isAssignableFrom(clazz)) {
                entity = SmallFireball.class.isAssignableFrom(clazz) ? new EntitySmallFireball((net.minecraft.server.v1_12_R1.World)this.world) : (WitherSkull.class.isAssignableFrom(clazz) ? new EntityWitherSkull((net.minecraft.server.v1_12_R1.World)this.world) : (DragonFireball.class.isAssignableFrom(clazz) ? new EntityDragonFireball((net.minecraft.server.v1_12_R1.World)this.world) : new EntityLargeFireball((net.minecraft.server.v1_12_R1.World)this.world)));
                entity.setPositionRotation(x, y, z, yaw, pitch);
                Vector direction = location.getDirection().multiply(10);
                ((EntityFireball)entity).setDirection(direction.getX(), direction.getY(), direction.getZ());
            } else if (ShulkerBullet.class.isAssignableFrom(clazz)) {
                entity = new EntityShulkerBullet((net.minecraft.server.v1_12_R1.World)this.world);
                entity.setPositionRotation(x, y, z, yaw, pitch);
            } else if (LlamaSpit.class.isAssignableFrom(clazz)) {
                entity = new EntityLlamaSpit((net.minecraft.server.v1_12_R1.World)this.world);
                entity.setPositionRotation(x, y, z, yaw, pitch);
            }
        } else if (Minecart.class.isAssignableFrom(clazz)) {
            entity = PoweredMinecart.class.isAssignableFrom(clazz) ? new EntityMinecartFurnace((net.minecraft.server.v1_12_R1.World)this.world, x, y, z) : (StorageMinecart.class.isAssignableFrom(clazz) ? new EntityMinecartChest((net.minecraft.server.v1_12_R1.World)this.world, x, y, z) : (ExplosiveMinecart.class.isAssignableFrom(clazz) ? new EntityMinecartTNT((net.minecraft.server.v1_12_R1.World)this.world, x, y, z) : (HopperMinecart.class.isAssignableFrom(clazz) ? new EntityMinecartHopper((net.minecraft.server.v1_12_R1.World)this.world, x, y, z) : (SpawnerMinecart.class.isAssignableFrom(clazz) ? new EntityMinecartMobSpawner((net.minecraft.server.v1_12_R1.World)this.world, x, y, z) : (CommandMinecart.class.isAssignableFrom(clazz) ? new EntityMinecartCommandBlock((net.minecraft.server.v1_12_R1.World)this.world, x, y, z) : new EntityMinecartRideable((net.minecraft.server.v1_12_R1.World)this.world, x, y, z))))));
        } else if (EnderSignal.class.isAssignableFrom(clazz)) {
            entity = new EntityEnderSignal((net.minecraft.server.v1_12_R1.World)this.world, x, y, z);
        } else if (EnderCrystal.class.isAssignableFrom(clazz)) {
            entity = new EntityEnderCrystal((net.minecraft.server.v1_12_R1.World)this.world);
            entity.setPositionRotation(x, y, z, 0.0f, 0.0f);
        } else if (LivingEntity.class.isAssignableFrom(clazz)) {
            if (Chicken.class.isAssignableFrom(clazz)) {
                entity = new EntityChicken((net.minecraft.server.v1_12_R1.World)this.world);
            } else if (Cow.class.isAssignableFrom(clazz)) {
                entity = MushroomCow.class.isAssignableFrom(clazz) ? new EntityMushroomCow((net.minecraft.server.v1_12_R1.World)this.world) : new EntityCow((net.minecraft.server.v1_12_R1.World)this.world);
            } else if (Golem.class.isAssignableFrom(clazz)) {
                if (Snowman.class.isAssignableFrom(clazz)) {
                    entity = new EntitySnowman((net.minecraft.server.v1_12_R1.World)this.world);
                } else if (IronGolem.class.isAssignableFrom(clazz)) {
                    entity = new EntityIronGolem((net.minecraft.server.v1_12_R1.World)this.world);
                } else if (Shulker.class.isAssignableFrom(clazz)) {
                    entity = new EntityShulker((net.minecraft.server.v1_12_R1.World)this.world);
                }
            } else if (Creeper.class.isAssignableFrom(clazz)) {
                entity = new EntityCreeper((net.minecraft.server.v1_12_R1.World)this.world);
            } else if (Ghast.class.isAssignableFrom(clazz)) {
                entity = new EntityGhast((net.minecraft.server.v1_12_R1.World)this.world);
            } else if (Pig.class.isAssignableFrom(clazz)) {
                entity = new EntityPig((net.minecraft.server.v1_12_R1.World)this.world);
            } else if (!Player.class.isAssignableFrom(clazz)) {
                if (Sheep.class.isAssignableFrom(clazz)) {
                    entity = new EntitySheep((net.minecraft.server.v1_12_R1.World)this.world);
                } else if (AbstractHorse.class.isAssignableFrom(clazz)) {
                    if (ChestedHorse.class.isAssignableFrom(clazz)) {
                        if (Donkey.class.isAssignableFrom(clazz)) {
                            entity = new EntityHorseDonkey((net.minecraft.server.v1_12_R1.World)this.world);
                        } else if (Mule.class.isAssignableFrom(clazz)) {
                            entity = new EntityHorseMule((net.minecraft.server.v1_12_R1.World)this.world);
                        } else if (Llama.class.isAssignableFrom(clazz)) {
                            entity = new EntityLlama((net.minecraft.server.v1_12_R1.World)this.world);
                        }
                    } else {
                        entity = SkeletonHorse.class.isAssignableFrom(clazz) ? new EntityHorseSkeleton((net.minecraft.server.v1_12_R1.World)this.world) : (ZombieHorse.class.isAssignableFrom(clazz) ? new EntityHorseZombie((net.minecraft.server.v1_12_R1.World)this.world) : new EntityHorse((net.minecraft.server.v1_12_R1.World)this.world));
                    }
                } else if (Skeleton.class.isAssignableFrom(clazz)) {
                    entity = Stray.class.isAssignableFrom(clazz) ? new EntitySkeletonStray((net.minecraft.server.v1_12_R1.World)this.world) : (WitherSkeleton.class.isAssignableFrom(clazz) ? new EntitySkeletonWither((net.minecraft.server.v1_12_R1.World)this.world) : new EntitySkeleton((net.minecraft.server.v1_12_R1.World)this.world));
                } else if (Slime.class.isAssignableFrom(clazz)) {
                    entity = MagmaCube.class.isAssignableFrom(clazz) ? new EntityMagmaCube((net.minecraft.server.v1_12_R1.World)this.world) : new EntitySlime((net.minecraft.server.v1_12_R1.World)this.world);
                } else if (Spider.class.isAssignableFrom(clazz)) {
                    entity = CaveSpider.class.isAssignableFrom(clazz) ? new EntityCaveSpider((net.minecraft.server.v1_12_R1.World)this.world) : new EntitySpider((net.minecraft.server.v1_12_R1.World)this.world);
                } else if (Squid.class.isAssignableFrom(clazz)) {
                    entity = new EntitySquid((net.minecraft.server.v1_12_R1.World)this.world);
                } else if (Tameable.class.isAssignableFrom(clazz)) {
                    if (Wolf.class.isAssignableFrom(clazz)) {
                        entity = new EntityWolf((net.minecraft.server.v1_12_R1.World)this.world);
                    } else if (Ocelot.class.isAssignableFrom(clazz)) {
                        entity = new EntityOcelot((net.minecraft.server.v1_12_R1.World)this.world);
                    } else if (Parrot.class.isAssignableFrom(clazz)) {
                        entity = new EntityParrot((net.minecraft.server.v1_12_R1.World)this.world);
                    }
                } else if (PigZombie.class.isAssignableFrom(clazz)) {
                    entity = new EntityPigZombie((net.minecraft.server.v1_12_R1.World)this.world);
                } else if (Zombie.class.isAssignableFrom(clazz)) {
                    entity = Husk.class.isAssignableFrom(clazz) ? new EntityZombieHusk((net.minecraft.server.v1_12_R1.World)this.world) : (ZombieVillager.class.isAssignableFrom(clazz) ? new EntityZombieVillager((net.minecraft.server.v1_12_R1.World)this.world) : new EntityZombie((net.minecraft.server.v1_12_R1.World)this.world));
                } else if (Giant.class.isAssignableFrom(clazz)) {
                    entity = new EntityGiantZombie((net.minecraft.server.v1_12_R1.World)this.world);
                } else if (Silverfish.class.isAssignableFrom(clazz)) {
                    entity = new EntitySilverfish((net.minecraft.server.v1_12_R1.World)this.world);
                } else if (Enderman.class.isAssignableFrom(clazz)) {
                    entity = new EntityEnderman((net.minecraft.server.v1_12_R1.World)this.world);
                } else if (Blaze.class.isAssignableFrom(clazz)) {
                    entity = new EntityBlaze((net.minecraft.server.v1_12_R1.World)this.world);
                } else if (Villager.class.isAssignableFrom(clazz)) {
                    entity = new EntityVillager((net.minecraft.server.v1_12_R1.World)this.world);
                } else if (Witch.class.isAssignableFrom(clazz)) {
                    entity = new EntityWitch((net.minecraft.server.v1_12_R1.World)this.world);
                } else if (Wither.class.isAssignableFrom(clazz)) {
                    entity = new EntityWither((net.minecraft.server.v1_12_R1.World)this.world);
                } else if (ComplexLivingEntity.class.isAssignableFrom(clazz)) {
                    if (EnderDragon.class.isAssignableFrom(clazz)) {
                        entity = new EntityEnderDragon((net.minecraft.server.v1_12_R1.World)this.world);
                    }
                } else if (Ambient.class.isAssignableFrom(clazz)) {
                    if (Bat.class.isAssignableFrom(clazz)) {
                        entity = new EntityBat((net.minecraft.server.v1_12_R1.World)this.world);
                    }
                } else if (Rabbit.class.isAssignableFrom(clazz)) {
                    entity = new EntityRabbit((net.minecraft.server.v1_12_R1.World)this.world);
                } else if (Endermite.class.isAssignableFrom(clazz)) {
                    entity = new EntityEndermite((net.minecraft.server.v1_12_R1.World)this.world);
                } else if (Guardian.class.isAssignableFrom(clazz)) {
                    entity = ElderGuardian.class.isAssignableFrom(clazz) ? new EntityGuardianElder((net.minecraft.server.v1_12_R1.World)this.world) : new EntityGuardian((net.minecraft.server.v1_12_R1.World)this.world);
                } else if (ArmorStand.class.isAssignableFrom(clazz)) {
                    entity = new EntityArmorStand((net.minecraft.server.v1_12_R1.World)this.world, x, y, z);
                } else if (PolarBear.class.isAssignableFrom(clazz)) {
                    entity = new EntityPolarBear((net.minecraft.server.v1_12_R1.World)this.world);
                } else if (Vex.class.isAssignableFrom(clazz)) {
                    entity = new EntityVex((net.minecraft.server.v1_12_R1.World)this.world);
                } else if (Illager.class.isAssignableFrom(clazz)) {
                    if (Spellcaster.class.isAssignableFrom(clazz)) {
                        if (Evoker.class.isAssignableFrom(clazz)) {
                            entity = new EntityEvoker((net.minecraft.server.v1_12_R1.World)this.world);
                        } else if (Illusioner.class.isAssignableFrom(clazz)) {
                            entity = new EntityIllagerIllusioner((net.minecraft.server.v1_12_R1.World)this.world);
                        }
                    } else if (Vindicator.class.isAssignableFrom(clazz)) {
                        entity = new EntityVindicator((net.minecraft.server.v1_12_R1.World)this.world);
                    }
                }
            }
            if (entity != null) {
                entity.setLocation(x, y, z, yaw, pitch);
                entity.setHeadRotation(yaw);
            }
        } else if (Hanging.class.isAssignableFrom(clazz)) {
            BlockFace dir;
            org.bukkit.block.Block block = this.getBlockAt(location);
            BlockFace face = BlockFace.SELF;
            int width = 16;
            int height = 16;
            if (ItemFrame.class.isAssignableFrom(clazz)) {
                width = 12;
                height = 12;
            } else if (LeashHitch.class.isAssignableFrom(clazz)) {
                width = 9;
                height = 9;
            }
            BlockFace[] faces = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH};
            BlockPosition pos = new BlockPosition((int)x, (int)y, (int)z);
            BlockFace[] blockFaceArray = faces;
            int n = faces.length;
            int n2 = 0;
            while (n2 < n) {
                dir = blockFaceArray[n2];
                Block nmsBlock = CraftMagicNumbers.getBlock(block.getRelative(dir));
                if (nmsBlock.getBlockData().getMaterial().isBuildable() || BlockDiodeAbstract.isDiode((IBlockData)nmsBlock.getBlockData())) {
                    boolean taken = false;
                    AxisAlignedBB bb = EntityHanging.calculateBoundingBox(null, (BlockPosition)pos, (EnumDirection)CraftBlock.blockFaceToNotch(dir).opposite(), (int)width, (int)height);
                    List list = this.world.getEntities(null, bb);
                    Iterator it = list.iterator();
                    while (!taken && it.hasNext()) {
                        net.minecraft.server.v1_12_R1.Entity e = (net.minecraft.server.v1_12_R1.Entity)it.next();
                        if (!(e instanceof EntityHanging)) continue;
                        taken = true;
                    }
                    if (!taken) {
                        face = dir;
                        break;
                    }
                }
                ++n2;
            }
            if (LeashHitch.class.isAssignableFrom(clazz)) {
                entity = new EntityLeash((net.minecraft.server.v1_12_R1.World)this.world, new BlockPosition((int)x, (int)y, (int)z));
                entity.attachedToPlayer = true;
            } else {
                Preconditions.checkArgument((face != BlockFace.SELF ? 1 : 0) != 0, (String)"Cannot spawn hanging entity for %s at %s (no free face)", (Object)clazz.getName(), (Object)location);
                dir = CraftBlock.blockFaceToNotch(face).opposite();
                if (Painting.class.isAssignableFrom(clazz)) {
                    entity = new EntityPainting((net.minecraft.server.v1_12_R1.World)this.world, new BlockPosition((int)x, (int)y, (int)z), (EnumDirection)dir);
                } else if (ItemFrame.class.isAssignableFrom(clazz)) {
                    entity = new EntityItemFrame((net.minecraft.server.v1_12_R1.World)this.world, new BlockPosition((int)x, (int)y, (int)z), (EnumDirection)dir);
                }
            }
            if (entity != null && !((EntityHanging)entity).survives()) {
                throw new IllegalArgumentException("Cannot spawn hanging entity for " + clazz.getName() + " at " + location);
            }
        } else if (TNTPrimed.class.isAssignableFrom(clazz)) {
            entity = new EntityTNTPrimed((net.minecraft.server.v1_12_R1.World)this.world, x, y, z, null);
        } else if (ExperienceOrb.class.isAssignableFrom(clazz)) {
            entity = new EntityExperienceOrb((net.minecraft.server.v1_12_R1.World)this.world, x, y, z, 0);
        } else if (Weather.class.isAssignableFrom(clazz)) {
            if (LightningStrike.class.isAssignableFrom(clazz)) {
                entity = new EntityLightning((net.minecraft.server.v1_12_R1.World)this.world, x, y, z, false);
            }
        } else if (Firework.class.isAssignableFrom(clazz)) {
            entity = new EntityFireworks((net.minecraft.server.v1_12_R1.World)this.world, x, y, z, net.minecraft.server.v1_12_R1.ItemStack.a);
        } else if (AreaEffectCloud.class.isAssignableFrom(clazz)) {
            entity = new EntityAreaEffectCloud((net.minecraft.server.v1_12_R1.World)this.world, x, y, z);
        } else if (EvokerFangs.class.isAssignableFrom(clazz)) {
            entity = new EntityEvokerFangs((net.minecraft.server.v1_12_R1.World)this.world, x, y, z, (float)Math.toRadians(yaw), 0, null);
        }
        if (entity != null) {
            if (entity instanceof EntityOcelot) {
                ((EntityOcelot)entity).spawnBonus = false;
            }
            return entity;
        }
        throw new IllegalArgumentException("Cannot spawn an entity for " + clazz.getName());
    }

    public <T extends Entity> T addEntity(net.minecraft.server.v1_12_R1.Entity entity, CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        return this.addEntity(entity, reason, null);
    }

    public <T extends Entity> T addEntity(net.minecraft.server.v1_12_R1.Entity entity, CreatureSpawnEvent.SpawnReason reason, Consumer<T> function) throws IllegalArgumentException {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Cannot spawn null entity");
        if (entity instanceof EntityInsentient) {
            ((EntityInsentient)entity).prepare(this.getHandle().D(new BlockPosition(entity)), null);
        }
        if (function != null) {
            function.accept(entity.getBukkitEntity());
        }
        this.world.addEntity(entity, reason);
        return (T)entity.getBukkitEntity();
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<T> function, CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        net.minecraft.server.v1_12_R1.Entity entity = this.createEntity(location, clazz);
        return this.addEntity(entity, reason, function);
    }

    @Override
    public ChunkSnapshot getEmptyChunkSnapshot(int x, int z, boolean includeBiome, boolean includeBiomeTempRain) {
        return CraftChunk.getEmptyChunkSnapshot(x, z, this, includeBiome, includeBiomeTempRain);
    }

    @Override
    public void setSpawnFlags(boolean allowMonsters, boolean allowAnimals) {
        this.world.setSpawnFlags(allowMonsters, allowAnimals);
    }

    @Override
    public boolean getAllowAnimals() {
        return this.world.allowAnimals;
    }

    @Override
    public boolean getAllowMonsters() {
        return this.world.allowMonsters;
    }

    @Override
    public int getMaxHeight() {
        return this.world.getHeight();
    }

    @Override
    public int getSeaLevel() {
        return this.world.getSeaLevel();
    }

    @Override
    public boolean getKeepSpawnInMemory() {
        return this.world.keepSpawnInMemory;
    }

    @Override
    public void setKeepSpawnInMemory(boolean keepLoaded) {
        this.world.keepSpawnInMemory = keepLoaded;
        BlockPosition chunkcoordinates = this.world.getSpawn();
        int chunkCoordX = chunkcoordinates.getX() >> 4;
        int chunkCoordZ = chunkcoordinates.getZ() >> 4;
        int x = -12;
        while (x <= 12) {
            int z = -12;
            while (z <= 12) {
                if (keepLoaded) {
                    this.loadChunk(chunkCoordX + x, chunkCoordZ + z);
                } else if (this.isChunkLoaded(chunkCoordX + x, chunkCoordZ + z)) {
                    this.unloadChunk(chunkCoordX + x, chunkCoordZ + z);
                }
                ++z;
            }
            ++x;
        }
    }

    public int hashCode() {
        return this.getUID().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftWorld other = (CraftWorld)obj;
        return this.getUID() == other.getUID();
    }

    @Override
    public File getWorldFolder() {
        return ((WorldNBTStorage)this.world.getDataManager()).getDirectory();
    }

    @Override
    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage(this.server.getMessenger(), source, channel, message);
        for (Player player : this.getPlayers()) {
            player.sendPluginMessage(source, channel, message);
        }
    }

    @Override
    public Set<String> getListeningPluginChannels() {
        HashSet<String> result = new HashSet<String>();
        for (Player player : this.getPlayers()) {
            result.addAll(player.getListeningPluginChannels());
        }
        return result;
    }

    @Override
    public WorldType getWorldType() {
        return WorldType.getByName(this.world.getWorldData().getType().name());
    }

    @Override
    public boolean canGenerateStructures() {
        return this.world.getWorldData().shouldGenerateMapFeatures();
    }

    @Override
    public long getTicksPerAnimalSpawns() {
        return this.world.ticksPerAnimalSpawns;
    }

    @Override
    public void setTicksPerAnimalSpawns(int ticksPerAnimalSpawns) {
        this.world.ticksPerAnimalSpawns = ticksPerAnimalSpawns;
    }

    @Override
    public long getTicksPerMonsterSpawns() {
        return this.world.ticksPerMonsterSpawns;
    }

    @Override
    public void setTicksPerMonsterSpawns(int ticksPerMonsterSpawns) {
        this.world.ticksPerMonsterSpawns = ticksPerMonsterSpawns;
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getWorldMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getWorldMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getWorldMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getWorldMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public int getMonsterSpawnLimit() {
        if (this.monsterSpawn < 0) {
            return this.server.getMonsterSpawnLimit();
        }
        return this.monsterSpawn;
    }

    @Override
    public void setMonsterSpawnLimit(int limit) {
        this.monsterSpawn = limit;
    }

    @Override
    public int getAnimalSpawnLimit() {
        if (this.animalSpawn < 0) {
            return this.server.getAnimalSpawnLimit();
        }
        return this.animalSpawn;
    }

    @Override
    public void setAnimalSpawnLimit(int limit) {
        this.animalSpawn = limit;
    }

    @Override
    public int getWaterAnimalSpawnLimit() {
        if (this.waterAnimalSpawn < 0) {
            return this.server.getWaterAnimalSpawnLimit();
        }
        return this.waterAnimalSpawn;
    }

    @Override
    public void setWaterAnimalSpawnLimit(int limit) {
        this.waterAnimalSpawn = limit;
    }

    @Override
    public int getAmbientSpawnLimit() {
        if (this.ambientSpawn < 0) {
            return this.server.getAmbientSpawnLimit();
        }
        return this.ambientSpawn;
    }

    @Override
    public void setAmbientSpawnLimit(int limit) {
        this.ambientSpawn = limit;
    }

    @Override
    public void playSound(Location loc, Sound sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    @Override
    public void playSound(Location loc, String sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    @Override
    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch) {
        if (loc == null || sound == null || category == null) {
            return;
        }
        double x = loc.getX();
        double y = loc.getY();
        double z = loc.getZ();
        this.getHandle().a(null, x, y, z, CraftSound.getSoundEffect(CraftSound.getSound(sound)), net.minecraft.server.v1_12_R1.SoundCategory.valueOf((String)category.name()), volume, pitch);
    }

    @Override
    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch) {
        if (loc == null || sound == null || category == null) {
            return;
        }
        double x = loc.getX();
        double y = loc.getY();
        double z = loc.getZ();
        PacketPlayOutCustomSoundEffect packet = new PacketPlayOutCustomSoundEffect(sound, net.minecraft.server.v1_12_R1.SoundCategory.valueOf((String)category.name()), x, y, z, volume, pitch);
        this.world.getMinecraftServer().getPlayerList().sendPacketNearby(null, x, y, z, volume > 1.0f ? (double)(16.0f * volume) : 16.0, this.world.dimension, (Packet)packet);
    }

    @Override
    public String getGameRuleValue(String rule) {
        return this.getHandle().getGameRules().get(rule);
    }

    @Override
    public boolean setGameRuleValue(String rule, String value) {
        if (rule == null || value == null) {
            return false;
        }
        if (!this.isGameRule(rule)) {
            return false;
        }
        this.getHandle().getGameRules().set(rule, value);
        return true;
    }

    @Override
    public String[] getGameRules() {
        return this.getHandle().getGameRules().getGameRules();
    }

    @Override
    public boolean isGameRule(String rule) {
        return this.getHandle().getGameRules().contains(rule);
    }

    @Override
    public WorldBorder getWorldBorder() {
        if (this.worldBorder == null) {
            this.worldBorder = new CraftWorldBorder(this);
        }
        return this.worldBorder;
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count);
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y, double z, int count) {
        this.spawnParticle(particle, x, y, z, count, null);
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, data);
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, T data) {
        this.spawnParticle(particle, x, y, z, count, 0.0, 0.0, 0.0, data);
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ);
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, null);
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, 1.0, data);
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra);
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, null);
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data);
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        if (data != null && !particle.getDataType().isInstance(data)) {
            throw new IllegalArgumentException("data should be " + particle.getDataType() + " got " + data.getClass());
        }
        this.getHandle().sendParticles(null, CraftParticle.toNMS(particle), true, x, y, z, count, offsetX, offsetY, offsetZ, extra, CraftParticle.toData(particle, data));
    }

    public void processChunkGC() {
        ++this.chunkGCTickCount;
        if (this.chunkLoadCount >= this.server.chunkGCLoadThresh && this.server.chunkGCLoadThresh > 0) {
            this.chunkLoadCount = 0;
        } else if (this.chunkGCTickCount >= this.server.chunkGCPeriod && this.server.chunkGCPeriod > 0) {
            this.chunkGCTickCount = 0;
        } else {
            return;
        }
        ChunkProviderServer cps = this.world.getChunkProviderServer();
        for (net.minecraft.server.v1_12_R1.Chunk chunk : cps.chunks.values()) {
            if (this.isChunkInUse(chunk.locX, chunk.locZ) || cps.unloadQueue.contains(ChunkCoordIntPair.a((int)chunk.locX, (int)chunk.locZ))) continue;
            cps.unload(chunk);
        }
    }

    @Override
    public World.Spigot spigot() {
        return this.spigot;
    }
}

