/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.v1_12_R1.EnumColor;
import net.minecraft.server.v1_12_R1.NBTBase;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import net.minecraft.server.v1_12_R1.NBTTagList;
import net.minecraft.server.v1_12_R1.TileEntityBanner;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBlockEntityState;

public class CraftBanner
extends CraftBlockEntityState<TileEntityBanner>
implements Banner {
    private DyeColor base;
    private List<Pattern> patterns;

    public CraftBanner(Block block) {
        super(block, TileEntityBanner.class);
    }

    public CraftBanner(Material material, TileEntityBanner te) {
        super(material, te);
    }

    @Override
    public void load(TileEntityBanner banner) {
        super.load(banner);
        this.base = DyeColor.getByDyeData((byte)banner.color.getInvColorIndex());
        this.patterns = new ArrayList<Pattern>();
        if (banner.patterns != null) {
            int i = 0;
            while (i < banner.patterns.size()) {
                NBTTagCompound p = banner.patterns.get(i);
                this.patterns.add(new Pattern(DyeColor.getByDyeData((byte)p.getInt("Color")), PatternType.getByIdentifier(p.getString("Pattern"))));
                ++i;
            }
        }
    }

    @Override
    public DyeColor getBaseColor() {
        return this.base;
    }

    @Override
    public void setBaseColor(DyeColor color) {
        this.base = color;
    }

    @Override
    public List<Pattern> getPatterns() {
        return new ArrayList<Pattern>(this.patterns);
    }

    @Override
    public void setPatterns(List<Pattern> patterns) {
        this.patterns = new ArrayList<Pattern>(patterns);
    }

    @Override
    public void addPattern(Pattern pattern) {
        this.patterns.add(pattern);
    }

    @Override
    public Pattern getPattern(int i) {
        return this.patterns.get(i);
    }

    @Override
    public Pattern removePattern(int i) {
        return this.patterns.remove(i);
    }

    @Override
    public void setPattern(int i, Pattern pattern) {
        this.patterns.set(i, pattern);
    }

    @Override
    public int numberOfPatterns() {
        return this.patterns.size();
    }

    @Override
    public void applyTo(TileEntityBanner banner) {
        super.applyTo(banner);
        banner.color = EnumColor.fromInvColorIndex((int)this.base.getDyeData());
        NBTTagList newPatterns = new NBTTagList();
        for (Pattern p : this.patterns) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.setInt("Color", (int)p.getColor().getDyeData());
            compound.setString("Pattern", p.getPattern().getIdentifier());
            newPatterns.add((NBTBase)compound);
        }
        banner.patterns = newPatterns;
    }
}

