/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.block;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.server.v1_12_R1.BiomeBase;
import net.minecraft.server.v1_12_R1.BlockCocoa;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.BlockRedstoneWire;
import net.minecraft.server.v1_12_R1.BlockTileEntity;
import net.minecraft.server.v1_12_R1.Blocks;
import net.minecraft.server.v1_12_R1.EnumDirection;
import net.minecraft.server.v1_12_R1.EnumSkyBlock;
import net.minecraft.server.v1_12_R1.GameProfileSerializer;
import net.minecraft.server.v1_12_R1.IBlockData;
import net.minecraft.server.v1_12_R1.IBlockState;
import net.minecraft.server.v1_12_R1.Item;
import net.minecraft.server.v1_12_R1.Items;
import net.minecraft.server.v1_12_R1.MinecraftKey;
import net.minecraft.server.v1_12_R1.NBTBase;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import net.minecraft.server.v1_12_R1.TileEntity;
import net.minecraft.server.v1_12_R1.TileEntitySkull;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.craftbukkit.v1_12_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBanner;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBeacon;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBed;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBrewingStand;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftChest;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftCommandBlock;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftComparator;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftDaylightDetector;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftDispenser;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftDropper;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftEnchantingTable;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftEndGateway;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftEnderChest;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftFlowerPot;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftFurnace;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftHopper;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftJukebox;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftNoteBlock;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftShulkerBox;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftSign;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftSkull;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftStructureBlock;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_12_R1.util.CraftMagicNumbers;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockVector;

public class CraftBlock
implements Block {
    private final CraftChunk chunk;
    private final int x;
    private final int y;
    private final int z;

    public CraftBlock(CraftChunk chunk, int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.chunk = chunk;
    }

    private net.minecraft.server.v1_12_R1.Block getNMSBlock() {
        return CraftMagicNumbers.getBlock(this);
    }

    private static net.minecraft.server.v1_12_R1.Block getNMSBlock(int type) {
        return CraftMagicNumbers.getBlock(type);
    }

    @Override
    public World getWorld() {
        return this.chunk.getWorld();
    }

    @Override
    public Location getLocation() {
        return new Location(this.getWorld(), this.x, this.y, this.z);
    }

    @Override
    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX(this.x);
            loc.setY(this.y);
            loc.setZ(this.z);
            loc.setYaw(0.0f);
            loc.setPitch(0.0f);
        }
        return loc;
    }

    public BlockVector getVector() {
        return new BlockVector(this.x, this.y, this.z);
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public Chunk getChunk() {
        return this.chunk;
    }

    @Override
    public void setData(byte data) {
        this.setData(data, 3);
    }

    @Override
    public void setData(byte data, boolean applyPhysics) {
        if (applyPhysics) {
            this.setData(data, 3);
        } else {
            this.setData(data, 2);
        }
    }

    private void setData(byte data, int flag) {
        net.minecraft.server.v1_12_R1.World world = this.chunk.getHandle().getWorld();
        BlockPosition position = new BlockPosition(this.x, this.y, this.z);
        IBlockData blockData = world.getType(position);
        world.setTypeAndData(position, blockData.getBlock().fromLegacyData((int)data), flag);
    }

    private IBlockData getData0() {
        return this.chunk.getHandle().getBlockData(new BlockPosition(this.x, this.y, this.z));
    }

    @Override
    public byte getData() {
        IBlockData blockData = this.chunk.getHandle().getBlockData(new BlockPosition(this.x, this.y, this.z));
        return (byte)blockData.getBlock().toLegacyData(blockData);
    }

    @Override
    public void setType(Material type) {
        this.setType(type, true);
    }

    @Override
    public void setType(Material type, boolean applyPhysics) {
        this.setTypeId(type.getId(), applyPhysics);
    }

    @Override
    public boolean setTypeId(int type) {
        return this.setTypeId(type, true);
    }

    @Override
    public boolean setTypeId(int type, boolean applyPhysics) {
        net.minecraft.server.v1_12_R1.Block block = CraftBlock.getNMSBlock(type);
        return this.setTypeIdAndData(type, (byte)block.toLegacyData(block.getBlockData()), applyPhysics);
    }

    @Override
    public boolean setTypeIdAndData(int type, byte data, boolean applyPhysics) {
        IBlockData blockData = CraftBlock.getNMSBlock(type).fromLegacyData((int)data);
        BlockPosition position = new BlockPosition(this.x, this.y, this.z);
        if (type != 0 && blockData.getBlock() instanceof BlockTileEntity && type != this.getTypeId()) {
            this.chunk.getHandle().getWorld().setTypeAndData(position, Blocks.AIR.getBlockData(), 0);
        }
        if (applyPhysics) {
            return this.chunk.getHandle().getWorld().setTypeAndData(position, blockData, 3);
        }
        IBlockData old = this.chunk.getHandle().getBlockData(position);
        boolean success = this.chunk.getHandle().getWorld().setTypeAndData(position, blockData, 18);
        if (success) {
            this.chunk.getHandle().getWorld().notify(position, old, blockData, 3);
        }
        return success;
    }

    @Override
    public Material getType() {
        return Material.getMaterial(this.getTypeId());
    }

    @Override
    @Deprecated
    public int getTypeId() {
        return CraftMagicNumbers.getId(this.chunk.getHandle().getBlockData(new BlockPosition(this.x, this.y, this.z)).getBlock());
    }

    @Override
    public byte getLightLevel() {
        return (byte)this.chunk.getHandle().getWorld().getLightLevel(new BlockPosition(this.x, this.y, this.z));
    }

    @Override
    public byte getLightFromSky() {
        return (byte)this.chunk.getHandle().getWorld().getBrightness(EnumSkyBlock.SKY, new BlockPosition(this.x, this.y, this.z));
    }

    @Override
    public byte getLightFromBlocks() {
        return (byte)this.chunk.getHandle().getWorld().getBrightness(EnumSkyBlock.BLOCK, new BlockPosition(this.x, this.y, this.z));
    }

    public Block getFace(BlockFace face) {
        return this.getRelative(face, 1);
    }

    public Block getFace(BlockFace face, int distance) {
        return this.getRelative(face, distance);
    }

    @Override
    public Block getRelative(int modX, int modY, int modZ) {
        return this.getWorld().getBlockAt(this.getX() + modX, this.getY() + modY, this.getZ() + modZ);
    }

    @Override
    public Block getRelative(BlockFace face) {
        return this.getRelative(face, 1);
    }

    @Override
    public Block getRelative(BlockFace face, int distance) {
        return this.getRelative(face.getModX() * distance, face.getModY() * distance, face.getModZ() * distance);
    }

    @Override
    public BlockFace getFace(Block block) {
        BlockFace[] values;
        BlockFace[] blockFaceArray = values = BlockFace.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            BlockFace face = blockFaceArray[n2];
            if (this.getX() + face.getModX() == block.getX() && this.getY() + face.getModY() == block.getY() && this.getZ() + face.getModZ() == block.getZ()) {
                return face;
            }
            ++n2;
        }
        return null;
    }

    public String toString() {
        return "CraftBlock{chunk=" + this.chunk + ",x=" + this.x + ",y=" + this.y + ",z=" + this.z + ",type=" + (Object)((Object)this.getType()) + ",data=" + this.getData() + '}';
    }

    public static BlockFace notchToBlockFace(EnumDirection notch) {
        if (notch == null) {
            return BlockFace.SELF;
        }
        switch (notch) {
            case DOWN: {
                return BlockFace.DOWN;
            }
            case UP: {
                return BlockFace.UP;
            }
            case NORTH: {
                return BlockFace.NORTH;
            }
            case SOUTH: {
                return BlockFace.SOUTH;
            }
            case WEST: {
                return BlockFace.WEST;
            }
            case EAST: {
                return BlockFace.EAST;
            }
        }
        return BlockFace.SELF;
    }

    public static EnumDirection blockFaceToNotch(BlockFace face) {
        switch (face) {
            case DOWN: {
                return EnumDirection.DOWN;
            }
            case UP: {
                return EnumDirection.UP;
            }
            case NORTH: {
                return EnumDirection.NORTH;
            }
            case SOUTH: {
                return EnumDirection.SOUTH;
            }
            case WEST: {
                return EnumDirection.WEST;
            }
            case EAST: {
                return EnumDirection.EAST;
            }
        }
        return null;
    }

    @Override
    public BlockState getState() {
        Material material = this.getType();
        switch (material) {
            case SIGN_POST: 
            case WALL_SIGN: 
            case SIGN: {
                return new CraftSign(this);
            }
            case CHEST: 
            case TRAPPED_CHEST: {
                return new CraftChest(this);
            }
            case FURNACE: 
            case BURNING_FURNACE: {
                return new CraftFurnace(this);
            }
            case DISPENSER: {
                return new CraftDispenser(this);
            }
            case DROPPER: {
                return new CraftDropper(this);
            }
            case END_GATEWAY: {
                return new CraftEndGateway(this);
            }
            case HOPPER: {
                return new CraftHopper(this);
            }
            case MOB_SPAWNER: {
                return new CraftCreatureSpawner(this);
            }
            case NOTE_BLOCK: {
                return new CraftNoteBlock(this);
            }
            case JUKEBOX: {
                return new CraftJukebox(this);
            }
            case BREWING_STAND: {
                return new CraftBrewingStand(this);
            }
            case SKULL: {
                return new CraftSkull(this);
            }
            case COMMAND: 
            case COMMAND_REPEATING: 
            case COMMAND_CHAIN: {
                return new CraftCommandBlock(this);
            }
            case BEACON: {
                return new CraftBeacon(this);
            }
            case STANDING_BANNER: 
            case WALL_BANNER: 
            case BANNER: {
                return new CraftBanner(this);
            }
            case FLOWER_POT: {
                return new CraftFlowerPot(this);
            }
            case STRUCTURE_BLOCK: {
                return new CraftStructureBlock(this);
            }
            case WHITE_SHULKER_BOX: 
            case ORANGE_SHULKER_BOX: 
            case MAGENTA_SHULKER_BOX: 
            case LIGHT_BLUE_SHULKER_BOX: 
            case YELLOW_SHULKER_BOX: 
            case LIME_SHULKER_BOX: 
            case PINK_SHULKER_BOX: 
            case GRAY_SHULKER_BOX: 
            case SILVER_SHULKER_BOX: 
            case CYAN_SHULKER_BOX: 
            case PURPLE_SHULKER_BOX: 
            case BLUE_SHULKER_BOX: 
            case BROWN_SHULKER_BOX: 
            case GREEN_SHULKER_BOX: 
            case RED_SHULKER_BOX: 
            case BLACK_SHULKER_BOX: {
                return new CraftShulkerBox(this);
            }
            case ENCHANTMENT_TABLE: {
                return new CraftEnchantingTable(this);
            }
            case ENDER_CHEST: {
                return new CraftEnderChest(this);
            }
            case DAYLIGHT_DETECTOR: 
            case DAYLIGHT_DETECTOR_INVERTED: {
                return new CraftDaylightDetector(this);
            }
            case REDSTONE_COMPARATOR_OFF: 
            case REDSTONE_COMPARATOR_ON: {
                return new CraftComparator(this);
            }
            case BED_BLOCK: {
                return new CraftBed(this);
            }
        }
        TileEntity tileEntity = this.chunk.getCraftWorld().getTileEntityAt(this.x, this.y, this.z);
        if (tileEntity != null) {
            return new CraftBlockEntityState((Block)this, tileEntity.getClass());
        }
        return new CraftBlockState(this);
    }

    @Override
    public Biome getBiome() {
        return this.getWorld().getBiome(this.x, this.z);
    }

    @Override
    public void setBiome(Biome bio) {
        this.getWorld().setBiome(this.x, this.z, bio);
    }

    public static Biome biomeBaseToBiome(BiomeBase base) {
        if (base == null) {
            return null;
        }
        return Biome.valueOf(((MinecraftKey)BiomeBase.REGISTRY_ID.b((Object)base)).getKey().toUpperCase(Locale.ENGLISH));
    }

    public static BiomeBase biomeToBiomeBase(Biome bio) {
        if (bio == null) {
            return null;
        }
        return (BiomeBase)BiomeBase.REGISTRY_ID.get((Object)new MinecraftKey(bio.name().toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public double getTemperature() {
        return this.getWorld().getTemperature(this.x, this.z);
    }

    @Override
    public double getHumidity() {
        return this.getWorld().getHumidity(this.x, this.z);
    }

    @Override
    public boolean isBlockPowered() {
        return this.chunk.getHandle().getWorld().getBlockPower(new BlockPosition(this.x, this.y, this.z)) > 0;
    }

    @Override
    public boolean isBlockIndirectlyPowered() {
        return this.chunk.getHandle().getWorld().isBlockIndirectlyPowered(new BlockPosition(this.x, this.y, this.z));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CraftBlock)) {
            return false;
        }
        CraftBlock other = (CraftBlock)o;
        return this.x == other.x && this.y == other.y && this.z == other.z && this.getWorld().equals(other.getWorld());
    }

    public int hashCode() {
        return this.y << 24 ^ this.x ^ this.z ^ this.getWorld().hashCode();
    }

    @Override
    public boolean isBlockFacePowered(BlockFace face) {
        return this.chunk.getHandle().getWorld().isBlockFacePowered(new BlockPosition(this.x, this.y, this.z), CraftBlock.blockFaceToNotch(face));
    }

    @Override
    public boolean isBlockFaceIndirectlyPowered(BlockFace face) {
        int power = this.chunk.getHandle().getWorld().getBlockFacePower(new BlockPosition(this.x, this.y, this.z), CraftBlock.blockFaceToNotch(face));
        Block relative = this.getRelative(face);
        if (relative.getType() == Material.REDSTONE_WIRE) {
            return Math.max(power, relative.getData()) > 0;
        }
        return power > 0;
    }

    @Override
    public int getBlockPower(BlockFace face) {
        int power = 0;
        BlockRedstoneWire wire = Blocks.REDSTONE_WIRE;
        net.minecraft.server.v1_12_R1.World world = this.chunk.getHandle().getWorld();
        if ((face == BlockFace.DOWN || face == BlockFace.SELF) && world.isBlockFacePowered(new BlockPosition(this.x, this.y - 1, this.z), EnumDirection.DOWN)) {
            power = wire.getPower(world, new BlockPosition(this.x, this.y - 1, this.z), power);
        }
        if ((face == BlockFace.UP || face == BlockFace.SELF) && world.isBlockFacePowered(new BlockPosition(this.x, this.y + 1, this.z), EnumDirection.UP)) {
            power = wire.getPower(world, new BlockPosition(this.x, this.y + 1, this.z), power);
        }
        if ((face == BlockFace.EAST || face == BlockFace.SELF) && world.isBlockFacePowered(new BlockPosition(this.x + 1, this.y, this.z), EnumDirection.EAST)) {
            power = wire.getPower(world, new BlockPosition(this.x + 1, this.y, this.z), power);
        }
        if ((face == BlockFace.WEST || face == BlockFace.SELF) && world.isBlockFacePowered(new BlockPosition(this.x - 1, this.y, this.z), EnumDirection.WEST)) {
            power = wire.getPower(world, new BlockPosition(this.x - 1, this.y, this.z), power);
        }
        if ((face == BlockFace.NORTH || face == BlockFace.SELF) && world.isBlockFacePowered(new BlockPosition(this.x, this.y, this.z - 1), EnumDirection.NORTH)) {
            power = wire.getPower(world, new BlockPosition(this.x, this.y, this.z - 1), power);
        }
        if ((face == BlockFace.SOUTH || face == BlockFace.SELF) && world.isBlockFacePowered(new BlockPosition(this.x, this.y, this.z + 1), EnumDirection.SOUTH)) {
            power = wire.getPower(world, new BlockPosition(this.x, this.y, this.z - 1), power);
        }
        return power > 0 ? power : ((face == BlockFace.SELF ? this.isBlockIndirectlyPowered() : this.isBlockFaceIndirectlyPowered(face)) ? 15 : 0);
    }

    @Override
    public int getBlockPower() {
        return this.getBlockPower(BlockFace.SELF);
    }

    @Override
    public boolean isEmpty() {
        return this.getType() == Material.AIR;
    }

    @Override
    public boolean isLiquid() {
        return this.getType() == Material.WATER || this.getType() == Material.STATIONARY_WATER || this.getType() == Material.LAVA || this.getType() == Material.STATIONARY_LAVA;
    }

    @Override
    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.getById(this.getNMSBlock().h(this.getNMSBlock().fromLegacyData((int)this.getData())).ordinal());
    }

    private boolean itemCausesDrops(ItemStack item) {
        Item itemType;
        net.minecraft.server.v1_12_R1.Block block = this.getNMSBlock();
        Item item2 = itemType = item != null ? Item.getById((int)item.getTypeId()) : null;
        return block != null && (block.getBlockData().getMaterial().isAlwaysDestroyable() || itemType != null && itemType.canDestroySpecialBlock(block.getBlockData()));
    }

    @Override
    public boolean breakNaturally() {
        net.minecraft.server.v1_12_R1.Block block = this.getNMSBlock();
        byte data = this.getData();
        boolean result = false;
        if (block != null && block != Blocks.AIR) {
            block.dropNaturally(this.chunk.getHandle().getWorld(), new BlockPosition(this.x, this.y, this.z), block.fromLegacyData((int)data), 1.0f, 0);
            result = true;
        }
        this.setTypeId(Material.AIR.getId());
        return result;
    }

    @Override
    public boolean breakNaturally(ItemStack item) {
        if (this.itemCausesDrops(item)) {
            return this.breakNaturally();
        }
        return this.setTypeId(Material.AIR.getId());
    }

    @Override
    public Collection<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        net.minecraft.server.v1_12_R1.Block block = this.getNMSBlock();
        if (block != Blocks.AIR) {
            IBlockData data = this.getData0();
            int count = block.getDropCount(0, this.chunk.getHandle().getWorld().random);
            int i = 0;
            while (i < count) {
                Item item = block.getDropType(data, this.chunk.getHandle().getWorld().random, 0);
                if (item != Items.a) {
                    if (Blocks.SKULL == block) {
                        net.minecraft.server.v1_12_R1.ItemStack nmsStack = new net.minecraft.server.v1_12_R1.ItemStack(item, 1, block.getDropData(data));
                        TileEntitySkull tileentityskull = (TileEntitySkull)this.chunk.getHandle().getWorld().getTileEntity(new BlockPosition(this.x, this.y, this.z));
                        if (tileentityskull.getSkullType() == 3 && tileentityskull.getGameProfile() != null) {
                            nmsStack.setTag(new NBTTagCompound());
                            NBTTagCompound nbttagcompound = new NBTTagCompound();
                            GameProfileSerializer.serialize((NBTTagCompound)nbttagcompound, (GameProfile)tileentityskull.getGameProfile());
                            nmsStack.getTag().set("SkullOwner", (NBTBase)nbttagcompound);
                        }
                        drops.add(CraftItemStack.asBukkitCopy(nmsStack));
                    } else if (Blocks.COCOA == block) {
                        int age = (Integer)data.get((IBlockState)BlockCocoa.AGE);
                        int dropAmount = age >= 2 ? 3 : 1;
                        int j = 0;
                        while (j < dropAmount) {
                            drops.add(new ItemStack(Material.INK_SACK, 1, 3));
                            ++j;
                        }
                    } else {
                        drops.add(new ItemStack(CraftMagicNumbers.getMaterial(item), 1, (short)block.getDropData(data)));
                    }
                }
                ++i;
            }
        }
        return drops;
    }

    @Override
    public Collection<ItemStack> getDrops(ItemStack item) {
        if (this.itemCausesDrops(item)) {
            return this.getDrops();
        }
        return Collections.emptyList();
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.chunk.getCraftWorld().getBlockMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.chunk.getCraftWorld().getBlockMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.chunk.getCraftWorld().getBlockMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.chunk.getCraftWorld().getBlockMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }
}

