/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.block;

import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import net.minecraft.server.v1_12_R1.TileEntity;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBlockState;

public class CraftBlockEntityState<T extends TileEntity>
extends CraftBlockState {
    private final Class<T> tileEntityClass;
    private final T tileEntity;
    private final T snapshot;

    public CraftBlockEntityState(Block block, Class<T> tileEntityClass) {
        super(block);
        this.tileEntityClass = tileEntityClass;
        CraftWorld world = (CraftWorld)this.getWorld();
        this.tileEntity = (TileEntity)tileEntityClass.cast(world.getTileEntityAt(this.getX(), this.getY(), this.getZ()));
        this.snapshot = this.createSnapshot(this.tileEntity);
        this.load(this.snapshot);
    }

    public CraftBlockEntityState(Material material, T tileEntity) {
        super(material);
        this.tileEntityClass = tileEntity.getClass();
        this.tileEntity = tileEntity;
        this.snapshot = this.createSnapshot(tileEntity);
        this.load(this.snapshot);
    }

    private T createSnapshot(T tileEntity) {
        if (tileEntity == null) {
            return null;
        }
        NBTTagCompound nbtTagCompound = tileEntity.save(new NBTTagCompound());
        TileEntity snapshot = TileEntity.create(null, (NBTTagCompound)nbtTagCompound);
        return (T)snapshot;
    }

    private void copyData(T from, T to) {
        BlockPosition pos = to.getPosition();
        NBTTagCompound nbtTagCompound = from.save(new NBTTagCompound());
        to.load(nbtTagCompound);
        to.setPosition(pos);
    }

    protected T getTileEntity() {
        return this.tileEntity;
    }

    protected T getSnapshot() {
        return this.snapshot;
    }

    protected TileEntity getTileEntityFromWorld() {
        this.requirePlaced();
        return ((CraftWorld)this.getWorld()).getTileEntityAt(this.getX(), this.getY(), this.getZ());
    }

    public NBTTagCompound getSnapshotNBT() {
        this.applyTo(this.snapshot);
        return this.snapshot.save(new NBTTagCompound());
    }

    protected void load(T tileEntity) {
        if (tileEntity != null && tileEntity != this.snapshot) {
            this.copyData(tileEntity, this.snapshot);
        }
    }

    protected void applyTo(T tileEntity) {
        if (tileEntity != null && tileEntity != this.snapshot) {
            this.copyData(this.snapshot, tileEntity);
        }
    }

    protected boolean isApplicable(TileEntity tileEntity) {
        return this.tileEntityClass.isInstance(tileEntity);
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        TileEntity tile;
        boolean result = super.update(force, applyPhysics);
        if (result && this.isPlaced() && this.isApplicable(tile = this.getTileEntityFromWorld())) {
            this.applyTo((TileEntity)this.tileEntityClass.cast(tile));
            tile.update();
        }
        return result;
    }
}

