/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.block;

import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.IInventory;
import net.minecraft.server.v1_12_R1.TileEntityChest;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftLootable;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftInventoryDoubleChest;
import org.bukkit.inventory.Inventory;

public class CraftChest
extends CraftLootable<TileEntityChest>
implements Chest {
    public CraftChest(Block block) {
        super(block, TileEntityChest.class);
    }

    public CraftChest(Material material, TileEntityChest te) {
        super(material, te);
    }

    @Override
    public Inventory getSnapshotInventory() {
        return new CraftInventory((IInventory)this.getSnapshot());
    }

    @Override
    public Inventory getBlockInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventory((IInventory)this.getTileEntity());
    }

    @Override
    public Inventory getInventory() {
        CraftInventory right;
        CraftInventory left;
        int id;
        CraftInventory inventory = (CraftInventory)this.getBlockInventory();
        if (!this.isPlaced()) {
            return inventory;
        }
        int x = this.getX();
        int y = this.getY();
        int z = this.getZ();
        CraftWorld world = (CraftWorld)this.getWorld();
        if (world.getBlockTypeIdAt(x, y, z) == Material.CHEST.getId()) {
            id = Material.CHEST.getId();
        } else if (world.getBlockTypeIdAt(x, y, z) == Material.TRAPPED_CHEST.getId()) {
            id = Material.TRAPPED_CHEST.getId();
        } else {
            throw new IllegalStateException("CraftChest is not a chest but is instead " + world.getBlockAt(x, y, z));
        }
        if (world.getBlockTypeIdAt(x - 1, y, z) == id) {
            left = new CraftInventory((IInventory)((TileEntityChest)world.getHandle().getTileEntity(new BlockPosition(x - 1, y, z))));
            inventory = new CraftInventoryDoubleChest(left, inventory);
        }
        if (world.getBlockTypeIdAt(x + 1, y, z) == id) {
            right = new CraftInventory((IInventory)((TileEntityChest)world.getHandle().getTileEntity(new BlockPosition(x + 1, y, z))));
            inventory = new CraftInventoryDoubleChest(inventory, right);
        }
        if (world.getBlockTypeIdAt(x, y, z - 1) == id) {
            left = new CraftInventory((IInventory)((TileEntityChest)world.getHandle().getTileEntity(new BlockPosition(x, y, z - 1))));
            inventory = new CraftInventoryDoubleChest(left, inventory);
        }
        if (world.getBlockTypeIdAt(x, y, z + 1) == id) {
            right = new CraftInventory((IInventory)((TileEntityChest)world.getHandle().getTileEntity(new BlockPosition(x, y, z + 1))));
            inventory = new CraftInventoryDoubleChest(inventory, right);
        }
        return inventory;
    }
}

