/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.block;

import net.minecraft.server.v1_12_R1.BlockJukeBox;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.Blocks;
import net.minecraft.server.v1_12_R1.IBlockState;
import net.minecraft.server.v1_12_R1.ItemStack;
import net.minecraft.server.v1_12_R1.TileEntity;
import net.minecraft.server.v1_12_R1.World;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Jukebox;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_12_R1.util.CraftMagicNumbers;

public class CraftJukebox
extends CraftBlockEntityState<BlockJukeBox.TileEntityRecordPlayer>
implements Jukebox {
    public CraftJukebox(Block block) {
        super(block, BlockJukeBox.TileEntityRecordPlayer.class);
    }

    public CraftJukebox(Material material, BlockJukeBox.TileEntityRecordPlayer te) {
        super(material, te);
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        boolean result = super.update(force, applyPhysics);
        if (result && this.isPlaced() && this.getType() == Material.JUKEBOX) {
            CraftWorld world = (CraftWorld)this.getWorld();
            Material record = this.getPlaying();
            if (record == Material.AIR) {
                world.getHandle().setTypeAndData(new BlockPosition(this.getX(), this.getY(), this.getZ()), Blocks.JUKEBOX.getBlockData().set((IBlockState)BlockJukeBox.HAS_RECORD, (Comparable)Boolean.valueOf(false)), 3);
            } else {
                world.getHandle().setTypeAndData(new BlockPosition(this.getX(), this.getY(), this.getZ()), Blocks.JUKEBOX.getBlockData().set((IBlockState)BlockJukeBox.HAS_RECORD, (Comparable)Boolean.valueOf(true)), 3);
            }
            world.playEffect(this.getLocation(), Effect.RECORD_PLAY, record.getId());
        }
        return result;
    }

    @Override
    public Material getPlaying() {
        ItemStack record = ((BlockJukeBox.TileEntityRecordPlayer)this.getSnapshot()).getRecord();
        if (record.isEmpty()) {
            return Material.AIR;
        }
        return CraftMagicNumbers.getMaterial(record.getItem());
    }

    @Override
    public void setPlaying(Material record) {
        if (record == null || CraftMagicNumbers.getItem(record) == null) {
            record = Material.AIR;
        }
        ((BlockJukeBox.TileEntityRecordPlayer)this.getSnapshot()).setRecord(new ItemStack(CraftMagicNumbers.getItem(record), 1));
        if (record == Material.AIR) {
            this.setRawData((byte)0);
        } else {
            this.setRawData((byte)1);
        }
    }

    @Override
    public boolean isPlaying() {
        return this.getRawData() == 1;
    }

    @Override
    public boolean eject() {
        this.requirePlaced();
        TileEntity tileEntity = this.getTileEntityFromWorld();
        if (!(tileEntity instanceof BlockJukeBox.TileEntityRecordPlayer)) {
            return false;
        }
        BlockJukeBox.TileEntityRecordPlayer jukebox = (BlockJukeBox.TileEntityRecordPlayer)tileEntity;
        boolean result = !jukebox.getRecord().isEmpty();
        CraftWorld world = (CraftWorld)this.getWorld();
        ((BlockJukeBox)Blocks.JUKEBOX).dropRecord((World)world.getHandle(), new BlockPosition(this.getX(), this.getY(), this.getZ()), null);
        return result;
    }
}

