/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.block;

import net.minecraft.server.v1_12_R1.ChatComponentText;
import net.minecraft.server.v1_12_R1.IChatBaseComponent;
import net.minecraft.server.v1_12_R1.TileEntitySign;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_12_R1.util.CraftChatMessage;

public class CraftSign
extends CraftBlockEntityState<TileEntitySign>
implements Sign {
    private String[] lines;

    public CraftSign(Block block) {
        super(block, TileEntitySign.class);
    }

    public CraftSign(Material material, TileEntitySign te) {
        super(material, te);
    }

    @Override
    public void load(TileEntitySign sign) {
        super.load(sign);
        this.lines = new String[sign.lines.length];
        System.arraycopy(CraftSign.revertComponents(sign.lines), 0, this.lines, 0, this.lines.length);
    }

    @Override
    public String[] getLines() {
        return this.lines;
    }

    @Override
    public String getLine(int index) throws IndexOutOfBoundsException {
        return this.lines[index];
    }

    @Override
    public void setLine(int index, String line) throws IndexOutOfBoundsException {
        this.lines[index] = line;
    }

    @Override
    public void applyTo(TileEntitySign sign) {
        super.applyTo(sign);
        IChatBaseComponent[] newLines = CraftSign.sanitizeLines(this.lines);
        System.arraycopy(newLines, 0, sign.lines, 0, 4);
    }

    public static IChatBaseComponent[] sanitizeLines(String[] lines) {
        IChatBaseComponent[] components = new IChatBaseComponent[4];
        int i = 0;
        while (i < 4) {
            components[i] = i < lines.length && lines[i] != null ? CraftChatMessage.fromString(lines[i])[0] : new ChatComponentText("");
            ++i;
        }
        return components;
    }

    public static String[] revertComponents(IChatBaseComponent[] components) {
        String[] lines = new String[components.length];
        int i = 0;
        while (i < lines.length) {
            lines[i] = CraftSign.revertComponent(components[i]);
            ++i;
        }
        return lines;
    }

    private static String revertComponent(IChatBaseComponent component) {
        return CraftChatMessage.fromComponent(component);
    }
}

